/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.distribution.continuous.GammaDistribution;

public class ChiSquaredDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20160320L;
    private final GammaDistribution gamma;

    public ChiSquaredDistribution(double degreesOfFreedom) {
        this(degreesOfFreedom, 1.0E-9);
    }

    public ChiSquaredDistribution(double degreesOfFreedom, double inverseCumAccuracy) {
        super(inverseCumAccuracy);
        this.gamma = new GammaDistribution(degreesOfFreedom / 2.0, 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.gamma.getShape() * 2.0;
    }

    @Override
    public double density(double x) {
        return this.gamma.density(x);
    }

    @Override
    public double logDensity(double x) {
        return this.gamma.logDensity(x);
    }

    @Override
    public double cumulativeProbability(double x) {
        return this.gamma.cumulativeProbability(x);
    }

    @Override
    public double getNumericalMean() {
        return this.getDegreesOfFreedom();
    }

    @Override
    public double getNumericalVariance() {
        return 2.0 * this.getDegreesOfFreedom();
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

