/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.utils;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class RoughVisibilityEstimator {
    private final OneAxisEllipsoid ellipsoid;
    private final List<TimeStampedPVCoordinates> pvGround;
    private final double rateVSIndices;
    private final double rateVSTime;
    private int last;

    public RoughVisibilityEstimator(OneAxisEllipsoid ellipsoid, Frame frame, List<TimeStampedPVCoordinates> positionsVelocities) {
        this.ellipsoid = ellipsoid;
        Frame bodyFrame = ellipsoid.getBodyFrame();
        int n = positionsVelocities.size();
        this.pvGround = new ArrayList<TimeStampedPVCoordinates>(n);
        for (TimeStampedPVCoordinates pv : positionsVelocities) {
            Transform t = frame.getTransformTo(bodyFrame, pv.getDate());
            this.pvGround.add(ellipsoid.projectToGround(t.transformPVCoordinates(pv), bodyFrame));
        }
        this.last = n / 2;
        double alpha = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            alpha += Vector3D.angle((Vector3D)this.pvGround.get(i).getPosition(), (Vector3D)this.pvGround.get(i + 1).getPosition());
        }
        this.rateVSIndices = alpha / (double)n;
        AbsoluteDate firstDate = this.pvGround.get(0).getDate();
        AbsoluteDate lastDate = this.pvGround.get(this.pvGround.size() - 1).getDate();
        this.rateVSTime = alpha / lastDate.durationFrom(firstDate);
    }

    public AbsoluteDate estimateVisibility(GeodeticPoint groundPoint) {
        int otherIndex;
        int index;
        Vector3D point = this.ellipsoid.transform(groundPoint);
        int closeIndex = this.findClose(this.last, point);
        int repeat = (int)FastMath.rint((double)(Math.PI * 2 / this.rateVSIndices));
        for (index = closeIndex - repeat; index > 0; index -= repeat) {
            otherIndex = this.findClose(index, point);
            if (otherIndex == closeIndex || !(Vector3D.distance((Vector3D)this.pvGround.get(otherIndex).getPosition(), (Vector3D)point) < Vector3D.distance((Vector3D)this.pvGround.get(closeIndex).getPosition(), (Vector3D)point))) continue;
            closeIndex = otherIndex;
        }
        for (index = closeIndex + repeat; index < this.pvGround.size(); index += repeat) {
            otherIndex = this.findClose(index, point);
            if (otherIndex == closeIndex || !(Vector3D.distance((Vector3D)this.pvGround.get(otherIndex).getPosition(), (Vector3D)point) < Vector3D.distance((Vector3D)this.pvGround.get(closeIndex).getPosition(), (Vector3D)point))) continue;
            closeIndex = otherIndex;
        }
        this.last = closeIndex;
        TimeStampedPVCoordinates closest = this.pvGround.get(closeIndex);
        double alpha = this.neededMotion(closest, point);
        return closest.getDate().shiftedBy(alpha / this.rateVSTime);
    }

    private int findClose(int start, Vector3D point) {
        int current = start;
        int previous = Integer.MIN_VALUE;
        int maxLoop = 1000;
        while (maxLoop-- > 0 && FastMath.abs((int)(current - previous)) > 1) {
            previous = current;
            double alpha = this.neededMotion(this.pvGround.get(current), point);
            int shift = (int)FastMath.rint((double)(alpha / this.rateVSIndices));
            current = FastMath.max((int)0, (int)FastMath.min((int)(this.pvGround.size() - 1), (int)(current + shift)));
        }
        return current;
    }

    private double neededMotion(TimeStampedPVCoordinates subSatellite, Vector3D point) {
        Vector3D ssP = subSatellite.getPosition();
        Vector3D momentum = subSatellite.getMomentum();
        double y = Vector3D.dotProduct((Vector3D)point, (Vector3D)Vector3D.crossProduct((Vector3D)momentum, (Vector3D)ssP).normalize());
        double x = Vector3D.dotProduct((Vector3D)point, (Vector3D)ssP.normalize());
        return FastMath.atan2((double)y, (double)x);
    }
}

