/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.Arrays;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldCartesianOrbit<T extends RealFieldElement<T>>
extends FieldOrbit<T> {
    private final transient boolean hasNonKeplerianAcceleration;
    private transient FieldEquinoctialOrbit<T> equinoctial;
    private final Field<T> field;
    private final T zero;
    private final T one;

    public FieldCartesianOrbit(TimeStampedFieldPVCoordinates<T> pvaCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvaCoordinates, frame, mu);
        this.hasNonKeplerianAcceleration = FieldCartesianOrbit.hasNonKeplerianAcceleration(pvaCoordinates, mu);
        this.equinoctial = null;
        this.field = pvaCoordinates.getPosition().getX().getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
    }

    public FieldCartesianOrbit(FieldPVCoordinates<T> pvaCoordinates, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, pvaCoordinates), frame, mu);
    }

    public FieldCartesianOrbit(FieldOrbit<T> op) {
        super(op.getPVCoordinates(), op.getFrame(), op.getMu());
        this.hasNonKeplerianAcceleration = op.hasDerivatives();
        this.equinoctial = op instanceof FieldEquinoctialOrbit ? (FieldEquinoctialOrbit)op : (op instanceof FieldCartesianOrbit ? ((FieldCartesianOrbit)op).equinoctial : null);
        this.field = op.getA().getField();
        this.zero = (RealFieldElement)this.field.getZero();
        this.one = (RealFieldElement)this.field.getOne();
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CARTESIAN;
    }

    private void initEquinoctial() {
        if (this.equinoctial == null) {
            this.equinoctial = this.hasDerivatives() ? new FieldEquinoctialOrbit(this.getPVCoordinates(), this.getFrame(), this.getDate(), this.getMu()) : new FieldEquinoctialOrbit(new FieldPVCoordinates(this.getPVCoordinates().getPosition(), this.getPVCoordinates().getVelocity()), this.getFrame(), this.getDate(), this.getMu());
        }
    }

    private FieldPVCoordinates<FieldUnivariateDerivative2<T>> getPVDerivatives() {
        TimeStampedFieldPVCoordinates pva = this.getPVCoordinates();
        FieldVector3D p = pva.getPosition();
        FieldVector3D v = pva.getVelocity();
        FieldVector3D a = pva.getAcceleration();
        FieldVector3D pG = new FieldVector3D((RealFieldElement)new FieldUnivariateDerivative2(p.getX(), v.getX(), a.getX()), (RealFieldElement)new FieldUnivariateDerivative2(p.getY(), v.getY(), a.getY()), (RealFieldElement)new FieldUnivariateDerivative2(p.getZ(), v.getZ(), a.getZ()));
        FieldVector3D vG = new FieldVector3D((RealFieldElement)new FieldUnivariateDerivative2(v.getX(), a.getX(), this.zero), (RealFieldElement)new FieldUnivariateDerivative2(v.getY(), a.getY(), this.zero), (RealFieldElement)new FieldUnivariateDerivative2(v.getZ(), a.getZ(), this.zero));
        return new FieldPVCoordinates<FieldUnivariateDerivative2<T>>(pG, vG);
    }

    @Override
    public T getA() {
        RealFieldElement r = this.getPVCoordinates().getPosition().getNorm();
        RealFieldElement V2 = this.getPVCoordinates().getVelocity().getNormSq();
        return (T)((RealFieldElement)r.divide(((RealFieldElement)((RealFieldElement)((RealFieldElement)r.negate()).multiply((Object)V2)).divide(this.getMu())).add(2.0)));
    }

    @Override
    public T getADot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldUnivariateDerivative2 r = (FieldUnivariateDerivative2)pv.getPosition().getNorm();
            FieldUnivariateDerivative2 V2 = (FieldUnivariateDerivative2)pv.getVelocity().getNormSq();
            FieldUnivariateDerivative2 a = r.divide(r.multiply(V2).divide(this.getMu()).subtract(2.0).negate());
            return (T)a.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getE() {
        RealFieldElement muA = (RealFieldElement)this.getA().multiply(this.getMu());
        if (muA.getReal() > 0.0) {
            FieldVector3D pvP = this.getPVCoordinates().getPosition();
            FieldVector3D pvV = this.getPVCoordinates().getVelocity();
            RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)pvP.getNorm().multiply((Object)pvV.getNormSq())).divide(this.getMu());
            RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(muA.sqrt());
            RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)eCE.multiply((Object)eCE)).add(eSE.multiply((Object)eSE))).sqrt());
        }
        FieldVector3D pvM = this.getPVCoordinates().getMomentum();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)pvM.getNormSq().divide((Object)muA)).negate()).add(1.0)).sqrt());
    }

    @Override
    public T getEDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldUnivariateDerivative2 r = (FieldUnivariateDerivative2)pv.getPosition().getNorm();
            FieldUnivariateDerivative2 V2 = (FieldUnivariateDerivative2)pv.getVelocity().getNormSq();
            FieldUnivariateDerivative2 rV2OnMu = r.multiply(V2).divide(this.getMu());
            FieldUnivariateDerivative2 a = r.divide(rV2OnMu.negate().add(2.0));
            FieldUnivariateDerivative2 eSE = ((FieldUnivariateDerivative2)FieldVector3D.dotProduct(pv.getPosition(), pv.getVelocity())).divide(a.multiply(this.getMu()).sqrt());
            FieldUnivariateDerivative2 eCE = rV2OnMu.subtract(1.0);
            FieldUnivariateDerivative2 e = eCE.multiply(eCE).add(eSE.multiply(eSE)).sqrt();
            return (T)e.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getI() {
        return (T)FieldVector3D.angle((FieldVector3D)new FieldVector3D(this.zero, this.zero, this.one), this.getPVCoordinates().getMomentum());
    }

    @Override
    public T getIDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldVector3D momentum = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity());
            FieldUnivariateDerivative2 i = (FieldUnivariateDerivative2)FieldVector3D.angle((Vector3D)Vector3D.PLUS_K, (FieldVector3D)momentum);
            return (T)i.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getEquinoctialEx() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEx();
    }

    @Override
    public T getEquinoctialExDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialExDot();
    }

    @Override
    public T getEquinoctialEy() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEy();
    }

    @Override
    public T getEquinoctialEyDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEyDot();
    }

    @Override
    public T getHx() {
        FieldVector3D w = this.getPVCoordinates().getMomentum().normalize();
        double x = w.getX().getReal();
        double y = w.getY().getReal();
        double z = w.getZ().getReal();
        if (x * x + y * y == 0.0 && z < 0.0) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)w.getY().negate()).divide(w.getZ().add(1.0)));
    }

    @Override
    public T getHxDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldVector3D w = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity()).normalize();
            double x = ((FieldUnivariateDerivative2)w.getX()).getValue().getReal();
            double y = ((FieldUnivariateDerivative2)w.getY()).getValue().getReal();
            double z = ((FieldUnivariateDerivative2)w.getZ()).getValue().getReal();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return (T)((RealFieldElement)this.zero.add(Double.NaN));
            }
            FieldUnivariateDerivative2 hx = ((FieldUnivariateDerivative2)w.getY()).negate().divide(((FieldUnivariateDerivative2)w.getZ()).add(1.0));
            return (T)hx.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getHy() {
        FieldVector3D w = this.getPVCoordinates().getMomentum().normalize();
        double x = w.getX().getReal();
        double y = w.getY().getReal();
        double z = w.getZ().getReal();
        if (x * x + y * y == 0.0 && z < 0.0) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)w.getX().divide(w.getZ().add(1.0)));
    }

    @Override
    public T getHyDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldVector3D w = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity()).normalize();
            double x = ((FieldUnivariateDerivative2)w.getX()).getValue().getReal();
            double y = ((FieldUnivariateDerivative2)w.getY()).getValue().getReal();
            double z = ((FieldUnivariateDerivative2)w.getZ()).getValue().getReal();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return (T)((RealFieldElement)this.zero.add(Double.NaN));
            }
            FieldUnivariateDerivative2 hy = ((FieldUnivariateDerivative2)w.getX()).divide(((FieldUnivariateDerivative2)w.getZ()).add(1.0));
            return (T)hy.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getLv() {
        this.initEquinoctial();
        return this.equinoctial.getLv();
    }

    @Override
    public T getLvDot() {
        this.initEquinoctial();
        return this.equinoctial.getLvDot();
    }

    @Override
    public T getLE() {
        this.initEquinoctial();
        return this.equinoctial.getLE();
    }

    @Override
    public T getLEDot() {
        this.initEquinoctial();
        return this.equinoctial.getLEDot();
    }

    @Override
    public T getLM() {
        this.initEquinoctial();
        return this.equinoctial.getLM();
    }

    @Override
    public T getLMDot() {
        this.initEquinoctial();
        return this.equinoctial.getLMDot();
    }

    @Override
    public boolean hasDerivatives() {
        return this.hasNonKeplerianAcceleration;
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        return this.getPVCoordinates();
    }

    @Override
    public FieldCartesianOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldCartesianOrbit<T> shiftedBy(T dt) {
        FieldPVCoordinates<T> shiftedPV = this.getA().getReal() < 0.0 ? this.shiftPVHyperbolic(dt) : this.shiftPVElliptic(dt);
        return new FieldCartesianOrbit<T>(shiftedPV, this.getFrame(), this.getDate().shiftedBy(dt), this.getMu());
    }

    @Override
    public FieldCartesianOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        TimeStampedFieldPVCoordinates<T> interpolated = TimeStampedFieldPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_PVA, sample.map(orbit -> orbit.getPVCoordinates()));
        return new FieldCartesianOrbit<T>(interpolated, this.getFrame(), date, this.getMu());
    }

    private FieldPVCoordinates<T> shiftPVElliptic(T dt) {
        FieldVector3D pvP = this.getPVCoordinates().getPosition();
        FieldVector3D pvV = this.getPVCoordinates().getVelocity();
        RealFieldElement r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply((Object)pvV.getNormSq())).divide(this.getMu());
        RealFieldElement a = (RealFieldElement)r.divide(((RealFieldElement)rV2OnMu.negate()).add(2.0));
        RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)a.multiply(this.getMu())).sqrt());
        RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
        RealFieldElement e2 = (RealFieldElement)((RealFieldElement)eCE.multiply((Object)eCE)).add(eSE.multiply((Object)eSE));
        FieldVector3D u = pvP.normalize();
        FieldVector3D v = FieldVector3D.crossProduct((FieldVector3D)FieldVector3D.crossProduct(pvP, pvV), (FieldVector3D)u).normalize();
        RealFieldElement ex = (RealFieldElement)((RealFieldElement)((RealFieldElement)eCE.subtract((Object)e2)).multiply((Object)a)).divide((Object)r);
        RealFieldElement s = (RealFieldElement)((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt();
        RealFieldElement ey = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)s.negate()).multiply((Object)eSE)).multiply((Object)a)).divide((Object)r);
        RealFieldElement beta = (RealFieldElement)((RealFieldElement)s.add(1.0)).reciprocal();
        RealFieldElement thetaE0 = (RealFieldElement)((RealFieldElement)ey.add(((RealFieldElement)eSE.multiply((Object)beta)).multiply((Object)ex))).atan2(((RealFieldElement)((RealFieldElement)r.divide((Object)a)).add((Object)ex)).subtract(((RealFieldElement)eSE.multiply((Object)beta)).multiply((Object)ey)));
        FieldSinCos scThetaE0 = FastMath.sinCos((RealFieldElement)thetaE0);
        RealFieldElement thetaM0 = (RealFieldElement)((RealFieldElement)thetaE0.subtract(ex.multiply(scThetaE0.sin()))).add(ey.multiply(scThetaE0.cos()));
        RealFieldElement sqrtMmuOA = (RealFieldElement)((RealFieldElement)((RealFieldElement)a.reciprocal()).multiply(this.getMu())).sqrt();
        RealFieldElement thetaM1 = (RealFieldElement)thetaM0.add(((RealFieldElement)sqrtMmuOA.divide((Object)a)).multiply(dt));
        RealFieldElement thetaE1 = this.meanToEccentric(thetaM1, ex, ey);
        FieldSinCos scTE = FastMath.sinCos((RealFieldElement)thetaE1);
        RealFieldElement cTE = (RealFieldElement)scTE.cos();
        RealFieldElement sTE = (RealFieldElement)scTE.sin();
        RealFieldElement exey = (RealFieldElement)ex.multiply((Object)ey);
        RealFieldElement exCeyS = (RealFieldElement)((RealFieldElement)ex.multiply((Object)cTE)).add(ey.multiply((Object)sTE));
        RealFieldElement x = (RealFieldElement)a.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.multiply((Object)ey)).multiply((Object)ey)).negate()).add(1.0)).multiply((Object)cTE)).add(((RealFieldElement)beta.multiply((Object)exey)).multiply((Object)sTE))).subtract((Object)ex));
        RealFieldElement y = (RealFieldElement)a.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.multiply((Object)ex)).multiply((Object)ex)).negate()).add(1.0)).multiply((Object)sTE)).add(((RealFieldElement)beta.multiply((Object)exey)).multiply((Object)cTE))).subtract((Object)ey));
        RealFieldElement factor = (RealFieldElement)sqrtMmuOA.divide(((RealFieldElement)exCeyS.negate()).add(1.0));
        RealFieldElement xDot = (RealFieldElement)factor.multiply(((RealFieldElement)((RealFieldElement)beta.multiply((Object)ey)).multiply((Object)exCeyS)).subtract((Object)sTE));
        RealFieldElement yDot = (RealFieldElement)factor.multiply(cTE.subtract(((RealFieldElement)beta.multiply((Object)ex)).multiply((Object)exCeyS)));
        FieldVector3D shiftedP = new FieldVector3D(x, u, y, v);
        FieldVector3D shiftedV = new FieldVector3D(xDot, u, yDot, v);
        if (this.hasNonKeplerianAcceleration) {
            FieldVector3D nonKeplerianAcceleration = new FieldVector3D(this.one, this.getPVCoordinates().getAcceleration(), (RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply((Object)r2)).reciprocal()).multiply(this.getMu()), pvP);
            FieldVector3D fixedP = new FieldVector3D(this.one, shiftedP, (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, shiftedV, dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)fixedR.multiply((Object)fixedR2)).reciprocal()).multiply(this.getMu().negate()), shiftedP, this.one, nonKeplerianAcceleration);
            return new FieldPVCoordinates(fixedP, fixedV, fixedA);
        }
        return new FieldPVCoordinates(shiftedP, shiftedV);
    }

    private FieldPVCoordinates<T> shiftPVHyperbolic(T dt) {
        TimeStampedFieldPVCoordinates pv = this.getPVCoordinates();
        FieldVector3D pvP = pv.getPosition();
        FieldVector3D pvV = pv.getVelocity();
        FieldVector3D pvM = pv.getMomentum();
        RealFieldElement r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply((Object)pvV.getNormSq())).divide(this.getMu());
        T a = this.getA();
        RealFieldElement muA = (RealFieldElement)a.multiply(this.getMu());
        RealFieldElement e = (RealFieldElement)((RealFieldElement)this.one.subtract(FieldVector3D.dotProduct(pvM, pvM).divide((Object)muA))).sqrt();
        RealFieldElement sqrt = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.add(1.0)).divide(e.subtract(1.0))).sqrt();
        RealFieldElement eSH = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)muA.negate()).sqrt());
        RealFieldElement eCH = (RealFieldElement)rV2OnMu.subtract(1.0);
        RealFieldElement H0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)eCH.add((Object)eSH)).divide(eCH.subtract((Object)eSH))).log()).divide(2.0);
        RealFieldElement M0 = (RealFieldElement)((RealFieldElement)e.multiply(H0.sinh())).subtract((Object)H0);
        RealFieldElement v0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)sqrt.multiply(((RealFieldElement)H0.divide(2.0)).tanh())).atan()).multiply(2);
        FieldVector3D p = new FieldRotation(pvM, v0, RotationConvention.FRAME_TRANSFORM).applyTo(pvP).normalize();
        FieldVector3D q = FieldVector3D.crossProduct(pvM, (FieldVector3D)p).normalize();
        RealFieldElement M1 = (RealFieldElement)M0.add(this.getKeplerianMeanMotion().multiply(dt));
        RealFieldElement H1 = this.meanToHyperbolicEccentric(M1, e);
        RealFieldElement cH = (RealFieldElement)H1.cosh();
        RealFieldElement sH = (RealFieldElement)H1.sinh();
        RealFieldElement sE2m1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)e.subtract(1.0)).multiply(e.add(1.0))).sqrt();
        RealFieldElement x = (RealFieldElement)a.multiply(cH.subtract((Object)e));
        RealFieldElement y = (RealFieldElement)((RealFieldElement)((RealFieldElement)a.negate()).multiply((Object)sE2m1)).multiply((Object)sH);
        RealFieldElement factor = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getMu().divide(a.negate())).sqrt()).divide(((RealFieldElement)e.multiply((Object)cH)).subtract(1.0));
        RealFieldElement xDot = (RealFieldElement)((RealFieldElement)factor.negate()).multiply((Object)sH);
        RealFieldElement yDot = (RealFieldElement)((RealFieldElement)factor.multiply((Object)sE2m1)).multiply((Object)cH);
        FieldVector3D shiftedP = new FieldVector3D(x, p, y, q);
        FieldVector3D shiftedV = new FieldVector3D(xDot, p, yDot, q);
        if (this.hasNonKeplerianAcceleration) {
            FieldVector3D nonKeplerianAcceleration = new FieldVector3D(this.one, this.getPVCoordinates().getAcceleration(), (RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply((Object)r2)).reciprocal()).multiply(this.getMu()), pvP);
            FieldVector3D fixedP = new FieldVector3D(this.one, shiftedP, (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, shiftedV, dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)fixedR.multiply((Object)fixedR2)).reciprocal()).multiply(this.getMu().negate()), shiftedP, this.one, nonKeplerianAcceleration);
            return new FieldPVCoordinates(fixedP, fixedV, fixedA);
        }
        return new FieldPVCoordinates(shiftedP, shiftedV);
    }

    private T meanToEccentric(T thetaM, T ex, T ey) {
        Object thetaE = thetaM;
        Object thetaEMthetaM = this.zero;
        int iter = 0;
        do {
            FieldSinCos scThetaE = FastMath.sinCos(thetaE);
            RealFieldElement f2 = (RealFieldElement)((RealFieldElement)ex.multiply(scThetaE.sin())).subtract(ey.multiply(scThetaE.cos()));
            RealFieldElement f1 = (RealFieldElement)((RealFieldElement)this.one.subtract(ex.multiply(scThetaE.cos()))).subtract(ey.multiply(scThetaE.sin()));
            RealFieldElement f0 = (RealFieldElement)thetaEMthetaM.subtract((Object)f2);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2.0);
            RealFieldElement shift = (RealFieldElement)((RealFieldElement)f0.multiply((Object)f12)).divide(((RealFieldElement)f1.multiply((Object)f12)).subtract(f0.multiply((Object)f2)));
            thetaEMthetaM = (RealFieldElement)thetaEMthetaM.subtract((Object)shift);
            thetaE = (RealFieldElement)thetaM.add(thetaEMthetaM);
            if (!(FastMath.abs((double)shift.getReal()) <= 1.0E-12)) continue;
            return thetaE;
        } while (++iter < 50);
        throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.CONVERGENCE_FAILED, new Object[0]);
    }

    private T meanToHyperbolicEccentric(T M, T ecc) {
        RealFieldElement H = ecc.getReal() < 1.6 ? (-Math.PI < M.getReal() && M.getReal() < 0.0 || M.getReal() > Math.PI ? (RealFieldElement)M.subtract(ecc) : (RealFieldElement)M.add(ecc)) : (ecc.getReal() < 3.6 && FastMath.abs((double)M.getReal()) > Math.PI ? (RealFieldElement)M.subtract(ecc.copySign(M)) : (RealFieldElement)M.divide(ecc.subtract(1.0)));
        int iter = 0;
        do {
            RealFieldElement f3 = (RealFieldElement)ecc.multiply(H.cosh());
            RealFieldElement f2 = (RealFieldElement)ecc.multiply(H.sinh());
            RealFieldElement f1 = (RealFieldElement)f3.subtract(1.0);
            RealFieldElement f0 = (RealFieldElement)((RealFieldElement)f2.subtract((Object)H)).subtract(M);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2);
            RealFieldElement d = (RealFieldElement)f0.divide((Object)f12);
            RealFieldElement fdf = (RealFieldElement)f1.subtract(d.multiply((Object)f2));
            RealFieldElement ds = (RealFieldElement)f0.divide((Object)fdf);
            RealFieldElement shift = (RealFieldElement)f0.divide(fdf.add(((RealFieldElement)ds.multiply((Object)ds)).multiply(f3.divide(6.0))));
            H = (RealFieldElement)H.subtract((Object)shift);
            if (!(FastMath.abs((double)shift.getReal()) <= 1.0E-12)) continue;
            return (T)H;
        } while (++iter < 50);
        throw new MathIllegalStateException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, new Object[]{iter});
    }

    private T[][] create6x6Identity() {
        RealFieldElement[][] identity = (RealFieldElement[][])MathArrays.buildArray(this.field, (int)6, (int)6);
        for (int i = 0; i < 6; ++i) {
            Arrays.fill(identity[i], this.zero);
            identity[i][i] = this.one;
        }
        return identity;
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        TimeStampedFieldPVCoordinates pv = this.getPVCoordinates();
        FieldVector3D velocity = pv.getVelocity();
        pDot[0] = (RealFieldElement)pDot[0].add((Object)velocity.getX());
        pDot[1] = (RealFieldElement)pDot[1].add((Object)velocity.getY());
        pDot[2] = (RealFieldElement)pDot[2].add((Object)velocity.getZ());
        FieldVector3D position = pv.getPosition();
        RealFieldElement r2 = position.getNormSq();
        RealFieldElement coeff = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply(r2.sqrt())).reciprocal()).negate()).multiply(gm);
        pDot[3] = (RealFieldElement)pDot[3].add(coeff.multiply((Object)position.getX()));
        pDot[4] = (RealFieldElement)pDot[4].add(coeff.multiply((Object)position.getY()));
        pDot[5] = (RealFieldElement)pDot[5].add(coeff.multiply((Object)position.getZ()));
    }

    public String toString() {
        String comma = ", ";
        PVCoordinates pv = this.getPVCoordinates().toPVCoordinates();
        Vector3D p = pv.getPosition();
        Vector3D v = pv.getVelocity();
        return "Cartesian parameters: {P(" + p.getX() + ", " + p.getY() + ", " + p.getZ() + "), V(" + v.getX() + ", " + v.getY() + ", " + v.getZ() + ")}";
    }

    @Override
    public CartesianOrbit toOrbit() {
        PVCoordinates pv = this.getPVCoordinates().toPVCoordinates();
        AbsoluteDate date = this.getPVCoordinates().getDate().toAbsoluteDate();
        if (this.hasDerivatives()) {
            return new CartesianOrbit(pv, this.getFrame(), date, this.getMu().getReal());
        }
        return new CartesianOrbit(new PVCoordinates(pv.getPosition(), pv.getVelocity()), this.getFrame(), date, this.getMu().getReal());
    }
}

