/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.AEMFile;
import org.orekit.files.ccsds.Keyword;
import org.orekit.files.ccsds.StreamingAemWriter;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.files.general.AttitudeEphemerisFileWriter;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class AEMWriter
implements AttitudeEphemerisFileWriter {
    private final String originator;
    private final String spaceObjectId;
    private final String spaceObjectName;
    private final String attitudeFormat;

    public AEMWriter() {
        this("OREKIT", null, null, "% .5f");
    }

    public AEMWriter(String originator, String spaceObjectId, String spaceObjectName) {
        this(originator, spaceObjectId, spaceObjectName, "% .5f");
    }

    public AEMWriter(String originator, String spaceObjectId, String spaceObjectName, String attitudeFormat) {
        this.originator = originator;
        this.spaceObjectId = spaceObjectId;
        this.spaceObjectName = spaceObjectName;
        this.attitudeFormat = attitudeFormat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Appendable writer, AttitudeEphemerisFile ephemerisFile) throws IOException {
        AEMFile aemFile;
        String idToProcess;
        if (writer == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "writer");
        }
        if (ephemerisFile == null) {
            return;
        }
        if (this.spaceObjectId != null) {
            if (!ephemerisFile.getSatellites().containsKey(this.spaceObjectId)) throw new OrekitIllegalArgumentException(OrekitMessages.VALUE_NOT_FOUND, this.spaceObjectId, "ephemerisFile");
            idToProcess = this.spaceObjectId;
        } else {
            if (ephemerisFile.getSatellites().keySet().size() != 1) throw new OrekitIllegalArgumentException(OrekitMessages.EPHEMERIS_FILE_NO_MULTI_SUPPORT, new Object[0]);
            idToProcess = ephemerisFile.getSatellites().keySet().iterator().next();
        }
        AttitudeEphemerisFile.SatelliteAttitudeEphemeris satEphem = ephemerisFile.getSatellites().get(idToProcess);
        List<? extends AttitudeEphemerisFile.AttitudeEphemerisSegment> segments = satEphem.getSegments();
        if (segments.isEmpty()) {
            return;
        }
        AttitudeEphemerisFile.AttitudeEphemerisSegment firstSegment = segments.get(0);
        String objectName = this.spaceObjectName == null ? idToProcess : this.spaceObjectName;
        TimeScale timeScale = firstSegment.getTimeScale();
        LinkedHashMap<Keyword, String> metadata = new LinkedHashMap<Keyword, String>();
        metadata.put(Keyword.TIME_SYSTEM, firstSegment.getTimeScaleString());
        metadata.put(Keyword.ORIGINATOR, this.originator);
        metadata.put(Keyword.OBJECT_NAME, objectName);
        metadata.put(Keyword.OBJECT_ID, idToProcess);
        if (ephemerisFile instanceof AEMFile && !(aemFile = (AEMFile)ephemerisFile).getHeaderComment().isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (String comment : aemFile.getHeaderComment()) {
                buffer.append(comment);
            }
            metadata.put(Keyword.COMMENT, buffer.toString());
        }
        StreamingAemWriter aemWriter = new StreamingAemWriter(writer, timeScale, metadata, this.attitudeFormat);
        aemWriter.writeHeader();
        for (AttitudeEphemerisFile.AttitudeEphemerisSegment attitudeEphemerisSegment : segments) {
            metadata.clear();
            metadata.put(Keyword.CENTER_NAME, attitudeEphemerisSegment.getFrameCenterString());
            metadata.put(Keyword.REF_FRAME_A, attitudeEphemerisSegment.getRefFrameAString());
            metadata.put(Keyword.REF_FRAME_B, attitudeEphemerisSegment.getRefFrameBString());
            metadata.put(Keyword.ATTITUDE_DIR, attitudeEphemerisSegment.getAttitudeDirection());
            metadata.put(Keyword.START_TIME, attitudeEphemerisSegment.getStart().toString(timeScale));
            metadata.put(Keyword.STOP_TIME, attitudeEphemerisSegment.getStop().toString(timeScale));
            metadata.put(Keyword.ATTITUDE_TYPE, attitudeEphemerisSegment.getAttitudeType());
            metadata.put(Keyword.INTERPOLATION_METHOD, attitudeEphemerisSegment.getInterpolationMethod());
            metadata.put(Keyword.INTERPOLATION_DEGREE, String.valueOf(attitudeEphemerisSegment.getInterpolationSamples() - 1));
            StreamingAemWriter.AEMSegment segmentWriter = aemWriter.newSegment(metadata);
            segmentWriter.writeMetadata();
            segmentWriter.startAttitudeBlock();
            for (TimeStampedAngularCoordinates timeStampedAngularCoordinates : attitudeEphemerisSegment.getAngularCoordinates()) {
                segmentWriter.writeAttitudeEphemerisLine(timeStampedAngularCoordinates, attitudeEphemerisSegment.isFirst(), attitudeEphemerisSegment.getAttitudeType(), attitudeEphemerisSegment.getRotationOrder());
            }
            segmentWriter.endAttitudeBlock();
        }
    }

    public void write(Appendable writer, AEMFile aemFile) throws IOException {
        this.write(writer, (AttitudeEphemerisFile)aemFile);
    }

    public void write(String outputFilePath, AEMFile aemFile) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(outputFilePath, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.write((Appendable)writer, (AttitudeEphemerisFile)aemFile);
        }
    }
}

