/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.orekit.bodies.CelestialBody;
import org.orekit.files.ccsds.ADMFile;
import org.orekit.files.ccsds.CcsdsTimeScale;
import org.orekit.time.TimeScale;

public class ADMMetaData {
    private final ADMFile admFile;
    private CcsdsTimeScale timeSystem;
    private String objectName;
    private String objectID;
    private int launchYear;
    private int launchNumber;
    private String launchPiece;
    private String centerName;
    private CelestialBody centerBody;
    private boolean hasCreatableBody;
    private List<String> comment;

    public ADMMetaData(ADMFile admFile) {
        this.admFile = admFile;
        this.comment = new ArrayList<String>();
    }

    public ADMFile getADMFile() {
        return this.admFile;
    }

    public CcsdsTimeScale getTimeSystem() {
        return this.timeSystem;
    }

    public void setTimeSystem(CcsdsTimeScale timeSystem) {
        this.timeSystem = timeSystem;
    }

    public TimeScale getTimeScale() {
        return this.getTimeSystem().getTimeScale(this.admFile.getConventions(), this.admFile.getDataContext().getTimeScales());
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    public int getLaunchYear() {
        return this.launchYear;
    }

    public void setLaunchYear(int launchYear) {
        this.launchYear = launchYear;
    }

    public int getLaunchNumber() {
        return this.launchNumber;
    }

    public void setLaunchNumber(int launchNumber) {
        this.launchNumber = launchNumber;
    }

    public String getLaunchPiece() {
        return this.launchPiece;
    }

    public void setLaunchPiece(String launchPiece) {
        this.launchPiece = launchPiece;
    }

    public String getCenterName() {
        return this.centerName;
    }

    public void setCenterName(String centerName) {
        this.centerName = centerName;
    }

    public CelestialBody getCenterBody() {
        return this.centerBody;
    }

    public void setCenterBody(CelestialBody centerBody) {
        this.centerBody = centerBody;
    }

    public boolean getHasCreatableBody() {
        return this.hasCreatableBody;
    }

    public void setHasCreatableBody(boolean hasCreatableBody) {
        this.hasCreatableBody = hasCreatableBody;
    }

    public List<String> getComment() {
        return Collections.unmodifiableList(this.comment);
    }

    public void setComment(List<String> comment) {
        this.comment = new ArrayList<String>(comment);
    }
}

