/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.filtering.kalman.Measurement;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.extended.ExtendedKalmanFilter;
import org.hipparchus.filtering.kalman.extended.NonLinearProcess;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.PV;
import org.orekit.estimation.measurements.Position;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanODModel;
import org.orekit.estimation.sequential.KalmanObserver;
import org.orekit.estimation.sequential.MeasurementDecorator;
import org.orekit.propagation.conversion.IntegratedPropagatorBuilder;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.propagation.integration.AbstractIntegratedPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class KalmanEstimator {
    private List<IntegratedPropagatorBuilder> propagatorBuilders;
    private final AbsoluteDate referenceDate;
    private final KalmanODModel processModel;
    private final ExtendedKalmanFilter<MeasurementDecorator> filter;
    private KalmanObserver observer;

    @Deprecated
    KalmanEstimator(MatrixDecomposer decomposer, List<IntegratedPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> processNoiseMatricesProviders, ParameterDriversList estimatedMeasurementParameters) {
        this(decomposer, propagatorBuilders, processNoiseMatricesProviders, estimatedMeasurementParameters, null);
    }

    KalmanEstimator(MatrixDecomposer decomposer, List<IntegratedPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> processNoiseMatricesProviders, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        this.propagatorBuilders = propagatorBuilders;
        this.referenceDate = propagatorBuilders.get(0).getInitialOrbitDate();
        this.observer = null;
        this.processModel = propagatorBuilders.get(0).buildKalmanModel(propagatorBuilders, processNoiseMatricesProviders, estimatedMeasurementParameters, measurementProcessNoiseMatrix);
        this.filter = new ExtendedKalmanFilter(decomposer, (NonLinearProcess)this.processModel, this.processModel.getEstimate());
    }

    public void setObserver(KalmanObserver observer) {
        this.observer = observer;
    }

    public int getCurrentMeasurementNumber() {
        return this.processModel.getCurrentMeasurementNumber();
    }

    public AbsoluteDate getCurrentDate() {
        return this.processModel.getCurrentDate();
    }

    public RealVector getPhysicalEstimatedState() {
        return this.processModel.getPhysicalEstimatedState();
    }

    public RealMatrix getPhysicalEstimatedCovarianceMatrix() {
        return this.processModel.getPhysicalEstimatedCovarianceMatrix();
    }

    public ParameterDriversList getOrbitalParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (int i = 0; i < this.propagatorBuilders.size(); ++i) {
            String suffix = this.propagatorBuilders.size() > 1 ? "[" + i + "]" : null;
            for (ParameterDriver parameterDriver : this.propagatorBuilders.get(i).getOrbitalParametersDrivers().getDrivers()) {
                if (!parameterDriver.isSelected() && estimatedOnly) continue;
                if (suffix != null && !parameterDriver.getName().endsWith(suffix)) {
                    parameterDriver.setName(parameterDriver.getName() + suffix);
                }
                estimated.add(parameterDriver);
            }
        }
        return estimated;
    }

    public ParameterDriversList getPropagationParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (PropagatorBuilder propagatorBuilder : this.propagatorBuilders) {
            for (ParameterDriversList.DelegatingDriver delegating : propagatorBuilder.getPropagationParametersDrivers().getDrivers()) {
                if (!delegating.isSelected() && estimatedOnly) continue;
                for (ParameterDriver driver : delegating.getRawDrivers()) {
                    estimated.add(driver);
                }
            }
        }
        return estimated;
    }

    public ParameterDriversList getEstimatedMeasurementsParameters() {
        return this.processModel.getEstimatedMeasurementsParameters();
    }

    public AbstractIntegratedPropagator[] estimationStep(ObservedMeasurement<?> observedMeasurement) {
        try {
            ProcessEstimate estimate = this.filter.estimationStep((Measurement)this.decorate(observedMeasurement));
            this.processModel.finalizeEstimation(observedMeasurement, estimate);
            if (this.observer != null) {
                this.observer.evaluationPerformed(this.processModel);
            }
            return this.processModel.getEstimatedPropagators();
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }

    public AbstractIntegratedPropagator[] processMeasurements(Iterable<ObservedMeasurement<?>> observedMeasurements) {
        AbstractIntegratedPropagator[] propagators = null;
        for (ObservedMeasurement<?> observedMeasurement : observedMeasurements) {
            propagators = this.estimationStep(observedMeasurement);
        }
        return propagators;
    }

    private MeasurementDecorator decorate(ObservedMeasurement<?> observedMeasurement) {
        RealMatrix covariance;
        if (observedMeasurement instanceof PV) {
            PV pv = (PV)observedMeasurement;
            covariance = MatrixUtils.createRealMatrix((double[][])pv.getCorrelationCoefficientsMatrix());
        } else if (observedMeasurement instanceof Position) {
            Position position = (Position)observedMeasurement;
            covariance = MatrixUtils.createRealMatrix((double[][])position.getCorrelationCoefficientsMatrix());
        } else {
            covariance = MatrixUtils.createRealIdentityMatrix((int)observedMeasurement.getDimension());
        }
        return new MeasurementDecorator(observedMeasurement, covariance, this.referenceDate);
    }
}

