/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.ArrayList;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldLine;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.GroundPointing;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class LofOffsetPointing
extends GroundPointing {
    private final AttitudeProvider attitudeLaw;
    private final BodyShape shape;
    private final Vector3D satPointingVector;

    public LofOffsetPointing(Frame inertialFrame, BodyShape shape, AttitudeProvider attLaw, Vector3D satPointingVector) {
        super(inertialFrame, shape.getBodyFrame());
        this.shape = shape;
        this.attitudeLaw = attLaw;
        this.satPointingVector = satPointingVector;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        return this.attitudeLaw.getAttitude(pvProv, date, frame);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        return this.attitudeLaw.getAttitude(pvProv, date, frame);
    }

    @Override
    public TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        double h = 0.1;
        ArrayList<TimeStampedPVCoordinates> sample = new ArrayList<TimeStampedPVCoordinates>();
        Transform centralRefToBody = null;
        for (int i = -1; i < 2; ++i) {
            AbsoluteDate shifted = date.shiftedBy((double)i * 0.1);
            Transform refToSc = new Transform(shifted, new Transform(shifted, pvProv.getPVCoordinates(shifted, frame).negate()), new Transform(shifted, this.attitudeLaw.getAttitude(pvProv, shifted, frame).getOrientation()));
            Transform refToBody = frame.getTransformTo(this.shape.getBodyFrame(), shifted);
            if (i == 0) {
                centralRefToBody = refToBody;
            }
            sample.add(this.losIntersectionWithBody(new Transform(shifted, refToSc.getInverse(), refToBody)));
        }
        TimeStampedPVCoordinates targetBody = TimeStampedPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_P, sample);
        return centralRefToBody.getInverse().transformPVCoordinates(targetBody);
    }

    @Override
    public <T extends RealFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPV(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        double h = 0.1;
        ArrayList sample = new ArrayList();
        FieldTransform centralRefToBody = null;
        for (int i = -1; i < 2; ++i) {
            TimeShiftable shifted = date.shiftedBy((double)i * 0.1);
            FieldTransform refToSc = new FieldTransform(shifted, new FieldTransform(shifted, pvProv.getPVCoordinates((FieldAbsoluteDate<T>)shifted, frame).negate()), new FieldTransform<T>(shifted, this.attitudeLaw.getAttitude(pvProv, shifted, frame).getOrientation()));
            FieldTransform refToBody = frame.getTransformTo(this.shape.getBodyFrame(), shifted);
            if (i == 0) {
                centralRefToBody = refToBody;
            }
            sample.add(this.losIntersectionWithBody(new FieldTransform(shifted, refToSc.getInverse(), refToBody)));
        }
        TimeStampedFieldPVCoordinates<T> targetBody = TimeStampedFieldPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_P, sample);
        return centralRefToBody.getInverse().transformPVCoordinates(targetBody);
    }

    private TimeStampedPVCoordinates losIntersectionWithBody(Transform scToBody) {
        Vector3D pIntersection;
        Vector3D pointingBodyFrame = scToBody.transformVector(this.satPointingVector);
        Vector3D pBodyFrame = scToBody.transformPosition(Vector3D.ZERO);
        Line pointingLine = new Line(pBodyFrame, pBodyFrame.add(6378137.0, (Vector)pointingBodyFrame), 1.0E-10);
        GeodeticPoint gpIntersection = this.shape.getIntersectionPoint(pointingLine, pBodyFrame, this.shape.getBodyFrame(), scToBody.getDate());
        Vector3D vector3D = pIntersection = gpIntersection == null ? null : this.shape.transform(gpIntersection);
        if (pIntersection == null || Vector3D.dotProduct((Vector3D)pIntersection.subtract((Vector)pBodyFrame), (Vector3D)pointingBodyFrame) < 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.ATTITUDE_POINTING_LAW_DOES_NOT_POINT_TO_GROUND, new Object[0]);
        }
        return new TimeStampedPVCoordinates(scToBody.getDate(), pIntersection, Vector3D.ZERO, Vector3D.ZERO);
    }

    private <T extends RealFieldElement<T>> TimeStampedFieldPVCoordinates<T> losIntersectionWithBody(FieldTransform<T> scToBody) {
        FieldVector3D<T> pIntersection;
        FieldVector3D<T> pointingBodyFrame = scToBody.transformVector(this.satPointingVector);
        FieldVector3D<T> pBodyFrame = scToBody.transformPosition(Vector3D.ZERO);
        FieldLine pointingLine = new FieldLine(pBodyFrame, pBodyFrame.add(6378137.0, pointingBodyFrame), 1.0E-10);
        FieldGeodeticPoint<T> gpIntersection = this.shape.getIntersectionPoint(pointingLine, pBodyFrame, this.shape.getBodyFrame(), scToBody.getFieldDate());
        FieldVector3D<T> fieldVector3D = pIntersection = gpIntersection == null ? null : this.shape.transform(gpIntersection);
        if (pIntersection == null || FieldVector3D.dotProduct((FieldVector3D)pIntersection.subtract(pBodyFrame), pointingBodyFrame).getReal() < 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.ATTITUDE_POINTING_LAW_DOES_NOT_POINT_TO_GROUND, new Object[0]);
        }
        FieldVector3D zero = FieldVector3D.getZero(scToBody.getFieldDate().getField());
        return new TimeStampedFieldPVCoordinates<T>(scToBody.getDate(), pIntersection, zero, zero);
    }
}

