/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.orekit.data.DataLoader;
import org.orekit.time.OffsetModel;
import org.orekit.time.UTCTAIOffsetsLoader;

class UtcTaiOffsetLoader
implements DataLoader {
    private final UTCTAIOffsetsLoader.Parser parser;
    private final List<OffsetModel> offsets;

    UtcTaiOffsetLoader(UTCTAIOffsetsLoader.Parser parser) {
        this.parser = parser;
        this.offsets = new ArrayList<OffsetModel>();
    }

    public List<OffsetModel> getOffsets() {
        return this.offsets;
    }

    @Override
    public boolean stillAcceptsData() {
        return this.offsets.isEmpty();
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException {
        this.offsets.clear();
        this.offsets.addAll(this.parser.parse(input, name));
    }
}

