/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.RealFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;

public class TCGScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private static final double LG_RATE = 6.969290134E-10;
    private final AbsoluteDate referenceDate;
    private final double ttOffset;

    TCGScale(TimeScale tt, TimeScale tai) {
        this.referenceDate = new AbsoluteDate(1977, 1, 1, tai);
        this.ttOffset = tt.offsetFromTAI(this.referenceDate);
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        return this.ttOffset + 6.969290134E-10 * date.durationFrom(this.referenceDate);
    }

    @Override
    public <T extends RealFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        return (T)((RealFieldElement)((RealFieldElement)date.durationFrom(this.referenceDate).multiply(6.969290134E-10)).add(this.ttOffset));
    }

    @Override
    public String getName() {
        return "TCG";
    }

    public String toString() {
        return this.getName();
    }
}

