/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.Month;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;

public class AbsoluteDate
implements TimeStamped,
TimeShiftable<AbsoluteDate>,
Comparable<AbsoluteDate>,
Serializable {
    @DefaultDataContext
    public static final AbsoluteDate JULIAN_EPOCH = DataContext.getDefault().getTimeScales().getJulianEpoch();
    @DefaultDataContext
    public static final AbsoluteDate MODIFIED_JULIAN_EPOCH = DataContext.getDefault().getTimeScales().getModifiedJulianEpoch();
    @DefaultDataContext
    public static final AbsoluteDate FIFTIES_EPOCH = DataContext.getDefault().getTimeScales().getFiftiesEpoch();
    @DefaultDataContext
    public static final AbsoluteDate CCSDS_EPOCH = DataContext.getDefault().getTimeScales().getCcsdsEpoch();
    @DefaultDataContext
    public static final AbsoluteDate GALILEO_EPOCH = DataContext.getDefault().getTimeScales().getGalileoEpoch();
    @DefaultDataContext
    public static final AbsoluteDate GPS_EPOCH = DataContext.getDefault().getTimeScales().getGpsEpoch();
    @DefaultDataContext
    public static final AbsoluteDate QZSS_EPOCH = DataContext.getDefault().getTimeScales().getQzssEpoch();
    @DefaultDataContext
    public static final AbsoluteDate IRNSS_EPOCH = DataContext.getDefault().getTimeScales().getIrnssEpoch();
    @DefaultDataContext
    public static final AbsoluteDate BEIDOU_EPOCH = DataContext.getDefault().getTimeScales().getBeidouEpoch();
    @DefaultDataContext
    public static final AbsoluteDate GLONASS_EPOCH = DataContext.getDefault().getTimeScales().getGlonassEpoch();
    @DefaultDataContext
    public static final AbsoluteDate J2000_EPOCH = DataContext.getDefault().getTimeScales().getJ2000Epoch();
    @DefaultDataContext
    public static final AbsoluteDate JAVA_EPOCH = DataContext.getDefault().getTimeScales().getJavaEpoch();
    public static final AbsoluteDate ARBITRARY_EPOCH = new AbsoluteDate(0L, 0.0);
    public static final AbsoluteDate PAST_INFINITY = ARBITRARY_EPOCH.shiftedBy(Double.NEGATIVE_INFINITY);
    public static final AbsoluteDate FUTURE_INFINITY = ARBITRARY_EPOCH.shiftedBy(Double.POSITIVE_INFINITY);
    private static final long serialVersionUID = 617061803741806846L;
    private final long epoch;
    private final double offset;

    @DefaultDataContext
    public AbsoluteDate() {
        this.epoch = AbsoluteDate.J2000_EPOCH.epoch;
        this.offset = AbsoluteDate.J2000_EPOCH.offset;
    }

    public AbsoluteDate(String location, TimeScale timeScale) {
        this(DateTimeComponents.parseDateTime(location), timeScale);
    }

    public AbsoluteDate(DateTimeComponents location, TimeScale timeScale) {
        this(location.getDate(), location.getTime(), timeScale);
    }

    public AbsoluteDate(DateComponents date, TimeComponents time, TimeScale timeScale) {
        double seconds = time.getSecond();
        double tsOffset = timeScale.offsetToTAI(date, time);
        double sum = seconds + tsOffset;
        double sPrime = sum - tsOffset;
        double tPrime = sum - sPrime;
        double deltaS = seconds - sPrime;
        double deltaT = tsOffset - tPrime;
        double residual = deltaS + deltaT;
        long dl = (long)FastMath.floor((double)sum);
        this.offset = sum - (double)dl + residual;
        this.epoch = 60L * (((long)date.getJ2000Day() * 24L + (long)time.getHour()) * 60L + (long)time.getMinute() - (long)time.getMinutesFromUTC() - 720L) + dl;
    }

    public AbsoluteDate(int year, int month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public AbsoluteDate(int year, Month month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public AbsoluteDate(DateComponents date, TimeScale timeScale) throws IllegalArgumentException {
        this(date, TimeComponents.H00, timeScale);
    }

    public AbsoluteDate(int year, int month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public AbsoluteDate(int year, Month month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public AbsoluteDate(Date location, TimeScale timeScale) {
        this(new DateComponents(DateComponents.JAVA_EPOCH, (int)(location.getTime() / 86400000L)), AbsoluteDate.millisToTimeComponents((int)(location.getTime() % 86400000L)), timeScale);
    }

    public AbsoluteDate(AbsoluteDate since, double elapsedDuration) {
        double sum = since.offset + elapsedDuration;
        if (Double.isInfinite(sum)) {
            this.offset = sum;
            this.epoch = sum < 0.0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        } else {
            double oPrime = sum - elapsedDuration;
            double dPrime = sum - oPrime;
            double deltaO = since.offset - oPrime;
            double deltaD = elapsedDuration - dPrime;
            double residual = deltaO + deltaD;
            long dl = (long)FastMath.floor((double)sum);
            this.offset = sum - (double)dl + residual;
            this.epoch = since.epoch + dl;
        }
    }

    public AbsoluteDate(AbsoluteDate reference, double apparentOffset, TimeScale timeScale) {
        this(new DateTimeComponents(reference.getComponents(timeScale), apparentOffset), timeScale);
    }

    AbsoluteDate(long epoch, double offset) {
        this.epoch = epoch;
        this.offset = offset;
    }

    private static TimeComponents millisToTimeComponents(int millisInDay) {
        return new TimeComponents(millisInDay / 1000, 0.001 * (double)(millisInDay % 1000));
    }

    long getEpoch() {
        return this.epoch;
    }

    double getOffset() {
        return this.offset;
    }

    @DefaultDataContext
    public static AbsoluteDate parseCCSDSUnsegmentedTimeCode(byte preambleField1, byte preambleField2, byte[] timeField, AbsoluteDate agencyDefinedEpoch) {
        return AbsoluteDate.parseCCSDSUnsegmentedTimeCode(preambleField1, preambleField2, timeField, agencyDefinedEpoch, DataContext.getDefault().getTimeScales().getCcsdsEpoch());
    }

    public static AbsoluteDate parseCCSDSUnsegmentedTimeCode(byte preambleField1, byte preambleField2, byte[] timeField, AbsoluteDate agencyDefinedEpoch, AbsoluteDate ccsdsEpoch) {
        AbsoluteDate epoch;
        switch (preambleField1 & 0x70) {
            case 16: {
                epoch = ccsdsEpoch;
                break;
            }
            case 32: {
                if (agencyDefinedEpoch == null) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_MISSING_AGENCY_EPOCH, new Object[0]);
                }
                epoch = agencyDefinedEpoch;
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField1));
            }
        }
        int coarseTimeLength = 1 + ((preambleField1 & 0xC) >>> 2);
        int fineTimeLength = preambleField1 & 3;
        if ((preambleField1 & 0x80) != 0) {
            coarseTimeLength += (preambleField2 & 0x60) >>> 5;
            fineTimeLength += (preambleField2 & 0x1C) >>> 2;
        }
        if (timeField.length != coarseTimeLength + fineTimeLength) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, coarseTimeLength + fineTimeLength);
        }
        double seconds = 0.0;
        for (int i = 0; i < coarseTimeLength; ++i) {
            seconds = seconds * 256.0 + (double)AbsoluteDate.toUnsigned(timeField[i]);
        }
        double subseconds = 0.0;
        for (int i = timeField.length - 1; i >= coarseTimeLength; --i) {
            subseconds = (subseconds + (double)AbsoluteDate.toUnsigned(timeField[i])) / 256.0;
        }
        return new AbsoluteDate(epoch, seconds).shiftedBy(subseconds);
    }

    @DefaultDataContext
    public static AbsoluteDate parseCCSDSDaySegmentedTimeCode(byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch) {
        return AbsoluteDate.parseCCSDSDaySegmentedTimeCode(preambleField, timeField, agencyDefinedEpoch, DataContext.getDefault().getTimeScales().getUTC());
    }

    public static AbsoluteDate parseCCSDSDaySegmentedTimeCode(byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch, TimeScale utc) {
        DateComponents epoch;
        if ((preambleField & 0xF0) != 64) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField));
        }
        if ((preambleField & 8) == 0) {
            epoch = DateComponents.CCSDS_EPOCH;
        } else {
            if (agencyDefinedEpoch == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_MISSING_AGENCY_EPOCH, new Object[0]);
            }
            epoch = agencyDefinedEpoch;
        }
        int daySegmentLength = (preambleField & 4) == 0 ? 2 : 3;
        int subMillisecondLength = (preambleField & 3) << 1;
        if (subMillisecondLength == 6) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField));
        }
        if (timeField.length != daySegmentLength + 4 + subMillisecondLength) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, daySegmentLength + 4 + subMillisecondLength);
        }
        int i = 0;
        int day = 0;
        while (i < daySegmentLength) {
            day = day * 256 + AbsoluteDate.toUnsigned(timeField[i++]);
        }
        long milliInDay = 0L;
        while (i < daySegmentLength + 4) {
            milliInDay = milliInDay * 256L + (long)AbsoluteDate.toUnsigned(timeField[i++]);
        }
        int milli = (int)(milliInDay % 1000L);
        int seconds = (int)((milliInDay - (long)milli) / 1000L);
        double subMilli = 0.0;
        double divisor = 1.0;
        while (i < timeField.length) {
            subMilli = subMilli * 256.0 + (double)AbsoluteDate.toUnsigned(timeField[i++]);
            divisor *= 1000.0;
        }
        DateComponents date = new DateComponents(epoch, day);
        TimeComponents time = new TimeComponents(seconds);
        return new AbsoluteDate(date, time, utc).shiftedBy((double)milli * 0.001 + subMilli / divisor);
    }

    @DefaultDataContext
    public static AbsoluteDate parseCCSDSCalendarSegmentedTimeCode(byte preambleField, byte[] timeField) {
        return AbsoluteDate.parseCCSDSCalendarSegmentedTimeCode(preambleField, timeField, DataContext.getDefault().getTimeScales().getUTC());
    }

    public static AbsoluteDate parseCCSDSCalendarSegmentedTimeCode(byte preambleField, byte[] timeField, TimeScale utc) {
        if ((preambleField & 0xF0) != 80) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField));
        }
        int length = 7 + (preambleField & 7);
        if (length == 14) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, AbsoluteDate.formatByte(preambleField));
        }
        if (timeField.length != length) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, length);
        }
        DateComponents date = (preambleField & 8) == 0 ? new DateComponents(AbsoluteDate.toUnsigned(timeField[0]) * 256 + AbsoluteDate.toUnsigned(timeField[1]), AbsoluteDate.toUnsigned(timeField[2]), AbsoluteDate.toUnsigned(timeField[3])) : new DateComponents(AbsoluteDate.toUnsigned(timeField[0]) * 256 + AbsoluteDate.toUnsigned(timeField[1]), AbsoluteDate.toUnsigned(timeField[2]) * 256 + AbsoluteDate.toUnsigned(timeField[3]));
        TimeComponents time = new TimeComponents(AbsoluteDate.toUnsigned(timeField[4]), AbsoluteDate.toUnsigned(timeField[5]), AbsoluteDate.toUnsigned(timeField[6]));
        double subSecond = 0.0;
        double divisor = 1.0;
        for (int i = 7; i < length; ++i) {
            subSecond = subSecond * 100.0 + (double)AbsoluteDate.toUnsigned(timeField[i]);
            divisor *= 100.0;
        }
        return new AbsoluteDate(date, time, utc).shiftedBy(subSecond / divisor);
    }

    private static int toUnsigned(byte b) {
        int i = b;
        return i < 0 ? 256 + i : i;
    }

    private static String formatByte(byte data) {
        return "0x" + Integer.toHexString(data).toUpperCase();
    }

    public static AbsoluteDate createJDDate(int jd, double secondsSinceNoon, TimeScale timeScale) {
        return new AbsoluteDate(new DateComponents(DateComponents.JULIAN_EPOCH, jd), TimeComponents.H12, timeScale).shiftedBy(secondsSinceNoon);
    }

    public static AbsoluteDate createMJDDate(int mjd, double secondsInDay, TimeScale timeScale) throws OrekitIllegalArgumentException {
        TimeComponents tc;
        DateComponents dc = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd);
        if (secondsInDay >= 86400.0) {
            int secondsA = 86399;
            double secondsB = secondsInDay - 86399.0;
            TimeComponents safeTC = new TimeComponents(86399, 0.0);
            AbsoluteDate safeDate = new AbsoluteDate(dc, safeTC, timeScale);
            if ((double)timeScale.minuteDuration(safeDate) > 59.0 + secondsB) {
                return safeDate.shiftedBy(secondsB);
            }
            tc = new TimeComponents(86399, secondsB);
        } else {
            tc = new TimeComponents(secondsInDay);
        }
        return new AbsoluteDate(dc, tc, timeScale);
    }

    @DefaultDataContext
    public static AbsoluteDate createJulianEpoch(double julianEpoch) {
        return DataContext.getDefault().getTimeScales().createJulianEpoch(julianEpoch);
    }

    @DefaultDataContext
    public static AbsoluteDate createBesselianEpoch(double besselianEpoch) {
        return DataContext.getDefault().getTimeScales().createBesselianEpoch(besselianEpoch);
    }

    @Override
    public AbsoluteDate shiftedBy(double dt) {
        return new AbsoluteDate(this, dt);
    }

    public double durationFrom(AbsoluteDate instant) {
        return (double)(this.epoch - instant.epoch) + (this.offset - instant.offset);
    }

    public double offsetFrom(AbsoluteDate instant, TimeScale timeScale) {
        long elapsedDurationA = this.epoch - instant.epoch;
        double elapsedDurationB = this.offset + timeScale.offsetFromTAI(this) - (instant.offset + timeScale.offsetFromTAI(instant));
        return (double)elapsedDurationA + elapsedDurationB;
    }

    public double timeScalesOffset(TimeScale scale1, TimeScale scale2) {
        return scale1.offsetFromTAI(this) - scale2.offsetFromTAI(this);
    }

    public Date toDate(TimeScale timeScale) {
        double time = (double)this.epoch + (this.offset + timeScale.offsetFromTAI(this));
        return new Date(FastMath.round((double)((time + 9.46728E8) * 1000.0)));
    }

    public DateTimeComponents getComponents(TimeScale timeScale) {
        long time;
        if (Double.isInfinite(this.offset)) {
            if (this.offset < 0.0) {
                return new DateTimeComponents(DateComponents.MIN_EPOCH, TimeComponents.H00);
            }
            return new DateTimeComponents(DateComponents.MAX_EPOCH, new TimeComponents(23, 59, 59.999));
        }
        double taiOffset = timeScale.offsetFromTAI(this);
        double sum = this.offset + taiOffset;
        double oPrime = sum - taiOffset;
        double dPrime = sum - oPrime;
        double deltaO = this.offset - oPrime;
        double deltaD = taiOffset - dPrime;
        double residual = deltaO + deltaD;
        long carry = (long)FastMath.floor((double)sum);
        double offset2000B = sum - (double)carry + residual;
        long offset2000A = this.epoch + carry + 43200L;
        if (offset2000B < 0.0) {
            --offset2000A;
            offset2000B += 1.0;
        }
        if ((time = offset2000A % 86400L) < 0L) {
            time += 86400L;
        }
        int date = (int)((offset2000A - time) / 86400L);
        DateComponents dateComponents = new DateComponents(DateComponents.J2000_EPOCH, date);
        double leap = timeScale.insideLeap(this) ? timeScale.getLeap(this) : 0.0;
        int minuteDuration = timeScale.minuteDuration(this);
        TimeComponents timeComponents = TimeComponents.fromSeconds((int)time, offset2000B, leap, minuteDuration);
        return new DateTimeComponents(dateComponents, timeComponents);
    }

    @DefaultDataContext
    public DateTimeComponents getComponents(int minutesFromUTC) {
        return this.getComponents(minutesFromUTC, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public DateTimeComponents getComponents(int minutesFromUTC, TimeScale utc) {
        DateTimeComponents utcComponents = this.getComponents(utc);
        double seconds = utcComponents.getTime().getSecond();
        int minute = utcComponents.getTime().getMinute() + minutesFromUTC;
        int hourShift = minute < 0 ? (minute - 59) / 60 : (minute > 59 ? minute / 60 : 0);
        int hour = utcComponents.getTime().getHour() + hourShift;
        int dayShift = hour < 0 ? (hour - 23) / 24 : (hour > 23 ? hour / 24 : 0);
        return new DateTimeComponents(new DateComponents(utcComponents.getDate(), dayShift), new TimeComponents(hour -= 24 * dayShift, minute -= 60 * hourShift, seconds, minutesFromUTC));
    }

    @DefaultDataContext
    public DateTimeComponents getComponents(TimeZone timeZone) {
        return this.getComponents(timeZone, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public DateTimeComponents getComponents(TimeZone timeZone, TimeScale utc) {
        AbsoluteDate javaEpoch = new AbsoluteDate(DateComponents.JAVA_EPOCH, utc);
        long milliseconds = FastMath.round((double)(1000.0 * this.offsetFrom(javaEpoch, utc)));
        return this.getComponents(timeZone.getOffset(milliseconds) / 60000, utc);
    }

    @Override
    public int compareTo(AbsoluteDate date) {
        double duration = this.durationFrom(date);
        if (!Double.isNaN(duration)) {
            return Double.compare(duration, 0.0);
        }
        return Double.compare(this.offset, date.offset);
    }

    @Override
    public AbsoluteDate getDate() {
        return this;
    }

    public boolean equals(Object date) {
        if (date == this) {
            return true;
        }
        if (date != null && date instanceof AbsoluteDate) {
            return this.durationFrom((AbsoluteDate)date) == 0.0;
        }
        return false;
    }

    public boolean isEqualTo(TimeStamped other) {
        return this.equals(other.getDate());
    }

    public boolean isCloseTo(TimeStamped other, double tolerance) {
        return FastMath.abs((double)this.durationFrom(other.getDate())) < tolerance;
    }

    public boolean isBefore(TimeStamped other) {
        return this.compareTo(other.getDate()) < 0;
    }

    public boolean isAfter(TimeStamped other) {
        return this.compareTo(other.getDate()) > 0;
    }

    public boolean isBeforeOrEqualTo(TimeStamped other) {
        return this.isEqualTo(other) || this.isBefore(other);
    }

    public boolean isAfterOrEqualTo(TimeStamped other) {
        return this.isEqualTo(other) || this.isAfter(other);
    }

    public boolean isBetween(TimeStamped boundary, TimeStamped otherBoundary) {
        TimeStamped end;
        TimeStamped beginning;
        if (boundary.getDate().isBefore(otherBoundary)) {
            beginning = boundary;
            end = otherBoundary;
        } else {
            beginning = otherBoundary;
            end = boundary;
        }
        return this.isAfter(beginning) && this.isBefore(end);
    }

    public boolean isBetweenOrEqualTo(TimeStamped boundary, TimeStamped otherBoundary) {
        return this.isEqualTo(boundary) || this.isEqualTo(otherBoundary) || this.isBetween(boundary, otherBoundary);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.durationFrom(ARBITRARY_EPOCH));
        return (int)(l ^ l >>> 32);
    }

    @DefaultDataContext
    public String toString() {
        return this.toString(DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(TimeScale timeScale) {
        return this.getComponents(timeScale).toString(timeScale.minuteDuration(this));
    }

    @DefaultDataContext
    public String toString(int minutesFromUTC) {
        return this.toString(minutesFromUTC, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(int minutesFromUTC, TimeScale utc) {
        int minuteDuration = utc.minuteDuration(this);
        return this.getComponents(minutesFromUTC, utc).toString(minuteDuration);
    }

    @DefaultDataContext
    public String toString(TimeZone timeZone) {
        return this.toString(timeZone, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(TimeZone timeZone, TimeScale utc) {
        int minuteDuration = utc.minuteDuration(this);
        return this.getComponents(timeZone, utc).toString(minuteDuration);
    }

    public String toStringRfc3339(TimeScale utc) {
        return this.getComponents(utc).toStringRfc3339();
    }
}

