/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.ContinueOnEvent;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class InterSatDirectViewDetector
extends AbstractDetector<InterSatDirectViewDetector> {
    private final OneAxisEllipsoid body;
    private final double ae2;
    private final double g2;
    private final PVCoordinatesProvider slave;

    public InterSatDirectViewDetector(OneAxisEllipsoid body, PVCoordinatesProvider slave) {
        this(body, slave, 600.0, 1.0E-6, 100, new ContinueOnEvent());
    }

    private InterSatDirectViewDetector(OneAxisEllipsoid body, PVCoordinatesProvider slave, double maxCheck, double threshold, int maxIter, EventHandler<? super InterSatDirectViewDetector> handler) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
        this.ae2 = body.getEquatorialRadius() * body.getEquatorialRadius();
        this.g2 = (1.0 - body.getFlattening()) * (1.0 - body.getFlattening());
        this.slave = slave;
    }

    public OneAxisEllipsoid getCentralBody() {
        return this.body;
    }

    public PVCoordinatesProvider getSlave() {
        return this.slave;
    }

    @Override
    protected InterSatDirectViewDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super InterSatDirectViewDetector> newHandler) {
        return new InterSatDirectViewDetector(this.body, this.slave, newMaxCheck, newThreshold, newMaxIter, newHandler);
    }

    @Override
    public double g(SpacecraftState state) {
        double k2;
        double c;
        double a;
        double dz;
        double dy;
        AbsoluteDate date = state.getDate();
        Frame frame = this.body.getBodyFrame();
        Vector3D pMaster = state.getPVCoordinates(frame).getPosition();
        Vector3D pSlave = this.slave.getPVCoordinates(date, frame).getPosition();
        double x = pMaster.getX();
        double y = pMaster.getY();
        double z = pMaster.getZ();
        double dx = pSlave.getX() - x;
        double b = -(this.g2 * (x * dx + y * (dy = pSlave.getY() - y)) + z * (dz = pSlave.getZ() - z));
        double s = b * b - (a = this.g2 * (dx * dx + dy * dy) + dz * dz) * (c = this.g2 * (x * x + y * y - this.ae2) + z * z);
        if (s < 0.0) {
            return -s;
        }
        double k1 = b < 0.0 ? (b - FastMath.sqrt((double)s)) / a : c / (b + FastMath.sqrt((double)s));
        if (FastMath.max((double)k1, (double)(k2 = c / (a * k1))) < 0.0 || FastMath.min((double)k1, (double)k2) > 1.0) {
            return s;
        }
        return -s;
    }
}

