/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collections;
import java.util.Map;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.data.DataContext;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.utils.FieldTimeSpanMap;

public class FieldKeplerianPropagator<T extends RealFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T> {
    private FieldSpacecraftState<T> initialState;
    private transient FieldTimeSpanMap<FieldSpacecraftState<T>, T> states;

    @DefaultDataContext
    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit) {
        this((FieldOrbit<RealFieldElement>)initialFieldOrbit, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()), (RealFieldElement)initialFieldOrbit.getMu(), (RealFieldElement)((RealFieldElement)initialFieldOrbit.getA().getField().getZero()).add(1000.0));
    }

    @DefaultDataContext
    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit, T mu) {
        this((FieldOrbit<RealFieldElement>)initialFieldOrbit, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()), (RealFieldElement)mu, (RealFieldElement)((RealFieldElement)initialFieldOrbit.getA().getField().getZero()).add(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit, AttitudeProvider attitudeProv) {
        this((FieldOrbit<RealFieldElement>)initialFieldOrbit, attitudeProv, (RealFieldElement)initialFieldOrbit.getMu(), (RealFieldElement)((RealFieldElement)initialFieldOrbit.getA().getField().getZero()).add(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit, AttitudeProvider attitudeProv, T mu) {
        this((FieldOrbit<RealFieldElement>)initialFieldOrbit, attitudeProv, (RealFieldElement)mu, (RealFieldElement)((RealFieldElement)initialFieldOrbit.getA().getField().getZero()).add(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mu, T mass) {
        super(initialOrbit.getA().getField(), attitudeProv);
        this.initialState = this.fixState(initialOrbit, this.getAttitudeProvider().getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass, mu, Collections.emptyMap());
        this.states = new FieldTimeSpanMap(this.initialState, initialOrbit.getA().getField());
        super.resetInitialState(this.initialState);
    }

    private FieldSpacecraftState<T> fixState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass, T mu, Map<String, T[]> additionalStates) {
        OrbitType type = orbit.getType();
        RealFieldElement[] stateVector = (RealFieldElement[])MathArrays.buildArray((Field)mass.getField(), (int)6);
        type.mapOrbitToArray(orbit, PositionAngle.TRUE, stateVector, null);
        FieldOrbit fixedOrbit = type.mapArrayToOrbit(stateVector, null, PositionAngle.TRUE, orbit.getDate(), (RealFieldElement)mu, orbit.getFrame());
        FieldSpacecraftState fixedState = new FieldSpacecraftState(fixedOrbit, attitude, mass);
        for (Map.Entry<String, T[]> entry : additionalStates.entrySet()) {
            fixedState = fixedState.addAdditionalState(entry.getKey(), (RealFieldElement[])entry.getValue());
        }
        return fixedState;
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        T mu = this.initialState == null ? state.getMu() : this.initialState.getMu();
        FieldSpacecraftState<T> fixedState = this.fixState(state.getOrbit(), state.getAttitude(), state.getMass(), mu, state.getAdditionalStates());
        this.initialState = fixedState;
        this.states = new FieldTimeSpanMap<FieldSpacecraftState<FieldSpacecraftState<T>>, FieldSpacecraftState<T>>(this.initialState, state.getDate().getField());
        super.resetInitialState(fixedState);
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        if (forward) {
            this.states.addValidAfter(state, state.getDate());
        } else {
            this.states.addValidBefore(state, state.getDate());
        }
        this.stateChanged(state);
    }

    @Override
    protected FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date) {
        FieldTimeInterpolable orbit = this.states.get(date).getOrbit();
        while (!date.equals(((FieldOrbit)(orbit = ((FieldOrbit)orbit).shiftedBy((RealFieldElement)date.durationFrom(((FieldOrbit)orbit).getDate())))).getDate())) {
        }
        return orbit;
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return this.states.get(date).getMass();
    }
}

