/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.models.earth.tessellation.TileAiming;

public class ConstantAzimuthAiming
implements TileAiming {
    private final SinCos sc;

    public ConstantAzimuthAiming(OneAxisEllipsoid ellipsoid, double azimuth) {
        this.sc = FastMath.sinCos((double)azimuth);
    }

    @Override
    public List<GeodeticPoint> getSingularPoints() {
        return Arrays.asList(GeodeticPoint.NORTH_POLE, GeodeticPoint.SOUTH_POLE);
    }

    @Override
    public Vector3D alongTileDirection(Vector3D point, GeodeticPoint gp) {
        return new Vector3D(this.sc.cos(), gp.getNorth(), this.sc.sin(), gp.getEast());
    }
}

