/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.gnss.attitude.TurnSpan;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

class GNSSAttitudeContext
implements TimeStamped {
    private static final int ORDER = 2;
    private static final DSFactory FACTORY = new DSFactory(1, 2);
    private static final PVCoordinates PLUS_Y_PV = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates MINUS_Z_PV = new PVCoordinates(Vector3D.MINUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private static final double BETA_SIGN_CHANGE_PROTECTION = FastMath.toRadians((double)0.07);
    private final AbsoluteDate date;
    private final FieldAbsoluteDate<DerivativeStructure> dateDS;
    private final ExtendedPVCoordinatesProvider sun;
    private final PVCoordinatesProvider pvProv;
    private final Frame inertialFrame;
    private final DerivativeStructure svbCos;
    private final boolean morning;
    private final DerivativeStructure delta;
    private double muRate;
    private double cNight;
    private double cNoon;
    private TurnSpan turnSpan;

    GNSSAttitudeContext(AbsoluteDate date, ExtendedPVCoordinatesProvider sun, PVCoordinatesProvider pvProv, Frame inertialFrame, TurnSpan turnSpan) {
        this.date = date;
        this.dateDS = this.addDerivatives(date);
        this.sun = sun;
        this.pvProv = pvProv;
        this.inertialFrame = inertialFrame;
        TimeStampedFieldPVCoordinates<DerivativeStructure> sunPVDS = sun.getPVCoordinates(this.dateDS, inertialFrame);
        TimeStampedPVCoordinates svPV = pvProv.getPVCoordinates(date, inertialFrame);
        FieldPVCoordinates<DerivativeStructure> svPVDS = svPV.toDerivativeStructurePV(FACTORY.getCompiler().getOrder());
        this.svbCos = ((DerivativeStructure)FieldVector3D.dotProduct(sunPVDS.getPosition(), svPVDS.getPosition())).divide(((DerivativeStructure)sunPVDS.getPosition().getNorm()).multiply((DerivativeStructure)svPVDS.getPosition().getNorm()));
        this.morning = Vector3D.dotProduct((Vector3D)svPV.getVelocity(), (Vector3D)sunPVDS.getPosition().toVector3D()) >= 0.0;
        this.muRate = svPV.getAngularVelocity().getNorm();
        this.turnSpan = turnSpan;
        DerivativeStructure absDelta = this.svbCos.getValue() <= 0.0 ? this.inOrbitPlaneAbsoluteAngle(this.svbCos.acos().negate().add(Math.PI)) : this.inOrbitPlaneAbsoluteAngle(this.svbCos.acos());
        this.delta = (DerivativeStructure)FastMath.copySign((RealFieldElement)absDelta, (double)(-absDelta.getPartialDerivative(new int[]{1})));
    }

    private AbsoluteDate removeDerivatives(FieldAbsoluteDate<DerivativeStructure> d) {
        return d.toAbsoluteDate();
    }

    private FieldAbsoluteDate<DerivativeStructure> addDerivatives(AbsoluteDate d) {
        return new FieldAbsoluteDate<DerivativeStructure>(FACTORY.getDerivativeField(), d).shiftedBy(FACTORY.variable(0, 0.0));
    }

    public TimeStampedAngularCoordinates nominalYaw(AbsoluteDate d) {
        TimeStampedPVCoordinates svPV = this.pvProv.getPVCoordinates(d, this.inertialFrame);
        return new TimeStampedAngularCoordinates(d, svPV.normalize(), PVCoordinates.crossProduct(this.sun.getPVCoordinates(d, this.inertialFrame), svPV).normalize(), MINUS_Z_PV, PLUS_Y_PV, 1.0E-9);
    }

    public double beta(AbsoluteDate d) {
        TimeStampedPVCoordinates svPV = this.pvProv.getPVCoordinates(d, this.inertialFrame);
        return 1.5707963267948966 - Vector3D.angle((Vector3D)this.sun.getPVCoordinates(d, this.inertialFrame).getPosition(), (Vector3D)svPV.getMomentum());
    }

    private DerivativeStructure betaDS(FieldAbsoluteDate<DerivativeStructure> d) {
        TimeStampedPVCoordinates svPV = this.pvProv.getPVCoordinates(this.removeDerivatives(d), this.inertialFrame);
        FieldPVCoordinates<DerivativeStructure> svPVDS = svPV.toDerivativeStructurePV(FACTORY.getCompiler().getOrder());
        return ((DerivativeStructure)FieldVector3D.angle(this.sun.getPVCoordinates(d, this.inertialFrame).getPosition(), svPVDS.getMomentum())).negate().add(1.5707963267948966);
    }

    public DerivativeStructure betaDS() {
        return this.betaDS(this.dateDS);
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public TurnSpan getTurnSpan() {
        return this.turnSpan;
    }

    public double getSVBcos() {
        return this.svbCos.getValue();
    }

    public double getSecuredBeta() {
        double beta = this.beta(this.getDate());
        return FastMath.abs((double)beta) < BETA_SIGN_CHANGE_PROTECTION ? this.beta(this.turnSpan.getTurnStartDate()) : beta;
    }

    public boolean linearModelStillActive(double linearPhi, double phiDot) {
        double dtMax;
        double dt0 = this.turnSpan.getTurnEndDate().durationFrom(this.date);
        UnivariateFunction yawReached = dt -> {
            AbsoluteDate t = this.date.shiftedBy(dt);
            Vector3D pSun = this.sun.getPVCoordinates(t, this.inertialFrame).getPosition();
            TimeStampedPVCoordinates pv = this.pvProv.getPVCoordinates(t, this.inertialFrame);
            Vector3D pSat = pv.getPosition();
            Vector3D targetX = Vector3D.crossProduct((Vector3D)pSat, (Vector3D)Vector3D.crossProduct((Vector3D)pSun, (Vector3D)pSat)).normalize();
            double phi = linearPhi + dt * phiDot;
            SinCos sc = FastMath.sinCos((double)phi);
            Vector3D pU = pv.getPosition().normalize();
            Vector3D mU = pv.getMomentum().normalize();
            Vector3D omega = new Vector3D(-phiDot, pU);
            Vector3D currentX = new Vector3D(-sc.sin(), mU, -sc.cos(), Vector3D.crossProduct((Vector3D)pU, (Vector3D)mU));
            Vector3D currentXDot = Vector3D.crossProduct((Vector3D)omega, (Vector3D)currentX);
            return Vector3D.dotProduct((Vector3D)targetX, (Vector3D)currentXDot);
        };
        double fullTurn = Math.PI * 2 / FastMath.abs((double)phiDot);
        double dtMin = FastMath.min((double)this.turnSpan.getTurnStartDate().durationFrom(this.date), (double)(dt0 - 60.0));
        double[] bracket = UnivariateSolverUtils.bracket((UnivariateFunction)yawReached, (double)dt0, (double)dtMin, (double)(dtMax = FastMath.max((double)(dtMin + fullTurn), (double)(dt0 + 60.0))), (double)(fullTurn / 100.0), (double)1.0, (int)100);
        if (yawReached.value(bracket[0]) <= 0.0) {
            bracket = UnivariateSolverUtils.bracket((UnivariateFunction)yawReached, (double)(0.5 * (bracket[0] + bracket[1] + fullTurn)), (double)bracket[1], (double)(bracket[1] + fullTurn), (double)(fullTurn / 100.0), (double)1.0, (int)100);
        }
        double dt2 = new BracketingNthOrderBrentSolver(0.001, 5).solve(100, yawReached, bracket[0], bracket[1]);
        this.turnSpan.updateEnd(this.date.shiftedBy(dt2), this.date);
        return dt2 > 0.0;
    }

    public boolean setUpTurnRegion(double cosNight, double cosNoon) {
        this.cNight = cosNight;
        this.cNoon = cosNoon;
        if (this.svbCos.getValue() < this.cNight || this.svbCos.getValue() > this.cNoon) {
            return true;
        }
        return this.inTurnTimeRange();
    }

    public DerivativeStructure getDeltaDS() {
        return this.delta;
    }

    public double getOrbitAngleSinceMidnight() {
        double absAngle = this.inOrbitPlaneAbsoluteAngle(Math.PI - FastMath.acos((double)this.svbCos.getValue()));
        return this.morning ? absAngle : -absAngle;
    }

    public boolean inSunSide() {
        return this.svbCos.getValue() > 0.0;
    }

    public double getYawStart(double sunBeta) {
        double halfSpan = 0.5 * this.turnSpan.getTurnDuration() * this.muRate;
        return this.computePhi(sunBeta, FastMath.copySign((double)halfSpan, (double)this.svbCos.getValue()));
    }

    public double getYawEnd(double sunBeta) {
        double halfSpan = 0.5 * this.turnSpan.getTurnDuration() * this.muRate;
        return this.computePhi(sunBeta, FastMath.copySign((double)halfSpan, (double)(-this.svbCos.getValue())));
    }

    public double yawRate(double sunBeta) {
        return (this.getYawEnd(sunBeta) - this.getYawStart(sunBeta)) / this.turnSpan.getTurnDuration();
    }

    public double getMuRate() {
        return this.muRate;
    }

    private DerivativeStructure inOrbitPlaneAbsoluteAngle(DerivativeStructure angle) {
        return (DerivativeStructure)FastMath.acos((RealFieldElement)((DerivativeStructure)FastMath.cos((RealFieldElement)angle)).divide(FastMath.cos((double)this.beta(this.getDate()))));
    }

    public double inOrbitPlaneAbsoluteAngle(double angle) {
        return FastMath.acos((double)(FastMath.cos((double)angle) / FastMath.cos((double)this.beta(this.getDate()))));
    }

    public double computePhi(double sunBeta, double inOrbitPlaneAngle) {
        return FastMath.atan2((double)(-FastMath.tan((double)sunBeta)), (double)FastMath.sin((double)inOrbitPlaneAngle));
    }

    public void setHalfSpan(double halfSpan, double endMargin) {
        AbsoluteDate start = this.date.shiftedBy((this.delta.getValue() - halfSpan) / this.muRate);
        AbsoluteDate end = this.date.shiftedBy((this.delta.getValue() + halfSpan) / this.muRate);
        AbsoluteDate estimationDate = this.getDate();
        if (this.turnSpan == null) {
            this.turnSpan = new TurnSpan(start, end, estimationDate, endMargin);
        } else {
            this.turnSpan.updateStart(start, estimationDate);
            this.turnSpan.updateEnd(end, estimationDate);
        }
    }

    public boolean inTurnTimeRange() {
        return this.turnSpan != null && this.turnSpan.inTurnTimeRange(this.getDate());
    }

    public double timeSinceTurnStart() {
        return this.getDate().durationFrom(this.turnSpan.getTurnStartDate());
    }

    public TimeStampedAngularCoordinates turnCorrectedAttitude(double yaw, double yawDot) {
        return this.turnCorrectedAttitude(FACTORY.build(new double[]{yaw, yawDot, 0.0}));
    }

    public TimeStampedAngularCoordinates turnCorrectedAttitude(DerivativeStructure yaw) {
        TimeStampedPVCoordinates svPV = this.pvProv.getPVCoordinates(this.date, this.inertialFrame);
        Vector3D p = svPV.getPosition();
        Vector3D v = svPV.getVelocity();
        Vector3D a = svPV.getAcceleration();
        double r2 = p.getNormSq();
        double r = FastMath.sqrt((double)r2);
        Vector3D keplerianJerk = new Vector3D(-3.0 * Vector3D.dotProduct((Vector3D)p, (Vector3D)v) / r2, a, -a.getNorm() / r, v);
        PVCoordinates velocity = new PVCoordinates(v, a, keplerianJerk);
        PVCoordinates momentum = PVCoordinates.crossProduct(svPV, velocity);
        FieldSinCos sc = FastMath.sinCos((RealFieldElement)yaw);
        DerivativeStructure c = ((DerivativeStructure)sc.cos()).negate();
        DerivativeStructure s = ((DerivativeStructure)sc.sin()).negate();
        Vector3D m0 = new Vector3D(s.getValue(), c.getValue(), 0.0);
        Vector3D m1 = new Vector3D(s.getPartialDerivative(new int[]{1}), c.getPartialDerivative(new int[]{1}), 0.0);
        Vector3D m2 = new Vector3D(s.getPartialDerivative(new int[]{2}), c.getPartialDerivative(new int[]{2}), 0.0);
        return new TimeStampedAngularCoordinates(this.date, svPV.normalize(), momentum.normalize(), MINUS_Z_PV, new PVCoordinates(m0, m1, m2), 1.0E-9);
    }

    public TimeStampedAngularCoordinates orbitNormalYaw() {
        Transform t = LOFType.VVLH.transformFromInertial(this.date, this.pvProv.getPVCoordinates(this.date, this.inertialFrame));
        return new TimeStampedAngularCoordinates(this.date, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }
}

