/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.Collections;
import java.util.List;
import org.orekit.gnss.ObservationData;
import org.orekit.gnss.RinexHeader;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public class ObservationDataSet
implements TimeStamped {
    private final RinexHeader header;
    private final SatelliteSystem satelliteSystem;
    private final int prnNumber;
    private final AbsoluteDate tObs;
    private final List<ObservationData> observationData;
    private final double rcvrClkOffset;

    public ObservationDataSet(RinexHeader header, SatelliteSystem satelliteSystem, int prnNumber, AbsoluteDate tObs, double rcvrClkOffset, List<ObservationData> observationData) {
        this.header = header;
        this.satelliteSystem = satelliteSystem;
        this.prnNumber = prnNumber;
        this.tObs = tObs;
        this.observationData = observationData;
        this.rcvrClkOffset = rcvrClkOffset;
    }

    public RinexHeader getHeader() {
        return this.header;
    }

    public SatelliteSystem getSatelliteSystem() {
        return this.satelliteSystem;
    }

    public int getPrnNumber() {
        return this.prnNumber;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.tObs;
    }

    public List<ObservationData> getObservationData() {
        return Collections.unmodifiableList(this.observationData);
    }

    public double getRcvrClkOffset() {
        return this.rcvrClkOffset;
    }
}

