/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.propagation.analytical.gnss.GLONASSOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GLONASSDate;

public class GLONASSEphemeris
implements GLONASSOrbitalElements {
    private final int n4;
    private final int nt;
    private final double tb;
    private final double x;
    private final double xDot;
    private final double xDotDot;
    private final double y;
    private final double yDot;
    private final double yDotDot;
    private final double z;
    private final double zDot;
    private final double zDotDot;
    private final AbsoluteDate date;

    @DefaultDataContext
    public GLONASSEphemeris(int n4, int nt, double tb, double x, double xDot, double xDotDot, double y, double yDot, double yDotDot, double z, double zDot, double zDotDot) {
        this(n4, nt, tb, x, xDot, xDotDot, y, yDot, yDotDot, z, zDot, zDotDot, new GLONASSDate(nt, n4, tb, DataContext.getDefault().getTimeScales().getGLONASS()).getDate());
    }

    public GLONASSEphemeris(int n4, int nt, double tb, double x, double xDot, double xDotDot, double y, double yDot, double yDotDot, double z, double zDot, double zDotDot, AbsoluteDate date) {
        this.n4 = n4;
        this.nt = nt;
        this.tb = tb;
        this.x = x;
        this.xDot = xDot;
        this.xDotDot = xDotDot;
        this.y = y;
        this.yDot = yDot;
        this.yDotDot = yDotDot;
        this.z = z;
        this.zDot = zDot;
        this.zDotDot = zDotDot;
        this.date = date;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public int getN4() {
        return this.n4;
    }

    @Override
    public int getNa() {
        return this.nt;
    }

    @Override
    public double getTime() {
        return this.tb;
    }

    @Override
    public double getXDot() {
        return this.xDot;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getXDotDot() {
        return this.xDotDot;
    }

    @Override
    public double getYDot() {
        return this.yDot;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getYDotDot() {
        return this.yDotDot;
    }

    @Override
    public double getZDot() {
        return this.zDot;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getZDotDot() {
        return this.zDotDot;
    }
}

