/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.gnss.DOP;
import org.orekit.propagation.Propagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ElevationMask;

public class DOPComputer {
    public static final double DOP_MIN_ELEVATION = 0.0;
    private static final int DOP_MIN_PROPAGATORS = 4;
    private final TopocentricFrame frame;
    private final ElevationMask elevationMask;
    private final double minElevation;

    private DOPComputer(TopocentricFrame frame, double minElev, ElevationMask elevMask) {
        this.frame = frame;
        this.minElevation = minElev;
        this.elevationMask = elevMask;
    }

    public static DOPComputer create(OneAxisEllipsoid shape, GeodeticPoint location) {
        return new DOPComputer(new TopocentricFrame(shape, location, "Location"), 0.0, null);
    }

    public DOPComputer withMinElevation(double newMinElevation) {
        return new DOPComputer(this.frame, newMinElevation, null);
    }

    public DOPComputer withElevationMask(ElevationMask newElevationMask) {
        return new DOPComputer(this.frame, 0.0, newElevationMask);
    }

    public DOP compute(AbsoluteDate date, List<Propagator> gnss) {
        if (gnss.size() < 4) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_GNSS_FOR_DOP, gnss.size(), 4);
        }
        double gdop = Double.NaN;
        double pdop = Double.NaN;
        double hdop = Double.NaN;
        double vdop = Double.NaN;
        double tdop = Double.NaN;
        double[][] satDir = new double[gnss.size()][4];
        int satNb = 0;
        for (Propagator prop : gnss) {
            Vector3D pos = prop.getPVCoordinates(date, this.frame).getPosition();
            double elev = this.frame.getElevation(pos, (Frame)this.frame, date);
            double d = this.elevationMask != null ? this.elevationMask.getElevation(this.frame.getAzimuth(pos, (Frame)this.frame, date)) : this.minElevation;
            double elMin = d;
            if (!(elev > elMin)) continue;
            Vector3D r = pos.normalize();
            satDir[satNb][0] = r.getX();
            satDir[satNb][1] = r.getY();
            satDir[satNb][2] = r.getZ();
            satDir[satNb][3] = -1.0;
            ++satNb;
        }
        if (satNb > 3) {
            RealMatrix h = MatrixUtils.createRealMatrix((int)satNb, (int)4);
            for (int k = 0; k < satNb; ++k) {
                h.setRow(k, satDir[k]);
            }
            RealMatrix hInv = MatrixUtils.inverse((RealMatrix)h.transpose().multiply(h));
            double sx2 = hInv.getEntry(0, 0);
            double sy2 = hInv.getEntry(1, 1);
            double sz2 = hInv.getEntry(2, 2);
            double st2 = hInv.getEntry(3, 3);
            gdop = FastMath.sqrt((double)hInv.getTrace());
            pdop = FastMath.sqrt((double)(sx2 + sy2 + sz2));
            hdop = FastMath.sqrt((double)(sx2 + sy2));
            vdop = FastMath.sqrt((double)sz2);
            tdop = FastMath.sqrt((double)st2);
        }
        return new DOP(this.frame.getPoint(), date, satNb, gdop, pdop, hdop, vdop, tdop);
    }

    public double getMinElevation() {
        return this.minElevation;
    }

    public ElevationMask getElevationMask() {
        return this.elevationMask;
    }
}

