/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolable;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Transform
implements TimeStamped,
TimeShiftable<Transform>,
TimeInterpolable<Transform>,
Serializable {
    public static final Transform IDENTITY = new IdentityTransform();
    private static final long serialVersionUID = 210140410L;
    private final AbsoluteDate date;
    private final PVCoordinates cartesian;
    private final AngularCoordinates angular;

    private Transform(AbsoluteDate date, PVCoordinates cartesian, AngularCoordinates angular) {
        this.date = date;
        this.cartesian = cartesian;
        this.angular = angular;
    }

    public Transform(AbsoluteDate date, Vector3D translation) {
        this(date, new PVCoordinates(translation, Vector3D.ZERO, Vector3D.ZERO), AngularCoordinates.IDENTITY);
    }

    public Transform(AbsoluteDate date, Rotation rotation) {
        this(date, PVCoordinates.ZERO, new AngularCoordinates(rotation, Vector3D.ZERO));
    }

    public Transform(AbsoluteDate date, Vector3D translation, Vector3D velocity) {
        this(date, new PVCoordinates(translation, velocity, Vector3D.ZERO), AngularCoordinates.IDENTITY);
    }

    public Transform(AbsoluteDate date, Vector3D translation, Vector3D velocity, Vector3D acceleration) {
        this(date, new PVCoordinates(translation, velocity, acceleration), AngularCoordinates.IDENTITY);
    }

    public Transform(AbsoluteDate date, PVCoordinates cartesian) {
        this(date, cartesian, AngularCoordinates.IDENTITY);
    }

    public Transform(AbsoluteDate date, Rotation rotation, Vector3D rotationRate) {
        this(date, PVCoordinates.ZERO, new AngularCoordinates(rotation, rotationRate, Vector3D.ZERO));
    }

    public Transform(AbsoluteDate date, Rotation rotation, Vector3D rotationRate, Vector3D rotationAcceleration) {
        this(date, PVCoordinates.ZERO, new AngularCoordinates(rotation, rotationRate, rotationAcceleration));
    }

    public Transform(AbsoluteDate date, AngularCoordinates angular) {
        this(date, PVCoordinates.ZERO, angular);
    }

    public Transform(AbsoluteDate date, Transform first, Transform second) {
        this(date, new PVCoordinates(Transform.compositeTranslation(first, second), Transform.compositeVelocity(first, second), Transform.compositeAcceleration(first, second)), new AngularCoordinates(Transform.compositeRotation(first, second), Transform.compositeRotationRate(first, second), Transform.compositeRotationAcceleration(first, second)));
    }

    private static Vector3D compositeTranslation(Transform first, Transform second) {
        Vector3D p1 = first.cartesian.getPosition();
        Rotation r1 = first.angular.getRotation();
        Vector3D p2 = second.cartesian.getPosition();
        return p1.add((Vector)r1.applyInverseTo(p2));
    }

    private static Vector3D compositeVelocity(Transform first, Transform second) {
        Vector3D v1 = first.cartesian.getVelocity();
        Rotation r1 = first.angular.getRotation();
        Vector3D o1 = first.angular.getRotationRate();
        Vector3D p2 = second.cartesian.getPosition();
        Vector3D v2 = second.cartesian.getVelocity();
        Vector3D crossP = Vector3D.crossProduct((Vector3D)o1, (Vector3D)p2);
        return v1.add((Vector)r1.applyInverseTo(v2.add((Vector)crossP)));
    }

    private static Vector3D compositeAcceleration(Transform first, Transform second) {
        Vector3D a1 = first.cartesian.getAcceleration();
        Rotation r1 = first.angular.getRotation();
        Vector3D o1 = first.angular.getRotationRate();
        Vector3D oDot1 = first.angular.getRotationAcceleration();
        Vector3D p2 = second.cartesian.getPosition();
        Vector3D v2 = second.cartesian.getVelocity();
        Vector3D a2 = second.cartesian.getAcceleration();
        Vector3D crossCrossP = Vector3D.crossProduct((Vector3D)o1, (Vector3D)Vector3D.crossProduct((Vector3D)o1, (Vector3D)p2));
        Vector3D crossV = Vector3D.crossProduct((Vector3D)o1, (Vector3D)v2);
        Vector3D crossDotP = Vector3D.crossProduct((Vector3D)oDot1, (Vector3D)p2);
        return a1.add((Vector)r1.applyInverseTo(new Vector3D(1.0, a2, 2.0, crossV, 1.0, crossCrossP, 1.0, crossDotP)));
    }

    private static Rotation compositeRotation(Transform first, Transform second) {
        Rotation r1 = first.angular.getRotation();
        Rotation r2 = second.angular.getRotation();
        return r1.compose(r2, RotationConvention.FRAME_TRANSFORM);
    }

    private static Vector3D compositeRotationRate(Transform first, Transform second) {
        Vector3D o1 = first.angular.getRotationRate();
        Rotation r2 = second.angular.getRotation();
        Vector3D o2 = second.angular.getRotationRate();
        return o2.add((Vector)r2.applyTo(o1));
    }

    private static Vector3D compositeRotationAcceleration(Transform first, Transform second) {
        Vector3D o1 = first.angular.getRotationRate();
        Vector3D oDot1 = first.angular.getRotationAcceleration();
        Rotation r2 = second.angular.getRotation();
        Vector3D o2 = second.angular.getRotationRate();
        Vector3D oDot2 = second.angular.getRotationAcceleration();
        return new Vector3D(1.0, oDot2, 1.0, r2.applyTo(oDot1), -1.0, Vector3D.crossProduct((Vector3D)o2, (Vector3D)r2.applyTo(o1)));
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public Transform shiftedBy(double dt) {
        return new Transform(this.date.shiftedBy(dt), this.cartesian.shiftedBy(dt), this.angular.shiftedBy(dt));
    }

    @Override
    public Transform interpolate(AbsoluteDate interpolationDate, Stream<Transform> sample) {
        return Transform.interpolate(interpolationDate, CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_RRA, sample.collect(Collectors.toList()));
    }

    public static Transform interpolate(AbsoluteDate date, CartesianDerivativesFilter cFilter, AngularDerivativesFilter aFilter, Collection<Transform> sample) {
        ArrayList<TimeStampedPVCoordinates> datedPV = new ArrayList<TimeStampedPVCoordinates>(sample.size());
        ArrayList<TimeStampedAngularCoordinates> datedAC = new ArrayList<TimeStampedAngularCoordinates>(sample.size());
        for (Transform t : sample) {
            datedPV.add(new TimeStampedPVCoordinates(t.getDate(), t.getTranslation(), t.getVelocity(), t.getAcceleration()));
            datedAC.add(new TimeStampedAngularCoordinates(t.getDate(), t.getRotation(), t.getRotationRate(), t.getRotationAcceleration()));
        }
        TimeStampedPVCoordinates interpolatedPV = TimeStampedPVCoordinates.interpolate(date, cFilter, datedPV);
        TimeStampedAngularCoordinates interpolatedAC = TimeStampedAngularCoordinates.interpolate(date, aFilter, datedAC);
        return new Transform(date, interpolatedPV, interpolatedAC);
    }

    public Transform getInverse() {
        Rotation r = this.angular.getRotation();
        Vector3D o = this.angular.getRotationRate();
        Vector3D oDot = this.angular.getRotationAcceleration();
        Vector3D rp = r.applyTo(this.cartesian.getPosition());
        Vector3D rv = r.applyTo(this.cartesian.getVelocity());
        Vector3D ra = r.applyTo(this.cartesian.getAcceleration());
        Vector3D pInv = rp.negate();
        Vector3D crossP = Vector3D.crossProduct((Vector3D)o, (Vector3D)rp);
        Vector3D vInv = crossP.subtract((Vector)rv);
        Vector3D crossV = Vector3D.crossProduct((Vector3D)o, (Vector3D)rv);
        Vector3D crossDotP = Vector3D.crossProduct((Vector3D)oDot, (Vector3D)rp);
        Vector3D crossCrossP = Vector3D.crossProduct((Vector3D)o, (Vector3D)crossP);
        Vector3D aInv = new Vector3D(-1.0, ra, 2.0, crossV, 1.0, crossDotP, -1.0, crossCrossP);
        return new Transform(this.date, new PVCoordinates(pInv, vInv, aInv), this.angular.revert());
    }

    public Transform freeze() {
        return new Transform(this.date, new PVCoordinates(this.cartesian.getPosition(), Vector3D.ZERO, Vector3D.ZERO), new AngularCoordinates(this.angular.getRotation(), Vector3D.ZERO, Vector3D.ZERO));
    }

    public Vector3D transformPosition(Vector3D position) {
        return this.angular.getRotation().applyTo(this.cartesian.getPosition().add((Vector)position));
    }

    public <T extends RealFieldElement<T>> FieldVector3D<T> transformPosition(FieldVector3D<T> position) {
        return FieldRotation.applyTo((Rotation)this.angular.getRotation(), (FieldVector3D)position.add(this.cartesian.getPosition()));
    }

    public Vector3D transformVector(Vector3D vector) {
        return this.angular.getRotation().applyTo(vector);
    }

    public <T extends RealFieldElement<T>> FieldVector3D<T> transformVector(FieldVector3D<T> vector) {
        return FieldRotation.applyTo((Rotation)this.angular.getRotation(), vector);
    }

    public Line transformLine(Line line) {
        Vector3D transformedP0 = this.transformPosition(line.getOrigin());
        Vector3D transformedP1 = this.transformPosition(line.pointAt(1000000.0));
        return new Line(transformedP0, transformedP1, 1.0E-10);
    }

    public PVCoordinates transformPVCoordinates(PVCoordinates pva) {
        return this.angular.applyTo(new PVCoordinates(1.0, pva, 1.0, this.cartesian));
    }

    public TimeStampedPVCoordinates transformPVCoordinates(TimeStampedPVCoordinates pv) {
        return this.angular.applyTo(new TimeStampedPVCoordinates(pv.getDate(), 1.0, pv, 1.0, this.cartesian));
    }

    public <T extends RealFieldElement<T>> FieldPVCoordinates<T> transformPVCoordinates(FieldPVCoordinates<T> pv) {
        return this.angular.applyTo(new FieldPVCoordinates(pv.getPosition().add(this.cartesian.getPosition()), pv.getVelocity().add(this.cartesian.getVelocity()), pv.getAcceleration().add(this.cartesian.getAcceleration())));
    }

    public <T extends RealFieldElement<T>> TimeStampedFieldPVCoordinates<T> transformPVCoordinates(TimeStampedFieldPVCoordinates<T> pv) {
        return this.angular.applyTo(new TimeStampedFieldPVCoordinates<T>(pv.getDate(), pv.getPosition().add(this.cartesian.getPosition()), pv.getVelocity().add(this.cartesian.getVelocity()), pv.getAcceleration().add(this.cartesian.getAcceleration())));
    }

    public void getJacobian(CartesianDerivativesFilter selector, double[][] jacobian) {
        double[][] mData = this.angular.getRotation().getMatrix();
        System.arraycopy(mData[0], 0, jacobian[0], 0, 3);
        System.arraycopy(mData[1], 0, jacobian[1], 0, 3);
        System.arraycopy(mData[2], 0, jacobian[2], 0, 3);
        if (selector.getMaxOrder() >= 1) {
            Arrays.fill(jacobian[0], 3, 6, 0.0);
            Arrays.fill(jacobian[1], 3, 6, 0.0);
            Arrays.fill(jacobian[2], 3, 6, 0.0);
            Vector3D o = this.angular.getRotationRate();
            double ox = o.getX();
            double oy = o.getY();
            double oz = o.getZ();
            for (int i = 0; i < 3; ++i) {
                jacobian[3][i] = -(oy * mData[2][i] - oz * mData[1][i]);
                jacobian[4][i] = -(oz * mData[0][i] - ox * mData[2][i]);
                jacobian[5][i] = -(ox * mData[1][i] - oy * mData[0][i]);
            }
            System.arraycopy(mData[0], 0, jacobian[3], 3, 3);
            System.arraycopy(mData[1], 0, jacobian[4], 3, 3);
            System.arraycopy(mData[2], 0, jacobian[5], 3, 3);
            if (selector.getMaxOrder() >= 2) {
                int i;
                Arrays.fill(jacobian[0], 6, 9, 0.0);
                Arrays.fill(jacobian[1], 6, 9, 0.0);
                Arrays.fill(jacobian[2], 6, 9, 0.0);
                Arrays.fill(jacobian[3], 6, 9, 0.0);
                Arrays.fill(jacobian[4], 6, 9, 0.0);
                Arrays.fill(jacobian[5], 6, 9, 0.0);
                Vector3D oDot = this.angular.getRotationAcceleration();
                double oDotx = oDot.getX();
                double oDoty = oDot.getY();
                double oDotz = oDot.getZ();
                for (i = 0; i < 3; ++i) {
                    jacobian[6][i] = -(oDoty * mData[2][i] - oDotz * mData[1][i]) - (oy * jacobian[5][i] - oz * jacobian[4][i]);
                    jacobian[7][i] = -(oDotz * mData[0][i] - oDotx * mData[2][i]) - (oz * jacobian[3][i] - ox * jacobian[5][i]);
                    jacobian[8][i] = -(oDotx * mData[1][i] - oDoty * mData[0][i]) - (ox * jacobian[4][i] - oy * jacobian[3][i]);
                }
                for (i = 0; i < 3; ++i) {
                    jacobian[6][i + 3] = -2.0 * (oy * mData[2][i] - oz * mData[1][i]);
                    jacobian[7][i + 3] = -2.0 * (oz * mData[0][i] - ox * mData[2][i]);
                    jacobian[8][i + 3] = -2.0 * (ox * mData[1][i] - oy * mData[0][i]);
                }
                System.arraycopy(mData[0], 0, jacobian[6], 6, 3);
                System.arraycopy(mData[1], 0, jacobian[7], 6, 3);
                System.arraycopy(mData[2], 0, jacobian[8], 6, 3);
            }
        }
    }

    public PVCoordinates getCartesian() {
        return this.cartesian;
    }

    public Vector3D getTranslation() {
        return this.cartesian.getPosition();
    }

    public Vector3D getVelocity() {
        return this.cartesian.getVelocity();
    }

    public Vector3D getAcceleration() {
        return this.cartesian.getAcceleration();
    }

    public AngularCoordinates getAngular() {
        return this.angular;
    }

    public Rotation getRotation() {
        return this.angular.getRotation();
    }

    public Vector3D getRotationRate() {
        return this.angular.getRotationRate();
    }

    public Vector3D getRotationAcceleration() {
        return this.angular.getRotationAcceleration();
    }

    private static class IdentityTransform
    extends Transform {
        private static final long serialVersionUID = -9042082036141830517L;

        IdentityTransform() {
            super(AbsoluteDate.ARBITRARY_EPOCH, PVCoordinates.ZERO, AngularCoordinates.IDENTITY);
        }

        @Override
        public Transform shiftedBy(double dt) {
            return this;
        }

        @Override
        public Transform getInverse() {
            return this;
        }

        @Override
        public Vector3D transformPosition(Vector3D position) {
            return position;
        }

        @Override
        public Vector3D transformVector(Vector3D vector) {
            return vector;
        }

        @Override
        public Line transformLine(Line line) {
            return line;
        }

        @Override
        public PVCoordinates transformPVCoordinates(PVCoordinates pv) {
            return pv;
        }

        @Override
        public void getJacobian(CartesianDerivativesFilter selector, double[][] jacobian) {
            int n = 3 * (selector.getMaxOrder() + 1);
            for (int i = 0; i < n; ++i) {
                Arrays.fill(jacobian[i], 0, n, 0.0);
                jacobian[i][i] = 1.0;
            }
        }
    }
}

