/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.utils.ExtendedPVCoordinatesProvider;

public abstract class AbstractRadiationForceModel
extends AbstractForceModel {
    private static final double ANGULAR_MARGIN = 1.0E-10;
    private final double equatorialRadius;
    private final ExtendedPVCoordinatesProvider sun;

    protected AbstractRadiationForceModel(ExtendedPVCoordinatesProvider sun, double equatorialRadius) {
        this.sun = sun;
        this.equatorialRadius = equatorialRadius;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.of(new UmbraDetector(), new PenumbraDetector());
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.of(new FieldUmbraDetector<T>(field), new FieldPenumbraDetector<T>(field));
    }

    protected double[] getEclipseAngles(Vector3D sunPosition, Vector3D position) {
        double[] angle = new double[3];
        Vector3D satSunVector = sunPosition.subtract((Vector)position);
        angle[0] = Vector3D.angle((Vector3D)satSunVector, (Vector3D)position.negate());
        double r = position.getNorm();
        if (r <= this.equatorialRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, r);
        }
        angle[1] = FastMath.asin((double)(this.equatorialRadius / r));
        angle[2] = FastMath.asin((double)(6.955E8 / satSunVector.getNorm()));
        return angle;
    }

    protected <T extends RealFieldElement<T>> T[] getEclipseAngles(FieldVector3D<T> sunPosition, FieldVector3D<T> position) {
        RealFieldElement[] angle = (RealFieldElement[])MathArrays.buildArray((Field)position.getX().getField(), (int)3);
        FieldVector3D mP = position.negate();
        FieldVector3D satSunVector = mP.add(sunPosition);
        angle[0] = FieldVector3D.angle((FieldVector3D)satSunVector, (FieldVector3D)mP);
        RealFieldElement r = position.getNorm();
        if (r.getReal() <= this.equatorialRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, r);
        }
        angle[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)r.reciprocal()).multiply(this.equatorialRadius)).asin();
        angle[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)satSunVector.getNorm().reciprocal()).multiply(6.955E8)).asin();
        return angle;
    }

    private class FieldPenumbraDetector<T extends RealFieldElement<T>>
    extends FieldAbstractDetector<FieldPenumbraDetector<T>, T> {
        FieldPenumbraDetector(Field<T> field) {
            super((RealFieldElement)((RealFieldElement)field.getZero()).add(60.0), (RealFieldElement)((RealFieldElement)field.getZero()).add(0.001), 100, new FieldEventHandler<FieldPenumbraDetector<T>, T>(){

                @Override
                public Action eventOccurred(FieldSpacecraftState<T> s, FieldPenumbraDetector<T> detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
        }

        private FieldPenumbraDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldPenumbraDetector<T>, T> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected FieldPenumbraDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldPenumbraDetector<T>, T> newHandler) {
            return new FieldPenumbraDetector(AbstractRadiationForceModel.this, newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public T g(FieldSpacecraftState<T> s) {
            RealFieldElement[] angle = AbstractRadiationForceModel.this.getEclipseAngles(AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)angle[0].subtract((Object)angle[1])).subtract((Object)angle[2])).add(1.0E-10));
        }
    }

    private class FieldUmbraDetector<T extends RealFieldElement<T>>
    extends FieldAbstractDetector<FieldUmbraDetector<T>, T> {
        FieldUmbraDetector(Field<T> field) {
            super((RealFieldElement)((RealFieldElement)field.getZero()).add(60.0), (RealFieldElement)((RealFieldElement)field.getZero()).add(0.001), 100, new FieldEventHandler<FieldUmbraDetector<T>, T>(){

                @Override
                public Action eventOccurred(FieldSpacecraftState<T> s, FieldUmbraDetector<T> detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
        }

        private FieldUmbraDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldUmbraDetector<T>, T> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected FieldUmbraDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldUmbraDetector<T>, T> newHandler) {
            return new FieldUmbraDetector(AbstractRadiationForceModel.this, newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public T g(FieldSpacecraftState<T> s) {
            RealFieldElement[] angle = AbstractRadiationForceModel.this.getEclipseAngles(AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)angle[0].subtract((Object)angle[1])).add((Object)angle[2])).subtract(1.0E-10));
        }
    }

    private class PenumbraDetector
    extends AbstractDetector<PenumbraDetector> {
        PenumbraDetector() {
            super(60.0, 0.001, 100, new EventHandler<PenumbraDetector>(){

                @Override
                public Action eventOccurred(SpacecraftState s, PenumbraDetector detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
        }

        private PenumbraDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super PenumbraDetector> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected PenumbraDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super PenumbraDetector> newHandler) {
            return new PenumbraDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public double g(SpacecraftState s) {
            double[] angle = AbstractRadiationForceModel.this.getEclipseAngles(AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return angle[0] - angle[1] - angle[2] + 1.0E-10;
        }
    }

    private class UmbraDetector
    extends AbstractDetector<UmbraDetector> {
        UmbraDetector() {
            super(60.0, 0.001, 100, new EventHandler<UmbraDetector>(){

                @Override
                public Action eventOccurred(SpacecraftState s, UmbraDetector detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
        }

        private UmbraDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super UmbraDetector> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected UmbraDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super UmbraDetector> newHandler) {
            return new UmbraDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public double g(SpacecraftState s) {
            double[] angle = AbstractRadiationForceModel.this.getEclipseAngles(AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return angle[0] - angle[1] + angle[2] - 1.0E-10;
        }
    }
}

