/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.maneuvers.propulsion.AbstractConstantThrustPropulsionModel;
import org.orekit.utils.ParameterDriver;

public class BasicConstantThrustPropulsionModel
extends AbstractConstantThrustPropulsionModel {
    public static final String THRUST = "thrust";
    public static final String FLOW_RATE = "flow rate";
    public static final double THRUST_SCALE = FastMath.scalb((double)1.0, (int)-5);
    public static final double FLOW_RATE_SCALE = FastMath.scalb((double)1.0, (int)-12);
    private final ParameterDriver thrustDriver;
    private final ParameterDriver flowRateDriver;
    private final Vector3D direction;

    public BasicConstantThrustPropulsionModel(double thrust, double isp, Vector3D direction, String name) {
        super(thrust, isp, direction, name);
        this.direction = direction.normalize();
        double initialFlowRate = -thrust / (9.80665 * isp);
        this.thrustDriver = new ParameterDriver(name + THRUST, thrust, THRUST_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.flowRateDriver = new ParameterDriver(name + FLOW_RATE, initialFlowRate, FLOW_RATE_SCALE, Double.NEGATIVE_INFINITY, 0.0);
    }

    @Override
    public Vector3D getThrustVector() {
        return this.direction.scalarMultiply(this.thrustDriver.getValue());
    }

    @Override
    public double getFlowRate() {
        return this.flowRateDriver.getValue();
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.thrustDriver, this.flowRateDriver};
    }

    @Override
    public Vector3D getThrustVector(double[] parameters) {
        return this.direction.scalarMultiply(parameters[0]);
    }

    @Override
    public double getFlowRate(double[] parameters) {
        return parameters[1];
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> getThrustVector(T[] parameters) {
        return new FieldVector3D(parameters[0], this.direction);
    }

    @Override
    public <T extends RealFieldElement<T>> T getFlowRate(T[] parameters) {
        return parameters[1];
    }
}

