/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import java.util.Arrays;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.maneuvers.propulsion.PropulsionModel;
import org.orekit.forces.maneuvers.trigger.ManeuverTriggers;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class Maneuver
extends AbstractForceModel {
    private final AttitudeProvider attitudeOverride;
    private final PropulsionModel propulsionModel;
    private final ManeuverTriggers maneuverTriggers;

    public Maneuver(AttitudeProvider attitudeOverride, ManeuverTriggers maneuverTriggers, PropulsionModel propulsionModel) {
        this.maneuverTriggers = maneuverTriggers;
        this.attitudeOverride = attitudeOverride;
        this.propulsionModel = propulsionModel;
    }

    public String getName() {
        String name = this.propulsionModel.getName();
        if (name.length() < 1) {
            name = this.maneuverTriggers.getName();
        }
        return name;
    }

    public AttitudeProvider getAttitudeOverride() {
        return this.attitudeOverride;
    }

    public PropulsionModel getPropulsionModel() {
        return this.propulsionModel;
    }

    public ManeuverTriggers getManeuverTriggers() {
        return this.maneuverTriggers;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.propulsionModel.init(initialState, target);
        this.maneuverTriggers.init(initialState, target);
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) {
        double[] parameters = this.getParameters();
        if (this.maneuverTriggers.isFiring(s.getDate(), this.getManeuverTriggersParameters(parameters))) {
            adder.addNonKeplerianAcceleration(this.acceleration(s, parameters));
            adder.addMassDerivative(this.propulsionModel.getMassDerivatives(s, this.getPropulsionModelParameters(parameters)));
        }
    }

    @Override
    public <T extends RealFieldElement<T>> void addContribution(FieldSpacecraftState<T> s, FieldTimeDerivativesEquations<T> adder) {
        RealFieldElement[] parameters = this.getParameters(s.getDate().getField());
        if (this.maneuverTriggers.isFiring(s.getDate(), this.getManeuverTriggersParameters(parameters))) {
            adder.addNonKeplerianAcceleration(this.acceleration(s, parameters));
            adder.addMassDerivative(this.propulsionModel.getMassDerivatives(s, this.getPropulsionModelParameters(parameters)));
        }
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        if (this.maneuverTriggers.isFiring(s.getDate(), this.getManeuverTriggersParameters(parameters))) {
            Attitude maneuverAttitude = this.attitudeOverride == null ? s.getAttitude() : this.attitudeOverride.getAttitude(s.getOrbit(), s.getDate(), s.getFrame());
            return this.propulsionModel.getAcceleration(s, maneuverAttitude, this.getPropulsionModelParameters(parameters));
        }
        return Vector3D.ZERO;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        if (this.maneuverTriggers.isFiring(s.getDate(), this.getManeuverTriggersParameters((RealFieldElement[])parameters))) {
            FieldAttitude<T> maneuverAttitude = this.attitudeOverride == null ? s.getAttitude() : this.attitudeOverride.getAttitude(s.getOrbit(), s.getDate(), s.getFrame());
            return this.propulsionModel.getAcceleration(s, maneuverAttitude, this.getPropulsionModelParameters((RealFieldElement[])parameters));
        }
        return FieldVector3D.getZero((Field)s.getMu().getField());
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return this.maneuverTriggers.getEventsDetectors();
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return this.maneuverTriggers.getFieldEventsDetectors(field);
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        ParameterDriver[] propulsionModelDrivers = this.propulsionModel.getParametersDrivers();
        ParameterDriver[] maneuverTriggersDrivers = this.maneuverTriggers.getParametersDrivers();
        int propulsionModelDriversLength = propulsionModelDrivers.length;
        int maneuverTriggersDriversLength = maneuverTriggersDrivers.length;
        ParameterDriver[] drivers = new ParameterDriver[propulsionModelDriversLength + maneuverTriggersDriversLength];
        System.arraycopy(propulsionModelDrivers, 0, drivers, 0, propulsionModelDriversLength);
        System.arraycopy(maneuverTriggersDrivers, 0, drivers, propulsionModelDriversLength, maneuverTriggersDriversLength);
        return drivers;
    }

    private double[] getPropulsionModelParameters(double[] parameters) {
        return Arrays.copyOfRange(parameters, 0, this.propulsionModel.getParametersDrivers().length);
    }

    private <T extends RealFieldElement<T>> T[] getPropulsionModelParameters(T[] parameters) {
        return (RealFieldElement[])Arrays.copyOfRange(parameters, 0, this.propulsionModel.getParametersDrivers().length);
    }

    private double[] getManeuverTriggersParameters(double[] parameters) {
        int nbPropulsionModelDrivers = this.propulsionModel.getParametersDrivers().length;
        return Arrays.copyOfRange(parameters, nbPropulsionModelDrivers, nbPropulsionModelDrivers + this.maneuverTriggers.getParametersDrivers().length);
    }

    private <T extends RealFieldElement<T>> T[] getManeuverTriggersParameters(T[] parameters) {
        int nbPropulsionModelDrivers = this.propulsionModel.getParametersDrivers().length;
        return (RealFieldElement[])Arrays.copyOfRange(parameters, nbPropulsionModelDrivers, nbPropulsionModelDrivers + this.maneuverTriggers.getParametersDrivers().length);
    }
}

