/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public interface ForceModel {
    default public void init(SpacecraftState initialState, AbsoluteDate target) {
    }

    default public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) {
        adder.addNonKeplerianAcceleration(this.acceleration(s, this.getParameters()));
    }

    default public <T extends RealFieldElement<T>> void addContribution(FieldSpacecraftState<T> s, FieldTimeDerivativesEquations<T> adder) {
        adder.addNonKeplerianAcceleration(this.acceleration(s, this.getParameters(s.getDate().getField())));
    }

    default public double[] getParameters() {
        ParameterDriver[] drivers = this.getParametersDrivers();
        double[] parameters = new double[drivers.length];
        for (int i = 0; i < drivers.length; ++i) {
            parameters[i] = drivers[i].getValue();
        }
        return parameters;
    }

    default public <T extends RealFieldElement<T>> T[] getParameters(Field<T> field) {
        ParameterDriver[] drivers = this.getParametersDrivers();
        RealFieldElement[] parameters = (RealFieldElement[])MathArrays.buildArray(field, (int)drivers.length);
        for (int i = 0; i < drivers.length; ++i) {
            parameters[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(drivers[i].getValue());
        }
        return parameters;
    }

    public boolean dependsOnPositionOnly();

    public Vector3D acceleration(SpacecraftState var1, double[] var2);

    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> var1, T[] var2);

    public Stream<EventDetector> getEventsDetectors();

    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> var1);

    public ParameterDriver[] getParametersDrivers();

    public ParameterDriver getParameterDriver(String var1);

    public boolean isSupported(String var1);
}

