/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBodies;
import org.orekit.bodies.CelestialBody;
import org.orekit.data.DataContext;

public enum CenterName {
    SOLAR_SYSTEM_BARYCENTER{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getSolarSystemBarycenter();
        }
    }
    ,
    SUN{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getSun();
        }
    }
    ,
    MERCURY{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getMercury();
        }
    }
    ,
    VENUS{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getVenus();
        }
    }
    ,
    EARTH_MOON{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getEarthMoonBarycenter();
        }
    }
    ,
    EARTH{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getEarth();
        }
    }
    ,
    MOON{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getMoon();
        }
    }
    ,
    MARS{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getMars();
        }
    }
    ,
    JUPITER{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getJupiter();
        }
    }
    ,
    SATURN{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getSaturn();
        }
    }
    ,
    URANUS{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getUranus();
        }
    }
    ,
    NEPTUNE{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getNeptune();
        }
    }
    ,
    PLUTO{

        @Override
        public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
            return celestialBodies.getPluto();
        }
    };


    @DefaultDataContext
    public CelestialBody getCelestialBody() {
        return this.getCelestialBody(DataContext.getDefault().getCelestialBodies());
    }

    public abstract CelestialBody getCelestialBody(CelestialBodies var1);
}

