/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.OneWayGNSSPhase;
import org.orekit.estimation.measurements.modifiers.AbstractRelativisticClockModifier;
import org.orekit.utils.ParameterDriver;

public class RelativisticClockOneWayGNSSPhaseModifier
extends AbstractRelativisticClockModifier
implements EstimationModifier<OneWayGNSSPhase> {
    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<OneWayGNSSPhase> estimated) {
        double dtRel = this.relativisticCorrection(estimated);
        double wavelength = estimated.getObservedMeasurement().getWavelength();
        double cOverLambda = 2.99792458E8 / wavelength;
        double[] newValue = (double[])estimated.getEstimatedValue().clone();
        newValue[0] = newValue[0] - dtRel * cOverLambda;
        estimated.setEstimatedValue(newValue);
    }
}

