/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.iod;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.iod.IodGibbs;
import org.orekit.estimation.iod.IodLambert;
import org.orekit.frames.Frame;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class IodGooding {
    private final Frame frame;
    private final double mu;
    private double R;
    private double V;
    private double T;
    private Vector3D vObserverPosition1;
    private Vector3D vObserverPosition2;
    private Vector3D vObserverPosition3;
    private AbsoluteDate date1;
    private double R1;
    private double R2;
    private double R3;
    private double rho1;
    private double rho2;
    private double rho3;
    private double D1;
    private double D3;
    private double facFiniteDiff;
    private IodLambert lambert;

    public IodGooding(Frame frame, double mu) {
        this.mu = mu;
        this.frame = frame;
        this.rho1 = 0.0;
        this.rho2 = 0.0;
        this.rho3 = 0.0;
    }

    public double getRange1() {
        return this.rho1 * this.R;
    }

    public double getRange2() {
        return this.rho2 * this.R;
    }

    public double getRange3() {
        return this.rho3 * this.R;
    }

    public KeplerianOrbit estimate(Vector3D O1, Vector3D O2, Vector3D O3, Vector3D lineOfSight1, AbsoluteDate dateObs1, Vector3D lineOfSight2, AbsoluteDate dateObs2, Vector3D lineOfSight3, AbsoluteDate dateObs3, double rho1init, double rho3init, int nRev, boolean direction) {
        this.date1 = dateObs1;
        this.R = FastMath.max((double)rho1init, (double)rho3init);
        this.V = FastMath.sqrt((double)(this.mu / this.R));
        this.T = this.R / this.V;
        this.lambert = new IodLambert(1.0);
        this.vObserverPosition1 = O1.scalarMultiply(1.0 / this.R);
        this.vObserverPosition2 = O2.scalarMultiply(1.0 / this.R);
        this.vObserverPosition3 = O3.scalarMultiply(1.0 / this.R);
        int maxiter = 100;
        this.solveRangeProblem(rho1init / this.R, rho3init / this.R, dateObs3.durationFrom(dateObs1) / this.T, dateObs2.durationFrom(dateObs1) / this.T, nRev, direction, lineOfSight1, lineOfSight2, lineOfSight3, 100);
        IodGibbs gibbs = new IodGibbs(this.mu);
        Vector3D p1 = this.vObserverPosition1.add((Vector)lineOfSight1.scalarMultiply(this.rho1)).scalarMultiply(this.R);
        Vector3D p2 = this.vObserverPosition2.add((Vector)lineOfSight2.scalarMultiply(this.rho2)).scalarMultiply(this.R);
        Vector3D p3 = this.vObserverPosition3.add((Vector)lineOfSight3.scalarMultiply(this.rho3)).scalarMultiply(this.R);
        return gibbs.estimate(this.frame, p1, dateObs1, p2, dateObs2, p3, dateObs3);
    }

    public KeplerianOrbit estimate(Vector3D O1, Vector3D O2, Vector3D O3, Vector3D lineOfSight1, AbsoluteDate dateObs1, Vector3D lineOfSight2, AbsoluteDate dateObs2, Vector3D lineOfSight3, AbsoluteDate dateObs3, double rho1init, double rho3init) {
        return this.estimate(O1, O2, O3, lineOfSight1, dateObs1, lineOfSight2, dateObs2, lineOfSight3, dateObs3, rho1init, rho3init, 0, true);
    }

    private boolean solveRangeProblem(double rho1init, double rho3init, double T13, double T12, int nrev, boolean direction, Vector3D lineOfSight1, Vector3D lineOfSight2, Vector3D lineOfSight3, int maxIterations) {
        double ARBF = 1.0E-6;
        boolean withHalley = true;
        double cvtol = 1.0E-14;
        this.rho1 = rho1init;
        this.rho3 = rho3init;
        double stoppingCriterion = 1.0E-13;
        for (int iter = 0; iter < maxIterations && FastMath.abs((double)stoppingCriterion) > 1.0E-14; ++iter) {
            Vector3D P2;
            this.facFiniteDiff = 1.0E-6;
            if (iter >= maxIterations / 2) {
                withHalley = true;
            }
            if ((P2 = this.getPositionOnLoS2(lineOfSight1, this.rho1, lineOfSight3, this.rho3, T13, T12, nrev, direction)) == null) {
                this.modifyIterate(lineOfSight1, lineOfSight2, lineOfSight3);
                continue;
            }
            this.R2 = P2.getNorm();
            Vector3D C = P2.subtract((Vector)this.vObserverPosition2);
            this.rho2 = C.getNorm();
            double R10 = this.R1;
            double R30 = this.R3;
            double CR = lineOfSight2.dotProduct((Vector)C);
            Vector3D u = lineOfSight2.crossProduct((Vector)C);
            Vector3D P = u.crossProduct((Vector)lineOfSight2).normalize();
            Vector3D ENt = lineOfSight2.crossProduct((Vector)P);
            double ENR = ENt.getNorm();
            if (ENR == 0.0) {
                return true;
            }
            Vector3D EN = ENt.normalize();
            double Fc = P.dotProduct((Vector)C);
            double[] FD = new double[2];
            double[] GD = new double[2];
            this.computeDerivatives(this.rho1, this.rho3, R10, R30, lineOfSight1, lineOfSight3, P, EN, Fc, T13, T12, withHalley, nrev, direction, FD, GD);
            double fr1 = FD[0];
            double fr3 = FD[1];
            double gr1 = GD[0];
            double gr3 = GD[1];
            double detj = fr1 * gr3 - fr3 * gr1;
            this.D3 = -gr3 * Fc / detj;
            this.D1 = gr1 * Fc / detj;
            this.rho1 += this.D3;
            this.rho3 += this.D1;
            double den = FastMath.max((double)CR, (double)this.R2);
            stoppingCriterion = Fc / den;
        }
        return true;
    }

    private void modifyIterate(Vector3D lineOfSight1, Vector3D lineOfSight2, Vector3D lineOfSight3) {
        Vector3D R13 = this.vObserverPosition3.subtract((Vector)this.vObserverPosition1);
        this.D1 = R13.dotProduct((Vector)lineOfSight1);
        this.D3 = R13.dotProduct((Vector)lineOfSight3);
        double D2 = lineOfSight1.dotProduct((Vector)lineOfSight3);
        double D4 = 1.0 - D2 * D2;
        this.rho1 = FastMath.max((double)((this.D1 - this.D3 * D2) / D4), (double)0.0);
        this.rho3 = FastMath.max((double)((this.D1 * D2 - this.D3) / D4), (double)0.0);
    }

    private void computeDerivatives(double x, double y, double R10, double R30, Vector3D lineOfSight1, Vector3D lineOfSight3, Vector3D Pin, Vector3D Ein, double F, double T13, double T12, boolean withHalley, int nrev, boolean direction, double[] FD, double[] GD) {
        Vector3D P = Pin.normalize();
        Vector3D EN = Ein.normalize();
        double dx = this.facFiniteDiff * x;
        double dy = this.facFiniteDiff * y;
        Vector3D Cm1 = this.getPositionOnLoS2(lineOfSight1, x - dx, lineOfSight3, y, T13, T12, nrev, direction).subtract((Vector)this.vObserverPosition2);
        double Fm1 = P.dotProduct((Vector)Cm1);
        double Gm1 = EN.dotProduct((Vector)Cm1);
        Vector3D Cp1 = this.getPositionOnLoS2(lineOfSight1, x + dx, lineOfSight3, y, T13, T12, nrev, direction).subtract((Vector)this.vObserverPosition2);
        double Fp1 = P.dotProduct((Vector)Cp1);
        double Gp1 = EN.dotProduct((Vector)Cp1);
        double Fx = (Fp1 - Fm1) / (2.0 * dx);
        double Gx = (Gp1 - Gm1) / (2.0 * dx);
        Vector3D Cm3 = this.getPositionOnLoS2(lineOfSight1, x, lineOfSight3, y - dy, T13, T12, nrev, direction).subtract((Vector)this.vObserverPosition2);
        double Fm3 = P.dotProduct((Vector)Cm3);
        double Gm3 = EN.dotProduct((Vector)Cm3);
        Vector3D Cp3 = this.getPositionOnLoS2(lineOfSight1, x, lineOfSight3, y + dy, T13, T12, nrev, direction).subtract((Vector)this.vObserverPosition2);
        double Fp3 = P.dotProduct((Vector)Cp3);
        double Gp3 = EN.dotProduct((Vector)Cp3);
        double Fy = (Fp3 - Fm3) / (2.0 * dy);
        double Gy = (Gp3 - Gm3) / (2.0 * dy);
        double detJac = Fx * Gy - Fy * Gx;
        FD[0] = Fx;
        FD[1] = Fy;
        GD[0] = Gx;
        GD[1] = Gy;
        if (withHalley) {
            double hrho1Sq = dx * dx;
            double hrho3Sq = dy * dy;
            double Fxx = (Fp1 + Fm1 - 2.0 * F) / hrho1Sq;
            double Gxx = (Gp1 + Gm1 - 2.0 * F) / hrho1Sq;
            double Fyy = (Fp3 + Fp3 - 2.0 * F) / hrho3Sq;
            double Gyy = (Gm3 + Gm3 - 2.0 * F) / hrho3Sq;
            Vector3D Cp13 = this.getPositionOnLoS2(lineOfSight1, x + dx, lineOfSight3, y + dy, T13, T12, nrev, direction).subtract((Vector)this.vObserverPosition2);
            double Fp13 = P.dotProduct((Vector)Cp13);
            double Gp13 = EN.dotProduct((Vector)Cp13);
            Vector3D Cm13 = this.getPositionOnLoS2(lineOfSight1, x - dx, lineOfSight3, y - dy, T13, T12, nrev, direction).subtract((Vector)this.vObserverPosition2);
            double Fm13 = P.dotProduct((Vector)Cm13);
            double Gm13 = EN.dotProduct((Vector)Cm13);
            double Fxy = (Fp13 + Fm13) / (2.0 * dx * dy) - 0.5 * (Fxx * dx / dy + Fyy * dy / dx) - F / (dx * dy);
            double Gxy = (Gp13 + Gm13) / (2.0 * dx * dy) - 0.5 * (Gxx * dx / dy + Gyy * dy / dx) - F / (dx * dy);
            double dx3NR = -Gy * F / detJac;
            double dx1NR = Gx * F / detJac;
            double FxH = Fx + 0.5 * (Fxx * dx3NR + Fxy * dx1NR);
            double FyH = Fy + 0.5 * (Fxy * dx3NR + Fxx * dx1NR);
            double GxH = Gx + 0.5 * (Gxx * dx3NR + Gxy * dx1NR);
            double GyH = Gy + 0.5 * (Gxy * dx3NR + Gyy * dx1NR);
            FD[0] = FxH;
            FD[1] = FyH;
            GD[0] = GxH;
            GD[1] = GyH;
        }
    }

    private Vector3D getPositionOnLoS2(Vector3D E1, double RO1, Vector3D E3, double RO3, double T13, double T12, int nRev, boolean posigrade) {
        double[] V1;
        boolean exitflag;
        Vector3D P1 = this.vObserverPosition1.add((Vector)E1.scalarMultiply(RO1));
        this.R1 = P1.getNorm();
        Vector3D P3 = this.vObserverPosition3.add((Vector)E3.scalarMultiply(RO3));
        this.R3 = P3.getNorm();
        Vector3D P13 = P1.crossProduct((Vector)P3);
        double TH = FastMath.atan2((double)P13.getNorm(), (double)P1.dotProduct((Vector)P3));
        if (!posigrade) {
            TH = Math.PI * 2 - TH;
        }
        if (exitflag = this.lambert.solveLambertPb(this.R1, this.R3, TH, T13, nRev, V1 = new double[2])) {
            Vector3D Pn = P1.crossProduct((Vector)P3);
            Vector3D Pt = Pn.crossProduct((Vector)P1);
            double RT = Pt.getNorm();
            if (!posigrade) {
                RT = -RT;
            }
            Vector3D Vel1 = new Vector3D(V1[0] / this.R1, P1, V1[1] / RT, Pt);
            Vector3D P2 = this.propagatePV(P1, Vel1, T12);
            return P2;
        }
        return null;
    }

    private Vector3D propagatePV(Vector3D P1, Vector3D V1, double tau) {
        PVCoordinates pv1 = new PVCoordinates(P1, V1);
        KeplerianOrbit orbit = new KeplerianOrbit(pv1, this.frame, this.date1, 1.0);
        return orbit.shiftedBy(tau).getPVCoordinates().getPosition();
    }
}

