/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;

public class SpinStabilized
implements AttitudeProviderModifier {
    private final AttitudeProvider nonRotatingLaw;
    private final AbsoluteDate start;
    private final Vector3D axis;
    private final double rate;
    private final Vector3D spin;

    public SpinStabilized(AttitudeProvider nonRotatingLaw, AbsoluteDate start, Vector3D axis, double rate) {
        this.nonRotatingLaw = nonRotatingLaw;
        this.start = start;
        this.axis = axis;
        this.rate = rate;
        this.spin = new Vector3D(rate / axis.getNorm(), axis);
    }

    @Override
    public AttitudeProvider getUnderlyingAttitudeProvider() {
        return this.nonRotatingLaw;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Attitude base = this.nonRotatingLaw.getAttitude(pvProv, date, frame);
        Transform baseTransform = new Transform(date, base.getOrientation());
        Transform spinInfluence = new Transform(date, new Rotation(this.axis, this.rate * date.durationFrom(this.start), RotationConvention.FRAME_TRANSFORM), this.spin);
        Transform combined = new Transform(date, baseTransform, spinInfluence);
        return new Attitude(date, frame, combined.getRotation(), combined.getRotationRate(), combined.getRotationAcceleration());
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldAttitude<T> base = this.nonRotatingLaw.getAttitude(pvProv, date, frame);
        FieldTransform<T> baseTransform = new FieldTransform<T>(date, base.getOrientation());
        FieldTransform<T> spinInfluence = new FieldTransform<T>(date, new FieldRotation(new FieldVector3D(date.getField(), this.axis), (RealFieldElement)date.durationFrom(this.start).multiply(this.rate), RotationConvention.FRAME_TRANSFORM), new FieldVector3D(date.getField(), this.spin));
        FieldTransform<T> combined = new FieldTransform<T>(date, baseTransform, spinInfluence);
        return new FieldAttitude<T>(date, frame, combined.getRotation(), combined.getRotationRate(), combined.getRotationAcceleration());
    }
}

