/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SpacecraftToObservedBody
implements Serializable {
    private static final long serialVersionUID = 20140909L;
    private final Frame inertialFrame;
    private final Frame bodyFrame;
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;
    private final double tStep;
    private final double overshootTolerance;
    private final List<Transform> bodyToInertial;
    private final List<Transform> inertialToBody;
    private final List<Transform> scToInertial;

    public SpacecraftToObservedBody(Frame inertialFrame, Frame bodyFrame, AbsoluteDate minDate, AbsoluteDate maxDate, double tStep, double overshootTolerance, List<TimeStampedPVCoordinates> positionsVelocities, int pvInterpolationNumber, CartesianDerivativesFilter pvFilter, List<TimeStampedAngularCoordinates> quaternions, int aInterpolationNumber, AngularDerivativesFilter aFilter) {
        this.inertialFrame = inertialFrame;
        this.bodyFrame = bodyFrame;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.overshootTolerance = overshootTolerance;
        AbsoluteDate minPVDate = positionsVelocities.get(0).getDate();
        AbsoluteDate maxPVDate = positionsVelocities.get(positionsVelocities.size() - 1).getDate();
        if (minPVDate.durationFrom(minDate) > overshootTolerance) {
            throw new RuggedException(RuggedMessages.OUT_OF_TIME_RANGE, minDate, minPVDate, maxPVDate);
        }
        if (maxDate.durationFrom(maxPVDate) > overshootTolerance) {
            throw new RuggedException(RuggedMessages.OUT_OF_TIME_RANGE, maxDate, minPVDate, maxPVDate);
        }
        AbsoluteDate minQDate = quaternions.get(0).getDate();
        AbsoluteDate maxQDate = quaternions.get(quaternions.size() - 1).getDate();
        if (minQDate.durationFrom(minDate) > overshootTolerance) {
            throw new RuggedException(RuggedMessages.OUT_OF_TIME_RANGE, minDate, minQDate, maxQDate);
        }
        if (maxDate.durationFrom(maxQDate) > overshootTolerance) {
            throw new RuggedException(RuggedMessages.OUT_OF_TIME_RANGE, maxDate, minQDate, maxQDate);
        }
        ImmutableTimeStampedCache pvCache = new ImmutableTimeStampedCache(pvInterpolationNumber, positionsVelocities);
        ImmutableTimeStampedCache aCache = new ImmutableTimeStampedCache(aInterpolationNumber, quaternions);
        int n = (int)FastMath.ceil((double)(maxDate.durationFrom(minDate) / tStep));
        this.tStep = tStep;
        this.bodyToInertial = new ArrayList<Transform>(n);
        this.inertialToBody = new ArrayList<Transform>(n);
        this.scToInertial = new ArrayList<Transform>(n);
        AbsoluteDate date = minDate;
        while (this.bodyToInertial.size() < n) {
            AbsoluteDate pvInterpolationDate = date.compareTo(((TimeStampedPVCoordinates)pvCache.getEarliest()).getDate()) < 0 ? ((TimeStampedPVCoordinates)pvCache.getEarliest()).getDate() : (date.compareTo(((TimeStampedPVCoordinates)pvCache.getLatest()).getDate()) > 0 ? ((TimeStampedPVCoordinates)pvCache.getLatest()).getDate() : date);
            TimeStampedPVCoordinates interpolatedPV = TimeStampedPVCoordinates.interpolate((AbsoluteDate)pvInterpolationDate, (CartesianDerivativesFilter)pvFilter, (Stream)pvCache.getNeighbors(pvInterpolationDate));
            TimeStampedPVCoordinates pv = interpolatedPV.shiftedBy(date.durationFrom(pvInterpolationDate));
            AbsoluteDate aInterpolationDate = date.compareTo(((TimeStampedAngularCoordinates)aCache.getEarliest()).getDate()) < 0 ? ((TimeStampedAngularCoordinates)aCache.getEarliest()).getDate() : (date.compareTo(((TimeStampedAngularCoordinates)aCache.getLatest()).getDate()) > 0 ? ((TimeStampedAngularCoordinates)aCache.getLatest()).getDate() : date);
            TimeStampedAngularCoordinates interpolatedQuaternion = TimeStampedAngularCoordinates.interpolate((AbsoluteDate)aInterpolationDate, (AngularDerivativesFilter)aFilter, (Collection)aCache.getNeighbors(aInterpolationDate).collect(Collectors.toList()));
            TimeStampedAngularCoordinates quaternion = interpolatedQuaternion.shiftedBy(date.durationFrom(aInterpolationDate));
            this.scToInertial.add(new Transform(date, new Transform(date, (AngularCoordinates)quaternion.revert()), new Transform(date, (PVCoordinates)pv)));
            Transform b2i = bodyFrame.getTransformTo(inertialFrame, date);
            this.bodyToInertial.add(b2i);
            this.inertialToBody.add(b2i.getInverse());
            date = date.shiftedBy(tStep);
        }
    }

    public SpacecraftToObservedBody(Frame inertialFrame, Frame bodyFrame, AbsoluteDate minDate, AbsoluteDate maxDate, double tStep, double overshootTolerance, List<Transform> bodyToInertial, List<Transform> scToInertial) {
        this.inertialFrame = inertialFrame;
        this.bodyFrame = bodyFrame;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.tStep = tStep;
        this.overshootTolerance = overshootTolerance;
        this.bodyToInertial = bodyToInertial;
        this.scToInertial = scToInertial;
        this.inertialToBody = new ArrayList<Transform>(bodyToInertial.size());
        for (Transform b2i : bodyToInertial) {
            this.inertialToBody.add(b2i.getInverse());
        }
    }

    public Frame getInertialFrame() {
        return this.inertialFrame;
    }

    public Frame getBodyFrame() {
        return this.bodyFrame;
    }

    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    public double getTStep() {
        return this.tStep;
    }

    public double getOvershootTolerance() {
        return this.overshootTolerance;
    }

    public Transform getScToInertial(AbsoluteDate date) {
        return this.interpolate(date, this.scToInertial);
    }

    public Transform getInertialToBody(AbsoluteDate date) {
        return this.interpolate(date, this.inertialToBody);
    }

    public Transform getBodyToInertial(AbsoluteDate date) {
        return this.interpolate(date, this.bodyToInertial);
    }

    private Transform interpolate(AbsoluteDate date, List<Transform> list) {
        if (!this.isInRange(date)) {
            throw new RuggedException(RuggedMessages.OUT_OF_TIME_RANGE, date, this.minDate, this.maxDate);
        }
        double s = date.durationFrom(list.get(0).getDate()) / this.tStep;
        int index = FastMath.max((int)0, (int)FastMath.min((int)(list.size() - 1), (int)((int)FastMath.rint((double)s))));
        DumpManager.dumpTransform(this, index, this.bodyToInertial.get(index), this.scToInertial.get(index));
        Transform close = list.get(index);
        return close.shiftedBy(date.durationFrom(close.getDate()));
    }

    public boolean isInRange(AbsoluteDate date) {
        return this.minDate.durationFrom(date) <= this.overshootTolerance && date.durationFrom(this.maxDate) <= this.overshootTolerance;
    }
}

