/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.intersection;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.rugged.api.AlgorithmId;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.intersection.IntersectionAlgorithm;
import org.orekit.rugged.raster.SimpleTile;
import org.orekit.rugged.raster.SimpleTileFactory;
import org.orekit.rugged.raster.TileUpdater;
import org.orekit.rugged.raster.TilesCache;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.NormalizedGeodeticPoint;

public class BasicScanAlgorithm
implements IntersectionAlgorithm {
    private final TilesCache<SimpleTile> cache;
    private double hMin;
    private double hMax;
    private final AlgorithmId algorithmId;

    public BasicScanAlgorithm(TileUpdater updater, int maxCachedTiles) {
        this.cache = new TilesCache<SimpleTile>(new SimpleTileFactory(), updater, maxCachedTiles);
        this.hMin = Double.POSITIVE_INFINITY;
        this.hMax = Double.NEGATIVE_INFINITY;
        this.algorithmId = AlgorithmId.BASIC_SLOW_EXHAUSTIVE_SCAN_FOR_TESTS_ONLY;
    }

    @Override
    public NormalizedGeodeticPoint intersection(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los) {
        DumpManager.dumpAlgorithm(this.algorithmId);
        NormalizedGeodeticPoint entryPoint = null;
        NormalizedGeodeticPoint exitPoint = null;
        double minLatitude = Double.NaN;
        double maxLatitude = Double.NaN;
        double minLongitude = Double.NaN;
        double maxLongitude = Double.NaN;
        ArrayList<SimpleTile> scannedTiles = new ArrayList<SimpleTile>();
        double centralLongitude = Double.NaN;
        boolean changedMinMax = true;
        while (changedMinMax) {
            scannedTiles.clear();
            entryPoint = ellipsoid.transform(ellipsoid.pointAtAltitude(position, los, Double.isInfinite(this.hMax) ? 0.0 : this.hMax), ellipsoid.getBodyFrame(), null, Double.isNaN(centralLongitude) ? 0.0 : centralLongitude);
            SimpleTile entryTile = this.cache.getTile(entryPoint.getLatitude(), entryPoint.getLongitude());
            if (Double.isNaN(centralLongitude)) {
                centralLongitude = entryTile.getMinimumLongitude();
                entryPoint = new NormalizedGeodeticPoint(entryPoint.getLatitude(), entryPoint.getLongitude(), entryPoint.getAltitude(), centralLongitude);
            }
            this.addIfNotPresent(scannedTiles, entryTile);
            exitPoint = ellipsoid.transform(ellipsoid.pointAtAltitude(position, los, Double.isInfinite(this.hMin) ? 0.0 : this.hMin), ellipsoid.getBodyFrame(), null, centralLongitude);
            SimpleTile exitTile = this.cache.getTile(exitPoint.getLatitude(), exitPoint.getLongitude());
            this.addIfNotPresent(scannedTiles, exitTile);
            minLatitude = FastMath.min((double)entryPoint.getLatitude(), (double)exitPoint.getLatitude());
            maxLatitude = FastMath.max((double)entryPoint.getLatitude(), (double)exitPoint.getLatitude());
            minLongitude = FastMath.min((double)entryPoint.getLongitude(), (double)exitPoint.getLongitude());
            maxLongitude = FastMath.max((double)entryPoint.getLongitude(), (double)exitPoint.getLongitude());
            if (scannedTiles.size() > 1) {
                double latStep = 0.5 * FastMath.min((double)(entryTile.getLatitudeStep() * (double)entryTile.getLatitudeRows()), (double)(exitTile.getLatitudeStep() * (double)exitTile.getLatitudeRows()));
                double lonStep = 0.5 * FastMath.min((double)(entryTile.getLongitudeStep() * (double)entryTile.getLongitudeColumns()), (double)(exitTile.getLongitudeStep() * (double)exitTile.getLongitudeColumns()));
                for (double latitude = minLatitude; latitude <= maxLatitude; latitude += latStep) {
                    for (double longitude = minLongitude; longitude < maxLongitude; longitude += lonStep) {
                        this.addIfNotPresent(scannedTiles, this.cache.getTile(latitude, longitude));
                    }
                }
            }
            changedMinMax = this.checkMinMax(scannedTiles);
        }
        NormalizedGeodeticPoint intersectionGP = null;
        double intersectionDot = Double.POSITIVE_INFINITY;
        for (SimpleTile tile : scannedTiles) {
            for (int i = this.latitudeIndex(tile, minLatitude); i <= this.latitudeIndex(tile, maxLatitude); ++i) {
                for (int j = this.longitudeIndex(tile, minLongitude); j <= this.longitudeIndex(tile, maxLongitude); ++j) {
                    Vector3D point;
                    double dot;
                    Vector3D delta;
                    double s;
                    GeodeticPoint projected;
                    NormalizedGeodeticPoint normalizedProjected;
                    NormalizedGeodeticPoint gpImproved;
                    NormalizedGeodeticPoint gp = tile.cellIntersection(entryPoint, ellipsoid.convertLos(entryPoint, los), i, j);
                    if (gp == null || (gpImproved = tile.cellIntersection(normalizedProjected = new NormalizedGeodeticPoint((projected = ellipsoid.transform(new Vector3D(1.0, position, s = Vector3D.dotProduct((Vector3D)(delta = ellipsoid.transform(gp).subtract((Vector)position)), (Vector3D)los) / los.getNormSq(), los), ellipsoid.getBodyFrame(), null)).getLatitude(), projected.getLongitude(), projected.getAltitude(), gp.getLongitude()), ellipsoid.convertLos(normalizedProjected, los), i, j)) == null || !((dot = Vector3D.dotProduct((Vector3D)(point = ellipsoid.transform(gpImproved)).subtract((Vector)position), (Vector3D)los)) < intersectionDot)) continue;
                    intersectionGP = gpImproved;
                    intersectionDot = dot;
                }
            }
        }
        return intersectionGP;
    }

    @Override
    public NormalizedGeodeticPoint refineIntersection(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los, NormalizedGeodeticPoint closeGuess) {
        DumpManager.dumpAlgorithm(this.algorithmId);
        Vector3D delta = ellipsoid.transform(closeGuess).subtract((Vector)position);
        double s = Vector3D.dotProduct((Vector3D)delta, (Vector3D)los) / los.getNormSq();
        GeodeticPoint projected = ellipsoid.transform(new Vector3D(1.0, position, s, los), ellipsoid.getBodyFrame(), null);
        NormalizedGeodeticPoint normalizedProjected = new NormalizedGeodeticPoint(projected.getLatitude(), projected.getLongitude(), projected.getAltitude(), closeGuess.getLongitude());
        SimpleTile tile = this.cache.getTile(normalizedProjected.getLatitude(), normalizedProjected.getLongitude());
        return tile.cellIntersection(normalizedProjected, ellipsoid.convertLos(normalizedProjected, los), tile.getFloorLatitudeIndex(normalizedProjected.getLatitude()), tile.getFloorLongitudeIndex(normalizedProjected.getLongitude()));
    }

    @Override
    public double getElevation(double latitude, double longitude) {
        DumpManager.dumpAlgorithm(this.algorithmId);
        SimpleTile tile = this.cache.getTile(latitude, longitude);
        return tile.interpolateElevation(latitude, longitude);
    }

    @Override
    public AlgorithmId getAlgorithmId() {
        return this.algorithmId;
    }

    private boolean checkMinMax(List<SimpleTile> tiles) {
        boolean changedMinMax = false;
        for (SimpleTile tile : tiles) {
            if (tile.getMinElevation() < this.hMin) {
                this.hMin = tile.getMinElevation();
                changedMinMax = true;
            }
            if (!(tile.getMaxElevation() > this.hMax)) continue;
            this.hMax = tile.getMaxElevation();
            changedMinMax = true;
        }
        return changedMinMax;
    }

    private void addIfNotPresent(List<SimpleTile> list, SimpleTile tile) {
        for (SimpleTile existing : list) {
            if (existing != tile) continue;
            return;
        }
        list.add(tile);
    }

    private int latitudeIndex(SimpleTile tile, double latitude) {
        int rawIndex = tile.getFloorLatitudeIndex(latitude);
        return FastMath.min((int)FastMath.max((int)0, (int)rawIndex), (int)tile.getLatitudeRows());
    }

    private int longitudeIndex(SimpleTile tile, double longitude) {
        int rawIndex = tile.getFloorLongitudeIndex(longitude);
        return FastMath.min((int)FastMath.max((int)0, (int)rawIndex), (int)tile.getLongitudeColumns());
    }
}

