/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.optim.nonlinear.vector.leastsquares.ParameterValidator;
import org.orekit.rugged.adjustment.measurements.Observables;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.utils.DerivativeGenerator;
import org.orekit.utils.ParameterDriver;

abstract class OptimizationProblemBuilder {
    protected static final int ESTIMATION_LINE_RANGE_MARGIN = 100;
    private final DerivativeGenerator<Gradient> generator;
    private final List<ParameterDriver> drivers;
    private final int nbParams;
    private Observables measurements;
    private final List<LineSensor> sensors;

    OptimizationProblemBuilder(List<LineSensor> sensors, Observables measurements) {
        this.generator = this.createGenerator(sensors);
        this.drivers = this.generator.getSelected();
        this.nbParams = this.drivers.size();
        if (this.nbParams == 0) {
            throw new RuggedException(RuggedMessages.NO_PARAMETERS_SELECTED, new Object[0]);
        }
        this.measurements = measurements;
        this.sensors = sensors;
    }

    public abstract LeastSquaresProblem build(int var1, double var2);

    final ConvergenceChecker<LeastSquaresProblem.Evaluation> createChecker(double parametersConvergenceThreshold) {
        ConvergenceChecker checker = (iteration, previous, current) -> current.getPoint().getLInfDistance(previous.getPoint()) <= parametersConvergenceThreshold;
        return checker;
    }

    final double[] createStartTab() {
        double[] start = new double[this.nbParams];
        int iStart = 0;
        for (ParameterDriver driver : this.drivers) {
            start[iStart++] = driver.getNormalizedValue();
        }
        return start;
    }

    protected abstract void createTargetAndWeight();

    protected abstract MultivariateJacobianFunction createFunction();

    protected abstract void initMapping();

    final ParameterValidator createParameterValidator() {
        ParameterValidator validator = params -> {
            int i = 0;
            for (ParameterDriver driver : this.drivers) {
                driver.setNormalizedValue(params.getEntry(i));
                params.setEntry(i++, driver.getNormalizedValue());
            }
            return params;
        };
        return validator;
    }

    private DerivativeGenerator<Gradient> createGenerator(List<LineSensor> selectedSensors) {
        HashSet names = new HashSet();
        for (LineSensor sensor : selectedSensors) {
            sensor.getParametersDrivers().forEach(driver -> {
                if (!names.contains(driver.getName())) {
                    names.add(driver.getName());
                }
            });
        }
        final ArrayList selected = new ArrayList();
        final HashMap map = new HashMap();
        for (LineSensor sensor : selectedSensors) {
            sensor.getParametersDrivers().filter(driver -> driver.isSelected()).forEach(driver -> {
                if (map.get(driver.getName()) == null) {
                    map.put(driver.getName(), map.size());
                    selected.add(driver);
                }
            });
        }
        final GradientField field = GradientField.getField((int)map.size());
        return new DerivativeGenerator<Gradient>(){

            @Override
            public List<ParameterDriver> getSelected() {
                return selected;
            }

            @Override
            public Gradient constant(double value) {
                return Gradient.constant((int)map.size(), (double)value);
            }

            @Override
            public Gradient variable(ParameterDriver driver) {
                Integer index = (Integer)map.get(driver.getName());
                if (index == null) {
                    return this.constant(driver.getValue());
                }
                return Gradient.variable((int)map.size(), (int)index, (double)driver.getValue());
            }

            @Override
            public Field<Gradient> getField() {
                return field;
            }
        };
    }

    protected List<LineSensor> getSensors() {
        return this.sensors;
    }

    protected final int getNbParams() {
        return this.nbParams;
    }

    protected final List<ParameterDriver> getDrivers() {
        return this.drivers;
    }

    protected final DerivativeGenerator<Gradient> getGenerator() {
        return this.generator;
    }

    protected Observables getMeasurements() {
        return this.measurements;
    }
}

