/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment;

import org.hipparchus.linear.LUDecomposer;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.QRDecomposer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.GaussNewtonOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LevenbergMarquardtOptimizer;
import org.orekit.rugged.adjustment.OptimizerId;
import org.orekit.rugged.errors.RuggedInternalError;

public class LeastSquareAdjuster {
    private final LeastSquaresOptimizer adjuster;
    private final OptimizerId optimizerID;

    public LeastSquareAdjuster(OptimizerId optimizerID) {
        this.optimizerID = optimizerID;
        this.adjuster = this.selectOptimizer();
    }

    public LeastSquareAdjuster() {
        this.optimizerID = OptimizerId.GAUSS_NEWTON_QR;
        this.adjuster = this.selectOptimizer();
    }

    public LeastSquaresOptimizer.Optimum optimize(LeastSquaresProblem problem) {
        return this.adjuster.optimize(problem);
    }

    private LeastSquaresOptimizer selectOptimizer() {
        switch (this.optimizerID) {
            case LEVENBERG_MARQUADT: {
                return new LevenbergMarquardtOptimizer();
            }
            case GAUSS_NEWTON_LU: {
                return new GaussNewtonOptimizer((MatrixDecomposer)new LUDecomposer(1.0E-11), true);
            }
            case GAUSS_NEWTON_QR: {
                return new GaussNewtonOptimizer((MatrixDecomposer)new QRDecomposer(1.0E-11), false);
            }
        }
        throw new RuggedInternalError(null);
    }
}

