/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresBuilder;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.optim.nonlinear.vector.leastsquares.ParameterValidator;
import org.hipparchus.util.Pair;
import org.orekit.rugged.adjustment.OptimizationProblemBuilder;
import org.orekit.rugged.adjustment.measurements.Observables;
import org.orekit.rugged.adjustment.measurements.SensorToSensorMapping;
import org.orekit.rugged.api.Rugged;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.linesensor.SensorPixel;
import org.orekit.rugged.utils.SpacecraftToObservedBody;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class InterSensorsOptimizationProblemBuilder
extends OptimizationProblemBuilder {
    private static final String TARGET = "Target";
    private static final String WEIGHT = "Weight";
    private Map<String, Rugged> ruggedMap = new LinkedHashMap<String, Rugged>();
    private List<SensorToSensorMapping> sensorToSensorMappings;
    private HashMap<String, double[]> targetAndWeight;

    public InterSensorsOptimizationProblemBuilder(List<LineSensor> sensors, Observables measurements, Collection<Rugged> ruggedList) {
        super(sensors, measurements);
        for (Rugged rugged : ruggedList) {
            this.ruggedMap.put(rugged.getName(), rugged);
        }
        this.initMapping();
    }

    @Override
    protected void initMapping() {
        this.sensorToSensorMappings = new ArrayList<SensorToSensorMapping>();
        for (String ruggedNameA : this.ruggedMap.keySet()) {
            for (String ruggedNameB : this.ruggedMap.keySet()) {
                for (LineSensor sensorA : this.getSensors()) {
                    for (LineSensor sensorB : this.getSensors()) {
                        String sensorNameA = sensorA.getName();
                        String sensorNameB = sensorB.getName();
                        SensorToSensorMapping mapping = this.getMeasurements().getInterMapping(ruggedNameA, sensorNameA, ruggedNameB, sensorNameB);
                        if (mapping == null) continue;
                        this.sensorToSensorMappings.add(mapping);
                    }
                }
            }
        }
    }

    @Override
    protected void createTargetAndWeight() {
        int n = 0;
        for (SensorToSensorMapping reference : this.sensorToSensorMappings) {
            n += reference.getMapping().size();
        }
        if (n == 0) {
            throw new RuggedException(RuggedMessages.NO_REFERENCE_MAPPINGS, new Object[0]);
        }
        n = 2 * n;
        double[] target = new double[n];
        double[] weight = new double[n];
        int k = 0;
        for (SensorToSensorMapping reference : this.sensorToSensorMappings) {
            double bodyConstraintWeight = reference.getBodyConstraintWeight();
            Iterator<Map.Entry<SensorPixel, SensorPixel>> gtIt = reference.getMapping().iterator();
            for (int i = 0; gtIt.hasNext() && i != reference.getMapping().size(); ++i) {
                Double losDistance = reference.getLosDistance(i);
                weight[k] = 1.0 - bodyConstraintWeight;
                target[k++] = losDistance;
                Double bodyDistance = reference.getBodyDistance(i);
                weight[k] = bodyConstraintWeight;
                target[k++] = bodyDistance;
            }
        }
        this.targetAndWeight = new HashMap();
        this.targetAndWeight.put(TARGET, target);
        this.targetAndWeight.put(WEIGHT, weight);
    }

    @Override
    protected MultivariateJacobianFunction createFunction() {
        MultivariateJacobianFunction model = point -> {
            int i = 0;
            for (ParameterDriver driver : this.getDrivers()) {
                driver.setNormalizedValue(point.getEntry(i++));
            }
            double[] target = this.targetAndWeight.get(TARGET);
            ArrayRealVector value = new ArrayRealVector(target.length);
            Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(target.length, this.getNbParams());
            int l = 0;
            for (SensorToSensorMapping reference : this.sensorToSensorMappings) {
                String ruggedNameA = reference.getRuggedNameA();
                String ruggedNameB = reference.getRuggedNameB();
                Rugged ruggedA = this.ruggedMap.get(ruggedNameA);
                if (ruggedA == null) {
                    throw new RuggedException(RuggedMessages.INVALID_RUGGED_NAME, new Object[0]);
                }
                Rugged ruggedB = this.ruggedMap.get(ruggedNameB);
                if (ruggedB == null) {
                    throw new RuggedException(RuggedMessages.INVALID_RUGGED_NAME, new Object[0]);
                }
                for (Map.Entry<SensorPixel, SensorPixel> mapping : reference.getMapping()) {
                    SensorPixel spA = mapping.getKey();
                    SensorPixel spB = mapping.getValue();
                    LineSensor lineSensorB = ruggedB.getLineSensor(reference.getSensorNameB());
                    LineSensor lineSensorA = ruggedA.getLineSensor(reference.getSensorNameA());
                    AbsoluteDate dateA = lineSensorA.getDate(spA.getLineNumber());
                    AbsoluteDate dateB = lineSensorB.getDate(spB.getLineNumber());
                    double pixelA = spA.getPixelNumber();
                    double pixelB = spB.getPixelNumber();
                    SpacecraftToObservedBody scToBodyA = ruggedA.getScToBody();
                    Gradient[] ilResult = (Gradient[])ruggedB.distanceBetweenLOSderivatives(lineSensorA, dateA, pixelA, scToBodyA, lineSensorB, dateB, pixelB, this.getGenerator());
                    value.setEntry(l, ilResult[0].getValue());
                    value.setEntry(l + 1, ilResult[1].getValue());
                    int[] orders = new int[this.getNbParams()];
                    int m = 0;
                    for (ParameterDriver driver : this.getDrivers()) {
                        double scale = driver.getScale();
                        orders[m] = 1;
                        jacobian.setEntry(l, m, ilResult[0].getPartialDerivative(orders) * scale);
                        jacobian.setEntry(l + 1, m, ilResult[1].getPartialDerivative(orders) * scale);
                        orders[m] = 0;
                        ++m;
                    }
                    l += 2;
                }
            }
            return new Pair((Object)value, (Object)jacobian);
        };
        return model;
    }

    @Override
    public final LeastSquaresProblem build(int maxEvaluations, double convergenceThreshold) {
        this.createTargetAndWeight();
        double[] target = this.targetAndWeight.get(TARGET);
        double[] start = this.createStartTab();
        ParameterValidator validator = this.createParameterValidator();
        ConvergenceChecker<LeastSquaresProblem.Evaluation> checker = this.createChecker(convergenceThreshold);
        MultivariateJacobianFunction model = this.createFunction();
        return new LeastSquaresBuilder().lazyEvaluation(false).maxIterations(maxEvaluations).maxEvaluations(maxEvaluations).weight(null).start(start).target(target).parameterValidator(validator).checker(checker).model(model).build();
    }
}

