/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.special.Beta;
import org.hipparchus.special.Gamma;
import org.hipparchus.util.FastMath;

public class BetaDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20160320L;
    private final double alpha;
    private final double beta;
    private final double z;

    public BetaDistribution(double alpha, double beta) {
        this(alpha, beta, 1.0E-9);
    }

    public BetaDistribution(double alpha, double beta, double inverseCumAccuracy) {
        super(inverseCumAccuracy);
        this.alpha = alpha;
        this.beta = beta;
        this.z = Gamma.logGamma(alpha) + Gamma.logGamma(beta) - Gamma.logGamma(alpha + beta);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    public double density(double x) {
        double logDensity = this.logDensity(x);
        return logDensity == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(logDensity);
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0 || x > 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 0.0) {
            if (this.alpha < 1.0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.CANNOT_COMPUTE_BETA_DENSITY_AT_0_FOR_SOME_ALPHA, this.alpha, 1, false);
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 1.0) {
            if (this.beta < 1.0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.CANNOT_COMPUTE_BETA_DENSITY_AT_1_FOR_SOME_BETA, this.beta, 1, false);
            }
            return Double.NEGATIVE_INFINITY;
        }
        double logX = FastMath.log(x);
        double log1mX = FastMath.log1p(-x);
        return (this.alpha - 1.0) * logX + (this.beta - 1.0) * log1mX - this.z;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        return Beta.regularizedBeta(x, this.alpha, this.beta);
    }

    @Override
    public double getNumericalMean() {
        double a = this.getAlpha();
        return a / (a + this.getBeta());
    }

    @Override
    public double getNumericalVariance() {
        double a = this.getAlpha();
        double b = this.getBeta();
        double alphabetasum = a + b;
        return a * b / (alphabetasum * alphabetasum * (alphabetasum + 1.0));
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return 1.0;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

