/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.function;

import org.hipparchus.analysis.ParametricUnivariateFunction;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class Logistic
implements UnivariateDifferentiableFunction {
    private final double a;
    private final double k;
    private final double b;
    private final double oneOverN;
    private final double q;
    private final double m;

    public Logistic(double k, double m, double b, double q, double a, double n) throws MathIllegalArgumentException {
        if (n <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, n, 0);
        }
        this.k = k;
        this.m = m;
        this.b = b;
        this.q = q;
        this.a = a;
        this.oneOverN = 1.0 / n;
    }

    @Override
    public double value(double x) {
        return Logistic.value(this.m - x, this.k, this.b, this.q, this.a, this.oneOverN);
    }

    private static double value(double mMinusX, double k, double b, double q, double a, double oneOverN) {
        return a + (k - a) / FastMath.pow(1.0 + q * FastMath.exp(b * mMinusX), oneOverN);
    }

    @Override
    public DerivativeStructure value(DerivativeStructure t) {
        return t.negate().add(this.m).multiply(this.b).exp().multiply(this.q).add(1.0).pow(this.oneOverN).reciprocal().multiply(this.k - this.a).add(this.a);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        @Override
        public double value(double x, double ... param) throws MathIllegalArgumentException, NullArgumentException {
            this.validateParameters(param);
            return Logistic.value(param[1] - x, param[0], param[2], param[3], param[4], 1.0 / param[5]);
        }

        @Override
        public double[] gradient(double x, double ... param) throws MathIllegalArgumentException, NullArgumentException {
            this.validateParameters(param);
            double b = param[2];
            double q = param[3];
            double mMinusX = param[1] - x;
            double oneOverN = 1.0 / param[5];
            double exp = FastMath.exp(b * mMinusX);
            double qExp = q * exp;
            double qExp1 = qExp + 1.0;
            double factor1 = (param[0] - param[4]) * oneOverN / FastMath.pow(qExp1, oneOverN);
            double factor2 = -factor1 / qExp1;
            double gk = Logistic.value(mMinusX, 1.0, b, q, 0.0, oneOverN);
            double gm = factor2 * b * qExp;
            double gb = factor2 * mMinusX * qExp;
            double gq = factor2 * exp;
            double ga = Logistic.value(mMinusX, 0.0, b, q, 1.0, oneOverN);
            double gn = factor1 * FastMath.log(qExp1) * oneOverN;
            return new double[]{gk, gm, gb, gq, ga, gn};
        }

        private void validateParameters(double[] param) throws MathIllegalArgumentException, NullArgumentException {
            MathUtils.checkNotNull(param);
            MathUtils.checkDimension(param.length, 6);
            if (param[5] <= 0.0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, param[5], 0);
            }
        }
    }
}

