/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.util.FastMath;

public class GradientField
implements Field<Gradient> {
    private static AtomicReference<GradientField[]> fields = new AtomicReference<Object>(null);
    private final Gradient zero;
    private final Gradient one;
    private final DSFactory factory;

    private GradientField(int parameters) {
        this.zero = new Gradient(0.0, new double[parameters]);
        this.one = new Gradient(1.0, new double[parameters]);
        this.factory = new DSFactory(parameters, 1);
    }

    public static GradientField getField(int parameters) {
        GradientField[] cache = fields.get();
        if (cache != null && cache.length > parameters && cache[parameters] != null) {
            return cache[parameters];
        }
        int maxParameters = FastMath.max(parameters, cache == null ? 0 : cache.length);
        GradientField[] newCache = new GradientField[maxParameters + 1];
        if (cache != null) {
            System.arraycopy(cache, 0, newCache, 0, cache.length);
        }
        newCache[parameters] = new GradientField(parameters);
        fields.compareAndSet(cache, newCache);
        return newCache[parameters];
    }

    @Override
    public Gradient getOne() {
        return this.one;
    }

    @Override
    public Gradient getZero() {
        return this.zero;
    }

    @Override
    public Class<? extends FieldElement<Gradient>> getRuntimeClass() {
        return Gradient.class;
    }

    DSFactory getConversionFactory() {
        return this.factory;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return 650779376;
    }
}

