/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.propagation.analytical.tle.SDP4;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.time.DateTimeComponents;

public class DeepSDP4
extends SDP4 {
    private static final double ZNS = 1.19459E-5;
    private static final double ZES = 0.01675;
    private static final double ZNL = 1.5835218E-4;
    private static final double ZEL = 0.0549;
    private static final double THDT = 0.0043752691;
    private static final double C1SS = 2.9864797E-6;
    private static final double C1L = 4.7968065E-7;
    private static final double ROOT22 = 1.7891679E-6;
    private static final double ROOT32 = 3.7393792E-7;
    private static final double ROOT44 = 7.3636953E-9;
    private static final double ROOT52 = 1.1428639E-7;
    private static final double ROOT54 = 2.1765803E-9;
    private static final double Q22 = 1.7891679E-6;
    private static final double Q31 = 2.1460748E-6;
    private static final double Q33 = 2.2123015E-7;
    private static final double C_FASX2 = 0.9913913426848859;
    private static final double S_FASX2 = 0.130932065016401;
    private static final double C_2FASX4 = 0.8705163875297294;
    private static final double S_2FASX4 = -0.49213943048915526;
    private static final double C_3FASX6 = 0.43258117585763334;
    private static final double S_3FASX6 = 0.9015949901666642;
    private static final double C_G22 = 0.8705163875297294;
    private static final double S_G22 = -0.49213943048915526;
    private static final double C_G32 = 0.5797219018700115;
    private static final double S_G32 = 0.8148144061638924;
    private static final double C_G44 = -0.22866241528815548;
    private static final double S_G44 = 0.9735057780180799;
    private static final double C_G52 = 0.496848311798842;
    private static final double S_G52 = 0.8678374012812773;
    private static final double C_G54 = -0.29695209575316894;
    private static final double S_G54 = -0.9548923776153;
    private static final double SECULAR_INTEGRATION_STEP = 720.0;
    private double thgr;
    private double xnq;
    private double omegaq;
    private double zcosil;
    private double zsinil;
    private double zsinhl;
    private double zcoshl;
    private double zmol;
    private double zcosgl;
    private double zsingl;
    private double zmos;
    private double savtsn;
    private double ee2;
    private double e3;
    private double xi2;
    private double xi3;
    private double xl2;
    private double xl3;
    private double xl4;
    private double xgh2;
    private double xgh3;
    private double xgh4;
    private double xh2;
    private double xh3;
    private double d2201;
    private double d2211;
    private double d3210;
    private double d3222;
    private double d4410;
    private double d4422;
    private double d5220;
    private double d5232;
    private double d5421;
    private double d5433;
    private double xlamo;
    private double sse;
    private double ssi;
    private double ssl;
    private double ssh;
    private double ssg;
    private double se2;
    private double si2;
    private double sl2;
    private double sgh2;
    private double sh2;
    private double se3;
    private double si3;
    private double sl3;
    private double sgh3;
    private double sh3;
    private double sl4;
    private double sgh4;
    private double del1;
    private double del2;
    private double del3;
    private double xfact;
    private double xli;
    private double xni;
    private double atime;
    private double pe;
    private double pinc;
    private double pl;
    private double pgh;
    private double ph;
    private double[] derivs;
    private boolean resonant;
    private boolean synchronous;
    private boolean isDundeeCompliant = true;

    @DefaultDataContext
    public DeepSDP4(TLE initialTLE, AttitudeProvider attitudeProvider, double mass) {
        this(initialTLE, attitudeProvider, mass, DataContext.getDefault().getFrames().getTEME());
    }

    public DeepSDP4(TLE initialTLE, AttitudeProvider attitudeProvider, double mass, Frame teme) {
        super(initialTLE, attitudeProvider, mass, teme);
    }

    @Override
    protected void luniSolarTermsComputation() {
        SinCos scg = FastMath.sinCos((double)this.tle.getPerigeeArgument());
        double sing = scg.sin();
        double cosg = scg.cos();
        SinCos scq = FastMath.sinCos((double)this.tle.getRaan());
        double sinq = scq.sin();
        double cosq = scq.cos();
        double aqnv = 1.0 / this.a0dp;
        double daysSince1900 = this.tle.getDate().getComponents(this.utc).offsetFrom(DateTimeComponents.JULIAN_EPOCH) / 86400.0 - 2415020.0;
        double cc = 2.9864797E-6;
        double ze = 0.01675;
        double zn = 1.19459E-5;
        double zsinh = sinq;
        double zcosh = cosq;
        this.thgr = this.thetaG(this.tle.getDate());
        this.xnq = this.xn0dp;
        this.omegaq = this.tle.getPerigeeArgument();
        double xnodce = 4.523602 - 9.2422029E-4 * daysSince1900;
        SinCos scTem = FastMath.sinCos((double)xnodce);
        double stem = scTem.sin();
        double ctem = scTem.cos();
        double c_minus_gam = 0.228027132 * daysSince1900 - 1.1151842;
        double gam = 5.8351514 + 0.001944368 * daysSince1900;
        this.zcosil = 0.91375164 - 0.03568096 * ctem;
        this.zsinil = FastMath.sqrt((double)(1.0 - this.zcosil * this.zcosil));
        this.zsinhl = 0.089683511 * stem / this.zsinil;
        this.zcoshl = FastMath.sqrt((double)(1.0 - this.zsinhl * this.zsinhl));
        this.zmol = MathUtils.normalizeAngle((double)c_minus_gam, (double)Math.PI);
        double zx = 0.39785416 * stem / this.zsinil;
        double zy = this.zcoshl * ctem + 0.91744867 * this.zsinhl * stem;
        zx = FastMath.atan2((double)zx, (double)zy) + gam - xnodce;
        SinCos scZx = FastMath.sinCos((double)zx);
        this.zcosgl = scZx.cos();
        this.zsingl = scZx.sin();
        this.zmos = MathUtils.normalizeAngle((double)(6.2565837 + 0.017201977 * daysSince1900), (double)Math.PI);
        this.savtsn = 1.0E20;
        double zcosi = 0.91744867;
        double zsini = 0.39785416;
        double zsing = -0.98088458;
        double zcosg = 0.1945905;
        double se = 0.0;
        double sgh = 0.0;
        double sh = 0.0;
        double si = 0.0;
        double sl = 0.0;
        for (int iteration = 0; iteration < 2; ++iteration) {
            double a1 = zcosg * zcosh + zsing * zcosi * zsinh;
            double a3 = -zsing * zcosh + zcosg * zcosi * zsinh;
            double a7 = -zcosg * zsinh + zsing * zcosi * zcosh;
            double a8 = zsing * zsini;
            double a9 = zsing * zsinh + zcosg * zcosi * zcosh;
            double a10 = zcosg * zsini;
            double a2 = this.cosi0 * a7 + this.sini0 * a8;
            double a4 = this.cosi0 * a9 + this.sini0 * a10;
            double a5 = -this.sini0 * a7 + this.cosi0 * a8;
            double a6 = -this.sini0 * a9 + this.cosi0 * a10;
            double x1 = a1 * cosg + a2 * sing;
            double x2 = a3 * cosg + a4 * sing;
            double x3 = -a1 * sing + a2 * cosg;
            double x4 = -a3 * sing + a4 * cosg;
            double x5 = a5 * sing;
            double x6 = a6 * sing;
            double x7 = a5 * cosg;
            double x8 = a6 * cosg;
            double z31 = 12.0 * x1 * x1 - 3.0 * x3 * x3;
            double z32 = 24.0 * x1 * x2 - 6.0 * x3 * x4;
            double z33 = 12.0 * x2 * x2 - 3.0 * x4 * x4;
            double z11 = -6.0 * a1 * a5 + this.e0sq * (-24.0 * x1 * x7 - 6.0 * x3 * x5);
            double z12 = -6.0 * (a1 * a6 + a3 * a5) + this.e0sq * (-24.0 * (x2 * x7 + x1 * x8) - 6.0 * (x3 * x6 + x4 * x5));
            double z13 = -6.0 * a3 * a6 + this.e0sq * (-24.0 * x2 * x8 - 6.0 * x4 * x6);
            double z21 = 6.0 * a2 * a5 + this.e0sq * (24.0 * x1 * x5 - 6.0 * x3 * x7);
            double z22 = 6.0 * (a4 * a5 + a2 * a6) + this.e0sq * (24.0 * (x2 * x5 + x1 * x6) - 6.0 * (x4 * x7 + x3 * x8));
            double z23 = 6.0 * a4 * a6 + this.e0sq * (24.0 * x2 * x6 - 6.0 * x4 * x8);
            double s3 = cc / this.xnq;
            double s2 = -0.5 * s3 / this.beta0;
            double s4 = s3 * this.beta0;
            double s1 = -15.0 * this.tle.getE() * s4;
            double s5 = x1 * x3 + x2 * x4;
            double s6 = x2 * x3 + x1 * x4;
            double s7 = x2 * x4 - x1 * x3;
            double z1 = 3.0 * (a1 * a1 + a2 * a2) + z31 * this.e0sq;
            double z2 = 6.0 * (a1 * a3 + a2 * a4) + z32 * this.e0sq;
            double z3 = 3.0 * (a3 * a3 + a4 * a4) + z33 * this.e0sq;
            z1 = z1 + z1 + this.beta02 * z31;
            z2 = z2 + z2 + this.beta02 * z32;
            z3 = z3 + z3 + this.beta02 * z33;
            se = s1 * zn * s5;
            si = s2 * zn * (z11 + z13);
            sl = -zn * s3 * (z1 + z3 - 14.0 - 6.0 * this.e0sq);
            sgh = s4 * zn * (z31 + z33 - 6.0);
            sh = this.tle.getI() < 0.05235987755982988 ? 0.0 : -zn * s2 * (z21 + z23);
            this.ee2 = 2.0 * s1 * s6;
            this.e3 = 2.0 * s1 * s7;
            this.xi2 = 2.0 * s2 * z12;
            this.xi3 = 2.0 * s2 * (z13 - z11);
            this.xl2 = -2.0 * s3 * z2;
            this.xl3 = -2.0 * s3 * (z3 - z1);
            this.xl4 = -2.0 * s3 * (-21.0 - 9.0 * this.e0sq) * ze;
            this.xgh2 = 2.0 * s4 * z32;
            this.xgh3 = 2.0 * s4 * (z33 - z31);
            this.xgh4 = -18.0 * s4 * ze;
            this.xh2 = -2.0 * s2 * z22;
            this.xh3 = -2.0 * s2 * (z23 - z21);
            if (iteration != 0) continue;
            this.sse = se;
            this.ssi = si;
            this.ssl = sl;
            this.ssh = this.tle.getI() < 0.05235987755982988 ? 0.0 : sh / this.sini0;
            this.ssg = sgh - this.cosi0 * this.ssh;
            this.se2 = this.ee2;
            this.si2 = this.xi2;
            this.sl2 = this.xl2;
            this.sgh2 = this.xgh2;
            this.sh2 = this.xh2;
            this.se3 = this.e3;
            this.si3 = this.xi3;
            this.sl3 = this.xl3;
            this.sgh3 = this.xgh3;
            this.sh3 = this.xh3;
            this.sl4 = this.xl4;
            this.sgh4 = this.xgh4;
            zcosg = this.zcosgl;
            zsing = this.zsingl;
            zcosi = this.zcosil;
            zsini = this.zsinil;
            zcosh = this.zcoshl * cosq + this.zsinhl * sinq;
            zsinh = sinq * this.zcoshl - cosq * this.zsinhl;
            zn = 1.5835218E-4;
            cc = 4.7968065E-7;
            ze = 0.0549;
        }
        this.sse += se;
        this.ssi += si;
        this.ssl += sl;
        this.ssg += sgh - (this.tle.getI() < 0.05235987755982988 ? 0.0 : this.cosi0 / this.sini0 * sh);
        this.ssh += this.tle.getI() < 0.05235987755982988 ? 0.0 : sh / this.sini0;
        double bfact = 0.0;
        if (this.xnq >= 0.00826 && this.xnq <= 0.00924 && this.tle.getE() >= 0.5) {
            double g532;
            double g521;
            double g533;
            double g520;
            double g422;
            double g410;
            double g322;
            double g310;
            double g211;
            double g201 = -0.306 - (this.tle.getE() - 0.64) * 0.44;
            double eoc = this.tle.getE() * this.e0sq;
            double sini2 = this.sini0 * this.sini0;
            double f220 = 0.75 * (1.0 + 2.0 * this.cosi0 + this.theta2);
            double f221 = 1.5 * sini2;
            double f321 = 1.875 * this.sini0 * (1.0 - 2.0 * this.cosi0 - 3.0 * this.theta2);
            double f322 = -1.875 * this.sini0 * (1.0 + 2.0 * this.cosi0 - 3.0 * this.theta2);
            double f441 = 35.0 * sini2 * f220;
            double f442 = 39.375 * sini2 * sini2;
            double f522 = 9.84375 * this.sini0 * (sini2 * (1.0 - 2.0 * this.cosi0 - 5.0 * this.theta2) + 0.33333333 * (-2.0 + 4.0 * this.cosi0 + 6.0 * this.theta2));
            double f523 = this.sini0 * (4.92187512 * sini2 * (-2.0 - 4.0 * this.cosi0 + 10.0 * this.theta2) + 6.56250012 * (1.0 + 2.0 * this.cosi0 - 3.0 * this.theta2));
            double f542 = 29.53125 * this.sini0 * (2.0 - 8.0 * this.cosi0 + this.theta2 * (-12.0 + 8.0 * this.cosi0 + 10.0 * this.theta2));
            double f543 = 29.53125 * this.sini0 * (-2.0 - 8.0 * this.cosi0 + this.theta2 * (12.0 + 8.0 * this.cosi0 - 10.0 * this.theta2));
            this.resonant = true;
            this.synchronous = false;
            if (this.tle.getE() <= 0.65) {
                g211 = 3.616 - 13.247 * this.tle.getE() + 16.29 * this.e0sq;
                g310 = -19.302 + 117.39 * this.tle.getE() - 228.419 * this.e0sq + 156.591 * eoc;
                g322 = -18.9068 + 109.7927 * this.tle.getE() - 214.6334 * this.e0sq + 146.5816 * eoc;
                g410 = -41.122 + 242.694 * this.tle.getE() - 471.094 * this.e0sq + 313.953 * eoc;
                g422 = -146.407 + 841.88 * this.tle.getE() - 1629.014 * this.e0sq + 1083.435 * eoc;
                g520 = -532.114 + 3017.977 * this.tle.getE() - 5740.032 * this.e0sq + 3708.276 * eoc;
            } else {
                g211 = -72.099 + 331.819 * this.tle.getE() - 508.738 * this.e0sq + 266.724 * eoc;
                g310 = -346.844 + 1582.851 * this.tle.getE() - 2415.925 * this.e0sq + 1246.113 * eoc;
                g322 = -342.585 + 1554.908 * this.tle.getE() - 2366.899 * this.e0sq + 1215.972 * eoc;
                g410 = -1052.797 + 4758.686 * this.tle.getE() - 7193.992 * this.e0sq + 3651.957 * eoc;
                g422 = -3581.69 + 16178.11 * this.tle.getE() - 24462.77 * this.e0sq + 12422.52 * eoc;
                g520 = this.tle.getE() <= 0.715 ? 1464.74 - 4664.75 * this.tle.getE() + 3763.64 * this.e0sq : -5149.66 + 29936.92 * this.tle.getE() - 54087.36 * this.e0sq + 31324.56 * eoc;
            }
            if (this.tle.getE() < 0.7) {
                g533 = -919.2277 + 4988.61 * this.tle.getE() - 9064.77 * this.e0sq + 5542.21 * eoc;
                g521 = -822.71072 + 4568.6173 * this.tle.getE() - 8491.4146 * this.e0sq + 5337.524 * eoc;
                g532 = -853.666 + 4690.25 * this.tle.getE() - 8624.77 * this.e0sq + 5341.4 * eoc;
            } else {
                g533 = -37995.78 + 161616.52 * this.tle.getE() - 229838.2 * this.e0sq + 109377.94 * eoc;
                g521 = -51752.104 + 218913.95 * this.tle.getE() - 309468.16 * this.e0sq + 146349.42 * eoc;
                g532 = -40023.88 + 170470.89 * this.tle.getE() - 242699.48 * this.e0sq + 115605.82 * eoc;
            }
            double temp1 = 3.0 * this.xnq * this.xnq * aqnv * aqnv;
            double temp = temp1 * 1.7891679E-6;
            this.d2201 = temp * f220 * g201;
            this.d2211 = temp * f221 * g211;
            temp = (temp1 *= aqnv) * 3.7393792E-7;
            this.d3210 = temp * f321 * g310;
            this.d3222 = temp * f322 * g322;
            temp = 2.0 * (temp1 *= aqnv) * 7.3636953E-9;
            this.d4410 = temp * f441 * g410;
            this.d4422 = temp * f442 * g422;
            temp = (temp1 *= aqnv) * 1.1428639E-7;
            this.d5220 = temp * f522 * g520;
            this.d5232 = temp * f523 * g532;
            temp = 2.0 * temp1 * 2.1765803E-9;
            this.d5421 = temp * f542 * g521;
            this.d5433 = temp * f543 * g533;
            this.xlamo = this.tle.getMeanAnomaly() + this.tle.getRaan() + this.tle.getRaan() - this.thgr - this.thgr;
            bfact = this.xmdot + this.xnodot + this.xnodot - 0.0043752691 - 0.0043752691;
            bfact += this.ssl + this.ssh + this.ssh;
        } else if (this.xnq < 0.0052359877 && this.xnq > 0.0034906585) {
            double cosio_plus_1 = 1.0 + this.cosi0;
            double g200 = 1.0 + this.e0sq * (-2.5 + 0.8125 * this.e0sq);
            double g300 = 1.0 + this.e0sq * (-6.0 + 6.60937 * this.e0sq);
            double f311 = 0.9375 * this.sini0 * this.sini0 * (1.0 + 3.0 * this.cosi0) - 0.75 * cosio_plus_1;
            double g310 = 1.0 + 2.0 * this.e0sq;
            double f220 = 0.75 * cosio_plus_1 * cosio_plus_1;
            double f330 = 2.5 * f220 * cosio_plus_1;
            this.resonant = true;
            this.synchronous = true;
            this.del1 = 3.0 * this.xnq * this.xnq * aqnv * aqnv;
            this.del2 = 2.0 * this.del1 * f220 * g200 * 1.7891679E-6;
            this.del3 = 3.0 * this.del1 * f330 * g300 * 2.2123015E-7 * aqnv;
            this.del1 = this.del1 * f311 * g310 * 2.1460748E-6 * aqnv;
            this.xlamo = this.tle.getMeanAnomaly() + this.tle.getRaan() + this.tle.getPerigeeArgument() - this.thgr;
            bfact = this.xmdot + this.omgdot + this.xnodot - 0.0043752691;
            bfact = bfact + this.ssl + this.ssg + this.ssh;
        } else {
            this.resonant = false;
            this.synchronous = false;
        }
        if (this.resonant) {
            this.xfact = bfact - this.xnq;
            this.xli = this.xlamo;
            this.xni = this.xnq;
            this.atime = 0.0;
        }
        this.derivs = new double[2];
    }

    @Override
    protected void deepSecularEffects(double t) {
        this.xll += this.ssl * t;
        this.omgadf += this.ssg * t;
        this.xnode += this.ssh * t;
        this.em = this.tle.getE() + this.sse * t;
        this.xinc = this.tle.getI() + this.ssi * t;
        if (this.resonant) {
            if (FastMath.abs((double)t) < FastMath.abs((double)(t - this.atime)) || this.isDundeeCompliant) {
                this.atime = 0.0;
                this.xni = this.xnq;
                this.xli = this.xlamo;
            }
            boolean lastIntegrationStep = false;
            while (!lastIntegrationStep) {
                double delt = t - this.atime;
                if (delt > 720.0) {
                    delt = 720.0;
                } else if (delt < -720.0) {
                    delt = -720.0;
                } else {
                    lastIntegrationStep = true;
                }
                this.computeSecularDerivs();
                double xldot = this.xni + this.xfact;
                double xlpow = 1.0;
                this.xli += delt * xldot;
                this.xni += delt * this.derivs[0];
                double delt_factor = delt;
                this.derivs[1] = this.derivs[1] * (xlpow *= xldot);
                this.xli += (delt_factor *= delt / 2.0) * this.derivs[0];
                this.xni += delt_factor * this.derivs[1];
                this.atime += delt;
            }
            this.xn = this.xni;
            double temp = -this.xnode + this.thgr + t * 0.0043752691;
            this.xll = this.xli + temp + (this.synchronous ? -this.omgadf : temp);
        }
    }

    @Override
    protected void deepPeriodicEffects(double t) {
        if (FastMath.abs((double)(this.savtsn - t)) >= 30.0 || this.isDundeeCompliant) {
            this.savtsn = t;
            double zm = this.zmos + 1.19459E-5 * t;
            double zf = zm + 0.0335 * FastMath.sin((double)zm);
            SinCos sczf = FastMath.sinCos((double)zf);
            double sinzf = sczf.sin();
            double f2 = 0.5 * sinzf * sinzf - 0.25;
            double f3 = -0.5 * sinzf * sczf.cos();
            double ses = this.se2 * f2 + this.se3 * f3;
            double sis = this.si2 * f2 + this.si3 * f3;
            double sls = this.sl2 * f2 + this.sl3 * f3 + this.sl4 * sinzf;
            double sghs = this.sgh2 * f2 + this.sgh3 * f3 + this.sgh4 * sinzf;
            double shs = this.sh2 * f2 + this.sh3 * f3;
            zm = this.zmol + 1.5835218E-4 * t;
            zf = zm + 0.1098 * FastMath.sin((double)zm);
            sczf = FastMath.sinCos((double)zf);
            sinzf = sczf.sin();
            f2 = 0.5 * sinzf * sinzf - 0.25;
            f3 = -0.5 * sinzf * sczf.cos();
            double sel = this.ee2 * f2 + this.e3 * f3;
            double sil = this.xi2 * f2 + this.xi3 * f3;
            double sll = this.xl2 * f2 + this.xl3 * f3 + this.xl4 * sinzf;
            double sghl = this.xgh2 * f2 + this.xgh3 * f3 + this.xgh4 * sinzf;
            double sh1 = this.xh2 * f2 + this.xh3 * f3;
            this.pe = ses + sel;
            this.pinc = sis + sil;
            this.pl = sls + sll;
            this.pgh = sghs + sghl;
            this.ph = shs + sh1;
        }
        this.xinc += this.pinc;
        SinCos scis = FastMath.sinCos((double)this.xinc);
        double sinis = scis.sin();
        double cosis = scis.cos();
        this.em += this.pe;
        this.xll += this.pl;
        this.omgadf += this.pgh;
        this.xinc = MathUtils.normalizeAngle((double)this.xinc, (double)0.0);
        if (FastMath.abs((double)this.xinc) >= 0.2) {
            double temp_val = this.ph / sinis;
            this.omgadf -= cosis * temp_val;
            this.xnode += temp_val;
        } else {
            SinCos scok = FastMath.sinCos((double)this.xnode);
            double sinok = scok.sin();
            double cosok = scok.cos();
            double alfdp = this.ph * cosok + (this.pinc * cosis + sinis) * sinok;
            double betdp = -this.ph * sinok + (this.pinc * cosis + sinis) * cosok;
            double delta_xnode = MathUtils.normalizeAngle((double)(FastMath.atan2((double)alfdp, (double)betdp) - this.xnode), (double)0.0);
            double dls = -this.xnode * sinis * this.pinc;
            this.omgadf += dls - cosis * delta_xnode;
            this.xnode += delta_xnode;
        }
    }

    private void computeSecularDerivs() {
        SinCos sc_li = FastMath.sinCos((double)this.xli);
        double sin_li = sc_li.sin();
        double cos_li = sc_li.cos();
        double sin_2li = 2.0 * sin_li * cos_li;
        double cos_2li = 2.0 * cos_li * cos_li - 1.0;
        if (this.synchronous) {
            double sin_3li = sin_2li * cos_li + cos_2li * sin_li;
            double cos_3li = cos_2li * cos_li - sin_2li * sin_li;
            double term1a = this.del1 * (sin_li * 0.9913913426848859 - cos_li * 0.130932065016401);
            double term2a = this.del2 * (sin_2li * 0.8705163875297294 - cos_2li * -0.49213943048915526);
            double term3a = this.del3 * (sin_3li * 0.43258117585763334 - cos_3li * 0.9015949901666642);
            double term1b = this.del1 * (cos_li * 0.9913913426848859 + sin_li * 0.130932065016401);
            double term2b = 2.0 * this.del2 * (cos_2li * 0.8705163875297294 + sin_2li * -0.49213943048915526);
            double term3b = 3.0 * this.del3 * (cos_3li * 0.43258117585763334 + sin_3li * 0.9015949901666642);
            this.derivs[0] = term1a + term2a + term3a;
            this.derivs[1] = term1b + term2b + term3b;
        } else {
            double xomi = this.omegaq + this.omgdot * this.atime;
            SinCos sc_omi = FastMath.sinCos((double)xomi);
            double sin_omi = sc_omi.sin();
            double cos_omi = sc_omi.cos();
            double sin_li_m_omi = sin_li * cos_omi - sin_omi * cos_li;
            double sin_li_p_omi = sin_li * cos_omi + sin_omi * cos_li;
            double cos_li_m_omi = cos_li * cos_omi + sin_omi * sin_li;
            double cos_li_p_omi = cos_li * cos_omi - sin_omi * sin_li;
            double sin_2omi = 2.0 * sin_omi * cos_omi;
            double cos_2omi = 2.0 * cos_omi * cos_omi - 1.0;
            double sin_2li_m_omi = sin_2li * cos_omi - sin_omi * cos_2li;
            double sin_2li_p_omi = sin_2li * cos_omi + sin_omi * cos_2li;
            double cos_2li_m_omi = cos_2li * cos_omi + sin_omi * sin_2li;
            double cos_2li_p_omi = cos_2li * cos_omi - sin_omi * sin_2li;
            double sin_2li_p_2omi = sin_2li * cos_2omi + sin_2omi * cos_2li;
            double cos_2li_p_2omi = cos_2li * cos_2omi - sin_2omi * sin_2li;
            double sin_2omi_p_li = sin_li * cos_2omi + sin_2omi * cos_li;
            double cos_2omi_p_li = cos_li * cos_2omi - sin_2omi * sin_li;
            double term1a = this.d2201 * (sin_2omi_p_li * 0.8705163875297294 - cos_2omi_p_li * -0.49213943048915526) + this.d2211 * (sin_li * 0.8705163875297294 - cos_li * -0.49213943048915526) + this.d3210 * (sin_li_p_omi * 0.5797219018700115 - cos_li_p_omi * 0.8148144061638924) + this.d3222 * (sin_li_m_omi * 0.5797219018700115 - cos_li_m_omi * 0.8148144061638924) + this.d5220 * (sin_li_p_omi * 0.496848311798842 - cos_li_p_omi * 0.8678374012812773) + this.d5232 * (sin_li_m_omi * 0.496848311798842 - cos_li_m_omi * 0.8678374012812773);
            double term2a = this.d4410 * (sin_2li_p_2omi * -0.22866241528815548 - cos_2li_p_2omi * 0.9735057780180799) + this.d4422 * (sin_2li * -0.22866241528815548 - cos_2li * 0.9735057780180799) + this.d5421 * (sin_2li_p_omi * -0.29695209575316894 - cos_2li_p_omi * -0.9548923776153) + this.d5433 * (sin_2li_m_omi * -0.29695209575316894 - cos_2li_m_omi * -0.9548923776153);
            double term1b = this.d2201 * (cos_2omi_p_li * 0.8705163875297294 + sin_2omi_p_li * -0.49213943048915526) + this.d2211 * (cos_li * 0.8705163875297294 + sin_li * -0.49213943048915526) + this.d3210 * (cos_li_p_omi * 0.5797219018700115 + sin_li_p_omi * 0.8148144061638924) + this.d3222 * (cos_li_m_omi * 0.5797219018700115 + sin_li_m_omi * 0.8148144061638924) + this.d5220 * (cos_li_p_omi * 0.496848311798842 + sin_li_p_omi * 0.8678374012812773) + this.d5232 * (cos_li_m_omi * 0.496848311798842 + sin_li_m_omi * 0.8678374012812773);
            double term2b = 2.0 * (this.d4410 * (cos_2li_p_2omi * -0.22866241528815548 + sin_2li_p_2omi * 0.9735057780180799) + this.d4422 * (cos_2li * -0.22866241528815548 + sin_2li * 0.9735057780180799) + this.d5421 * (cos_2li_p_omi * -0.29695209575316894 + sin_2li_p_omi * -0.9548923776153) + this.d5433 * (cos_2li_m_omi * -0.29695209575316894 + sin_2li_m_omi * -0.9548923776153));
            this.derivs[0] = term1a + term2a;
            this.derivs[1] = term1b + term2b;
        }
    }
}

