/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.complex.Quaternion;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBodies;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ADMFile;
import org.orekit.files.ccsds.ADMMetaData;
import org.orekit.files.ccsds.APMFile;
import org.orekit.files.ccsds.CcsdsTimeScale;
import org.orekit.files.ccsds.CenterName;
import org.orekit.files.ccsds.KeyValue;
import org.orekit.files.ccsds.Keyword;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.IERSConventions;

public abstract class ADMParser {
    private static final Pattern INTERNATIONAL_DESIGNATOR = Pattern.compile("(\\p{Digit}{4})-(\\p{Digit}{3})(\\p{Upper}{1,3})");
    private final AbsoluteDate missionReferenceDate;
    private final double mu;
    private final IERSConventions conventions;
    private final boolean simpleEOP;
    private final DataContext dataContext;
    private int launchYear;
    private int launchNumber;
    private String launchPiece;

    protected ADMParser(AbsoluteDate missionReferenceDate, double mu, IERSConventions conventions, boolean simpleEOP, int launchYear, int launchNumber, String launchPiece, DataContext dataContext) {
        this.missionReferenceDate = missionReferenceDate;
        this.mu = mu;
        this.conventions = conventions;
        this.simpleEOP = simpleEOP;
        this.launchYear = launchYear;
        this.launchNumber = launchNumber;
        this.launchPiece = launchPiece;
        this.dataContext = dataContext;
    }

    public abstract ADMParser withMissionReferenceDate(AbsoluteDate var1);

    public AbsoluteDate getMissionReferenceDate() {
        return this.missionReferenceDate;
    }

    public abstract ADMParser withMu(double var1);

    public double getMu() {
        return this.mu;
    }

    public abstract ADMParser withConventions(IERSConventions var1);

    public IERSConventions getConventions() {
        return this.conventions;
    }

    public abstract ADMParser withSimpleEOP(boolean var1);

    public boolean isSimpleEOP() {
        return this.simpleEOP;
    }

    public abstract ADMParser withInternationalDesignator(int var1, int var2, String var3);

    public int getLaunchYear() {
        return this.launchYear;
    }

    public int getLaunchNumber() {
        return this.launchNumber;
    }

    public String getLaunchPiece() {
        return this.launchPiece;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public abstract ADMParser withDataContext(DataContext var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ADMFile parse(String fileName) {
        try (FileInputStream stream = new FileInputStream(fileName);){
            ADMFile aDMFile = this.parse(stream, fileName);
            return aDMFile;
        }
        catch (IOException e) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, fileName);
        }
    }

    public ADMFile parse(InputStream stream) {
        return this.parse(stream, "<unknown>");
    }

    public abstract ADMFile parse(InputStream var1, String var2);

    protected boolean parseComment(KeyValue keyValue, List<String> comment) {
        if (keyValue.getKeyword() == Keyword.COMMENT) {
            comment.add(keyValue.getValue());
            return true;
        }
        return false;
    }

    protected boolean parseHeaderEntry(KeyValue keyValue, ADMFile admFile, List<String> comment) {
        switch (keyValue.getKeyword()) {
            case CREATION_DATE: {
                if (!comment.isEmpty()) {
                    admFile.setHeaderComment(comment);
                    comment.clear();
                }
                admFile.setCreationDate(new AbsoluteDate(keyValue.getValue(), (TimeScale)this.dataContext.getTimeScales().getUTC()));
                return true;
            }
            case ORIGINATOR: {
                admFile.setOriginator(keyValue.getValue());
                return true;
            }
        }
        return false;
    }

    protected boolean parseMetaDataEntry(KeyValue keyValue, ADMMetaData metaData, List<String> comment) {
        switch (keyValue.getKeyword()) {
            case OBJECT_NAME: {
                if (!comment.isEmpty()) {
                    metaData.setComment(comment);
                    comment.clear();
                }
                metaData.setObjectName(keyValue.getValue());
                return true;
            }
            case OBJECT_ID: {
                metaData.setObjectID(keyValue.getValue());
                Matcher matcher = INTERNATIONAL_DESIGNATOR.matcher(keyValue.getValue());
                if (matcher.matches()) {
                    metaData.setLaunchYear(Integer.parseInt(matcher.group(1)));
                    metaData.setLaunchNumber(Integer.parseInt(matcher.group(2)));
                    metaData.setLaunchPiece(matcher.group(3));
                }
                return true;
            }
            case CENTER_NAME: {
                metaData.setCenterName(keyValue.getValue());
                String canonicalValue = keyValue.getValue().equals("SOLAR SYSTEM BARYCENTER") || keyValue.getValue().equals("SSB") ? "SOLAR_SYSTEM_BARYCENTER" : (keyValue.getValue().equals("EARTH MOON BARYCENTER") || keyValue.getValue().equals("EARTH-MOON BARYCENTER") || keyValue.getValue().equals("EARTH BARYCENTER") || keyValue.getValue().equals("EMB") ? "EARTH_MOON" : keyValue.getValue());
                for (CenterName c : CenterName.values()) {
                    if (!c.name().equals(canonicalValue)) continue;
                    metaData.setHasCreatableBody(true);
                    CelestialBodies celestialBodies = this.getDataContext().getCelestialBodies();
                    metaData.setCenterBody(c.getCelestialBody(celestialBodies));
                    metaData.getADMFile().setMu(c.getCelestialBody(celestialBodies).getGM());
                }
                return true;
            }
            case TIME_SYSTEM: {
                if (!CcsdsTimeScale.contains(keyValue.getValue())) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_TIME_SYSTEM_NOT_IMPLEMENTED, keyValue.getValue());
                }
                CcsdsTimeScale timeSystem = CcsdsTimeScale.valueOf(keyValue.getValue());
                metaData.setTimeSystem(timeSystem);
                return true;
            }
        }
        return false;
    }

    protected boolean parseGeneralStateDataEntry(KeyValue keyValue, APMFile general, List<String> comment) {
        switch (keyValue.getKeyword()) {
            case EPOCH: {
                general.setEpochComment(comment);
                comment.clear();
                general.setEpoch(this.parseDate(keyValue.getValue(), general.getMetaData().getTimeSystem()));
                return true;
            }
            case QC_DOT: {
                general.setQuaternionDot(new Quaternion(keyValue.getDoubleValue(), general.getQuaternionDot().getQ1(), general.getQuaternionDot().getQ2(), general.getQuaternionDot().getQ3()));
                return true;
            }
            case Q1_DOT: {
                general.setQuaternionDot(new Quaternion(general.getQuaternionDot().getQ0(), keyValue.getDoubleValue(), general.getQuaternionDot().getQ2(), general.getQuaternionDot().getQ3()));
                return true;
            }
            case Q2_DOT: {
                general.setQuaternionDot(new Quaternion(general.getQuaternionDot().getQ0(), general.getQuaternionDot().getQ1(), keyValue.getDoubleValue(), general.getQuaternionDot().getQ3()));
                return true;
            }
            case Q3_DOT: {
                general.setQuaternionDot(new Quaternion(general.getQuaternionDot().getQ0(), general.getQuaternionDot().getQ1(), general.getQuaternionDot().getQ2(), keyValue.getDoubleValue()));
                return true;
            }
            case EULER_FRAME_A: {
                general.setEulerComment(comment);
                comment.clear();
                general.setEulerFrameAString(keyValue.getValue());
                return true;
            }
            case EULER_FRAME_B: {
                general.setEulerFrameBString(keyValue.getValue());
                return true;
            }
            case EULER_DIR: {
                general.setEulerDirection(keyValue.getValue());
                return true;
            }
            case EULER_ROT_SEQ: {
                general.setEulerRotSeq(keyValue.getValue());
                return true;
            }
            case RATE_FRAME: {
                general.setRateFrameString(keyValue.getValue());
                return true;
            }
            case X_ANGLE: {
                general.setRotationAngles(new Vector3D(this.toRadians(keyValue), general.getRotationAngles().getY(), general.getRotationAngles().getZ()));
                return true;
            }
            case Y_ANGLE: {
                general.setRotationAngles(new Vector3D(general.getRotationAngles().getX(), this.toRadians(keyValue), general.getRotationAngles().getZ()));
                return true;
            }
            case Z_ANGLE: {
                general.setRotationAngles(new Vector3D(general.getRotationAngles().getX(), general.getRotationAngles().getY(), this.toRadians(keyValue)));
                return true;
            }
            case X_RATE: {
                general.setRotationRates(new Vector3D(this.toRadians(keyValue), general.getRotationRates().getY(), general.getRotationRates().getZ()));
                return true;
            }
            case Y_RATE: {
                general.setRotationRates(new Vector3D(general.getRotationRates().getX(), this.toRadians(keyValue), general.getRotationRates().getZ()));
                return true;
            }
            case Z_RATE: {
                general.setRotationRates(new Vector3D(general.getRotationRates().getX(), general.getRotationRates().getY(), this.toRadians(keyValue)));
                return true;
            }
            case SPIN_FRAME_A: {
                general.setSpinComment(comment);
                comment.clear();
                general.setSpinFrameAString(keyValue.getValue());
                return true;
            }
            case SPIN_FRAME_B: {
                general.setSpinFrameBString(keyValue.getValue());
                return true;
            }
            case SPIN_DIR: {
                general.setSpinDirection(keyValue.getValue());
                return true;
            }
            case SPIN_ALPHA: {
                general.setSpinAlpha(this.toRadians(keyValue));
                return true;
            }
            case SPIN_DELTA: {
                general.setSpinDelta(this.toRadians(keyValue));
                return true;
            }
            case SPIN_ANGLE: {
                general.setSpinAngle(this.toRadians(keyValue));
                return true;
            }
            case SPIN_ANGLE_VEL: {
                general.setSpinAngleVel(this.toRadians(keyValue));
                return true;
            }
            case NUTATION: {
                general.setNutation(this.toRadians(keyValue));
                return true;
            }
            case NUTATION_PER: {
                general.setNutationPeriod(keyValue.getDoubleValue());
                return true;
            }
            case NUTATION_PHASE: {
                general.setNutationPhase(this.toRadians(keyValue));
                return true;
            }
            case INERTIA_REF_FRAME: {
                general.setSpacecraftComment(comment);
                comment.clear();
                general.setInertiaRefFrameString(keyValue.getValue());
                return true;
            }
            case I11: {
                general.setI11(keyValue.getDoubleValue());
                return true;
            }
            case I22: {
                general.setI22(keyValue.getDoubleValue());
                return true;
            }
            case I33: {
                general.setI33(keyValue.getDoubleValue());
                return true;
            }
            case I12: {
                general.setI12(keyValue.getDoubleValue());
                return true;
            }
            case I13: {
                general.setI13(keyValue.getDoubleValue());
                return true;
            }
            case I23: {
                general.setI23(keyValue.getDoubleValue());
                return true;
            }
        }
        return false;
    }

    protected AbsoluteDate parseDate(String date, CcsdsTimeScale timeSystem) {
        return timeSystem.parseDate(date, this.conventions, this.missionReferenceDate, this.getDataContext().getTimeScales());
    }

    protected double toRadians(KeyValue keyValue) {
        return FastMath.toRadians((double)keyValue.getDoubleValue());
    }
}

