/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CR3BPSystem;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.propagation.numerical.cr3bp.CR3BPConstants;

public class CR3BPFactory {
    private CR3BPFactory() {
    }

    @DefaultDataContext
    public static CR3BPSystem getSunJupiterCR3BP() {
        return CR3BPFactory.getSystem(CelestialBodyFactory.getSun(), CelestialBodyFactory.getJupiter(), CR3BPConstants.JUPITER_SEMI_MAJOR_AXIS);
    }

    @DefaultDataContext
    public static CR3BPSystem getSunEarthCR3BP() {
        return CR3BPFactory.getSystem(CelestialBodyFactory.getSun(), CelestialBodyFactory.getEarthMoonBarycenter(), CR3BPConstants.EARTH_MOON_BARYCENTER_SEMI_MAJOR_AXIS);
    }

    @DefaultDataContext
    public static CR3BPSystem getEarthMoonCR3BP() {
        return CR3BPFactory.getSystem(CelestialBodyFactory.getEarth(), CelestialBodyFactory.getMoon(), 3.844E8);
    }

    public static CR3BPSystem getSystem(CelestialBody primaryBody, CelestialBody secondaryBody, double a) {
        return new CR3BPSystem(primaryBody, secondaryBody, a);
    }
}

