/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.fraction;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.fraction.Fraction;
import org.hipparchus.fraction.FractionFormat;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class ProperFractionFormat
extends FractionFormat {
    private static final long serialVersionUID = 20160323L;
    private final NumberFormat wholeFormat;

    public ProperFractionFormat() {
        this(ProperFractionFormat.getDefaultNumberFormat());
    }

    public ProperFractionFormat(NumberFormat format) {
        this(format, (NumberFormat)format.clone(), (NumberFormat)format.clone());
    }

    public ProperFractionFormat(NumberFormat wholeFormat, NumberFormat numeratorFormat, NumberFormat denominatorFormat) {
        super(numeratorFormat, denominatorFormat);
        MathUtils.checkNotNull(wholeFormat, LocalizedCoreFormats.WHOLE_FORMAT, new Object[0]);
        this.wholeFormat = wholeFormat;
    }

    @Override
    public StringBuffer format(Fraction fraction, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        int num = fraction.getNumerator();
        int den = fraction.getDenominator();
        int whole = num / den;
        num %= den;
        if (whole != 0) {
            this.getWholeFormat().format(whole, toAppendTo, pos);
            toAppendTo.append(' ');
            num = FastMath.abs(num);
        }
        this.getNumeratorFormat().format(num, toAppendTo, pos);
        toAppendTo.append(" / ");
        this.getDenominatorFormat().format(den, toAppendTo, pos);
        return toAppendTo;
    }

    public NumberFormat getWholeFormat() {
        return this.wholeFormat;
    }

    @Override
    public Fraction parse(String source, ParsePosition pos) {
        Fraction ret = super.parse(source, pos);
        if (ret != null) {
            return ret;
        }
        int initialIndex = pos.getIndex();
        ProperFractionFormat.parseAndIgnoreWhitespace(source, pos);
        Number whole = this.getWholeFormat().parse(source, pos);
        if (whole == null) {
            pos.setIndex(initialIndex);
            return null;
        }
        ProperFractionFormat.parseAndIgnoreWhitespace(source, pos);
        Number num = this.getNumeratorFormat().parse(source, pos);
        if (num == null) {
            pos.setIndex(initialIndex);
            return null;
        }
        if (num.intValue() < 0) {
            pos.setIndex(initialIndex);
            return null;
        }
        int startIndex = pos.getIndex();
        char c = ProperFractionFormat.parseNextCharacter(source, pos);
        switch (c) {
            case '\u0000': {
                return new Fraction(num.intValue(), 1);
            }
            case '/': {
                break;
            }
            default: {
                pos.setIndex(initialIndex);
                pos.setErrorIndex(startIndex);
                return null;
            }
        }
        ProperFractionFormat.parseAndIgnoreWhitespace(source, pos);
        Number den = this.getDenominatorFormat().parse(source, pos);
        if (den == null) {
            pos.setIndex(initialIndex);
            return null;
        }
        if (den.intValue() < 0) {
            pos.setIndex(initialIndex);
            return null;
        }
        int w = whole.intValue();
        int n = num.intValue();
        int d = den.intValue();
        return new Fraction((FastMath.abs(w) * d + n) * MathUtils.copySign(1, w), d);
    }
}

