/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1Field;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldUnivariateDerivative1<T extends RealFieldElement<T>>
extends FieldUnivariateDerivative<T, FieldUnivariateDerivative1<T>> {
    private final T f0;
    private final T f1;

    public FieldUnivariateDerivative1(T f0, T f1) {
        this.f0 = f0;
        this.f1 = f1;
    }

    public FieldUnivariateDerivative1(FieldDerivativeStructure<T> ds) throws MathIllegalArgumentException {
        MathUtils.checkDimension(ds.getFreeParameters(), 1);
        MathUtils.checkDimension(ds.getOrder(), 1);
        this.f0 = ds.getValue();
        this.f1 = ds.getPartialDerivative(1);
    }

    @Override
    public FieldUnivariateDerivative1<T> newInstance(double value) {
        RealFieldElement zero = (RealFieldElement)this.f0.getField().getZero();
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)zero.newInstance(value), zero);
    }

    @Override
    public double getReal() {
        return this.getValue().getReal();
    }

    @Override
    public T getValue() {
        return this.f0;
    }

    @Override
    public T getDerivative(int n) {
        switch (n) {
            case 0: {
                return this.f0;
            }
            case 1: {
                return this.f1;
            }
        }
        throw new MathIllegalArgumentException(LocalizedCoreFormats.DERIVATION_ORDER_NOT_ALLOWED, n);
    }

    @Override
    public int getOrder() {
        return 1;
    }

    public T getFirstDerivative() {
        return this.f1;
    }

    public Field<T> getValueField() {
        return this.f0.getField();
    }

    @Override
    public FieldDerivativeStructure<T> toDerivativeStructure() {
        return ((FieldUnivariateDerivative1Field)this.getField()).getConversionFactory().build(new RealFieldElement[]{this.f0, this.f1});
    }

    @Override
    public FieldUnivariateDerivative1<T> add(T a) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.add(a), (RealFieldElement)this.f1);
    }

    @Override
    public FieldUnivariateDerivative1<T> add(double a) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.add(a), (RealFieldElement)this.f1);
    }

    @Override
    public FieldUnivariateDerivative1<T> add(FieldUnivariateDerivative1<T> a) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.add(a.f0), (RealFieldElement)this.f1.add(a.f1));
    }

    @Override
    public FieldUnivariateDerivative1<T> subtract(T a) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.subtract(a), (RealFieldElement)this.f1);
    }

    @Override
    public FieldUnivariateDerivative1<T> subtract(double a) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.subtract(a), (RealFieldElement)this.f1);
    }

    @Override
    public FieldUnivariateDerivative1<T> subtract(FieldUnivariateDerivative1<T> a) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.subtract(a.f0), (RealFieldElement)this.f1.subtract(a.f1));
    }

    @Override
    public FieldUnivariateDerivative1<T> multiply(T a) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.multiply(a), (RealFieldElement)this.f1.multiply(a));
    }

    @Override
    public FieldUnivariateDerivative1<T> multiply(int n) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.multiply((int)n), (RealFieldElement)this.f1.multiply((int)n));
    }

    @Override
    public FieldUnivariateDerivative1<T> multiply(double a) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.multiply(a), (RealFieldElement)this.f1.multiply(a));
    }

    @Override
    public FieldUnivariateDerivative1<T> multiply(FieldUnivariateDerivative1<T> a) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.multiply(a.f0), (RealFieldElement)a.f0.linearCombination(this.f1, a.f0, this.f0, a.f1));
    }

    @Override
    public FieldUnivariateDerivative1<T> divide(T a) {
        RealFieldElement inv1 = (RealFieldElement)a.reciprocal();
        return new FieldUnivariateDerivative1<RealFieldElement>(this.f0.multiply((RealFieldElement)inv1), this.f1.multiply((RealFieldElement)inv1));
    }

    @Override
    public FieldUnivariateDerivative1<T> divide(double a) {
        double inv1 = 1.0 / a;
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.multiply(inv1), (RealFieldElement)this.f1.multiply(inv1));
    }

    @Override
    public FieldUnivariateDerivative1<T> divide(FieldUnivariateDerivative1<T> a) {
        RealFieldElement inv1 = (RealFieldElement)a.f0.reciprocal();
        RealFieldElement inv2 = inv1.multiply(inv1);
        return new FieldUnivariateDerivative1<RealFieldElement>(this.f0.multiply((RealFieldElement)inv1), ((RealFieldElement)a.f0.linearCombination(this.f1, a.f0, this.f0.negate(), a.f1)).multiply(inv2));
    }

    @Override
    public FieldUnivariateDerivative1<T> remainder(T a) {
        return new FieldUnivariateDerivative1<T>(FastMath.IEEEremainder(this.f0, a), this.f1);
    }

    @Override
    public FieldUnivariateDerivative1<T> remainder(double a) {
        return new FieldUnivariateDerivative1<double>(FastMath.IEEEremainder(this.f0, a), (double)this.f1);
    }

    @Override
    public FieldUnivariateDerivative1<T> remainder(FieldUnivariateDerivative1<T> a) {
        T rem = FastMath.IEEEremainder(this.f0, a.f0);
        RealFieldElement k = FastMath.rint((RealFieldElement)((RealFieldElement)this.f0.subtract(rem)).divide(a.f0));
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)rem, (RealFieldElement)this.f1.subtract(k.multiply(a.f1)));
    }

    @Override
    public FieldUnivariateDerivative1<T> negate() {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.negate(), (RealFieldElement)this.f1.negate());
    }

    @Override
    public FieldUnivariateDerivative1<T> abs() {
        if (Double.doubleToLongBits(this.f0.getReal()) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public FieldUnivariateDerivative1<T> ceil() {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)FastMath.ceil(this.f0), (RealFieldElement)this.f0.getField().getZero());
    }

    @Override
    public FieldUnivariateDerivative1<T> floor() {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)FastMath.floor(this.f0), (RealFieldElement)this.f0.getField().getZero());
    }

    @Override
    public FieldUnivariateDerivative1<T> rint() {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)FastMath.rint(this.f0), (RealFieldElement)this.f0.getField().getZero());
    }

    @Override
    public FieldUnivariateDerivative1<T> signum() {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)FastMath.signum(this.f0), (RealFieldElement)this.f0.getField().getZero());
    }

    @Override
    public FieldUnivariateDerivative1<T> copySign(T sign) {
        long m = Double.doubleToLongBits(this.f0.getReal());
        long s = Double.doubleToLongBits(sign.getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldUnivariateDerivative1<T> copySign(FieldUnivariateDerivative1<T> sign) {
        long m = Double.doubleToLongBits(this.f0.getReal());
        long s = Double.doubleToLongBits(sign.f0.getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldUnivariateDerivative1<T> copySign(double sign) {
        long m = Double.doubleToLongBits(this.f0.getReal());
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public int getExponent() {
        return FastMath.getExponent(this.f0.getReal());
    }

    @Override
    public FieldUnivariateDerivative1<T> scalb(int n) {
        return new FieldUnivariateDerivative1<T>(FastMath.scalb(this.f0, n), FastMath.scalb(this.f1, n));
    }

    @Override
    public FieldUnivariateDerivative1<T> hypot(FieldUnivariateDerivative1<T> y) {
        int expY;
        if (Double.isInfinite(this.f0.getReal()) || Double.isInfinite(y.f0.getReal())) {
            return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.newInstance(Double.POSITIVE_INFINITY), (RealFieldElement)this.f0.getField().getZero());
        }
        if (Double.isNaN(this.f0.getReal()) || Double.isNaN(y.f0.getReal())) {
            return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)this.f0.newInstance(Double.NaN), (RealFieldElement)this.f0.getField().getZero());
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        Object scaledX = this.scalb(-middleExp);
        Object scaledY = y.scalb(-middleExp);
        Object scaledH = ((FieldUnivariateDerivative1)scaledX).multiply((FieldUnivariateDerivative1<T>)scaledX).add(((FieldUnivariateDerivative1)scaledY).multiply((FieldUnivariateDerivative1<T>)scaledY)).sqrt();
        return ((FieldUnivariateDerivative1)scaledH).scalb(middleExp);
    }

    @Override
    public FieldUnivariateDerivative1<T> reciprocal() {
        RealFieldElement inv1 = (RealFieldElement)this.f0.reciprocal();
        RealFieldElement inv2 = inv1.multiply(inv1);
        return new FieldUnivariateDerivative1<RealFieldElement>(inv1, ((RealFieldElement)this.f1.negate()).multiply(inv2));
    }

    public FieldUnivariateDerivative1<T> compose(T g0, T g1) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)g0, (RealFieldElement)g1.multiply(this.f1));
    }

    @Override
    public FieldUnivariateDerivative1<T> sqrt() {
        T s = FastMath.sqrt(this.f0);
        return this.compose(s, (RealFieldElement)((RealFieldElement)s.add(s)).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> cbrt() {
        T c = FastMath.cbrt(this.f0);
        return this.compose(c, (RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(c)).multiply(3)).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> rootN(int n) {
        if (n == 2) {
            return this.sqrt();
        }
        if (n == 3) {
            return this.cbrt();
        }
        T r = FastMath.pow(this.f0, 1.0 / (double)n);
        return this.compose(r, (RealFieldElement)((RealFieldElement)FastMath.pow(r, n - 1).multiply((int)n)).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1Field<T> getField() {
        return FieldUnivariateDerivative1Field.getUnivariateDerivative1Field(this.f0.getField());
    }

    public static <T extends RealFieldElement<T>> FieldUnivariateDerivative1<T> pow(double a, FieldUnivariateDerivative1<T> x) {
        if (a == 0.0) {
            return ((FieldUnivariateDerivative1Field)x.getField()).getZero();
        }
        RealFieldElement aX = FastMath.pow((RealFieldElement)x.f0.newInstance(a), x.f0);
        return new FieldUnivariateDerivative1<RealFieldElement>(aX, (RealFieldElement)((RealFieldElement)aX.multiply(FastMath.log(a))).multiply(x.f1));
    }

    @Override
    public FieldUnivariateDerivative1<T> pow(double p) {
        if (p == 0.0) {
            return ((FieldUnivariateDerivative1Field)this.getField()).getOne();
        }
        T f0Pm1 = FastMath.pow(this.f0, p - 1.0);
        return this.compose((RealFieldElement)f0Pm1.multiply(this.f0), (RealFieldElement)f0Pm1.multiply(p));
    }

    @Override
    public FieldUnivariateDerivative1<T> pow(int n) {
        if (n == 0) {
            return ((FieldUnivariateDerivative1Field)this.getField()).getOne();
        }
        T f0Nm1 = FastMath.pow(this.f0, n - 1);
        return this.compose((RealFieldElement)f0Nm1.multiply(this.f0), (RealFieldElement)f0Nm1.multiply((int)n));
    }

    @Override
    public FieldUnivariateDerivative1<T> pow(FieldUnivariateDerivative1<T> e) {
        return ((FieldUnivariateDerivative1)this.log()).multiply(e).exp();
    }

    @Override
    public FieldUnivariateDerivative1<T> exp() {
        T exp = FastMath.exp(this.f0);
        return this.compose(exp, exp);
    }

    @Override
    public FieldUnivariateDerivative1<T> expm1() {
        T exp = FastMath.exp(this.f0);
        T expM1 = FastMath.expm1(this.f0);
        return this.compose(expM1, exp);
    }

    @Override
    public FieldUnivariateDerivative1<T> log() {
        return this.compose(FastMath.log(this.f0), (RealFieldElement)this.f0.reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> log1p() {
        return this.compose(FastMath.log1p(this.f0), (RealFieldElement)((RealFieldElement)this.f0.add(1.0)).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> log10() {
        return this.compose(FastMath.log10(this.f0), (RealFieldElement)((RealFieldElement)this.f0.multiply(FastMath.log(10.0))).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> cos() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.f0);
        return this.compose((RealFieldElement)sinCos.cos(), (RealFieldElement)((RealFieldElement)sinCos.sin()).negate());
    }

    @Override
    public FieldUnivariateDerivative1<T> sin() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.f0);
        return this.compose((RealFieldElement)sinCos.sin(), (RealFieldElement)sinCos.cos());
    }

    @Override
    public FieldSinCos<FieldUnivariateDerivative1<T>> sinCos() {
        FieldSinCos<T> sinCos = FastMath.sinCos(this.f0);
        return new FieldSinCos<FieldUnivariateDerivative1<T>>(new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)sinCos.sin(), (RealFieldElement)this.f1.multiply(sinCos.cos())), new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)sinCos.cos(), (RealFieldElement)((RealFieldElement)this.f1.multiply(sinCos.sin())).negate()));
    }

    @Override
    public FieldUnivariateDerivative1<T> tan() {
        T tan = FastMath.tan(this.f0);
        return this.compose(tan, (RealFieldElement)((RealFieldElement)tan.multiply(tan)).add(1.0));
    }

    @Override
    public FieldUnivariateDerivative1<T> acos() {
        return this.compose(FastMath.acos(this.f0), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).negate()).add(1.0)).sqrt()).reciprocal()).negate());
    }

    @Override
    public FieldUnivariateDerivative1<T> asin() {
        return this.compose(FastMath.asin(this.f0), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).negate()).add(1.0)).sqrt()).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> atan() {
        return this.compose(FastMath.atan(this.f0), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).add(1.0)).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> atan2(FieldUnivariateDerivative1<T> x) {
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).add(x.f0.multiply(x.f0))).reciprocal();
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)FastMath.atan2(this.f0, x.f0), ((RealFieldElement)this.f0.linearCombination(x.f0, this.f1, x.f1.negate(), this.f0)).multiply(inv));
    }

    @Override
    public FieldUnivariateDerivative1<T> cosh() {
        return this.compose(FastMath.cosh(this.f0), FastMath.sinh(this.f0));
    }

    @Override
    public FieldUnivariateDerivative1<T> sinh() {
        return this.compose(FastMath.sinh(this.f0), FastMath.cosh(this.f0));
    }

    @Override
    public FieldUnivariateDerivative1<T> tanh() {
        T tanh = FastMath.tanh(this.f0);
        return this.compose(tanh, (RealFieldElement)((RealFieldElement)((RealFieldElement)tanh.multiply(tanh)).negate()).add(1.0));
    }

    @Override
    public FieldUnivariateDerivative1<T> acosh() {
        return this.compose(FastMath.acosh(this.f0), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).subtract(1.0)).sqrt()).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> asinh() {
        return this.compose(FastMath.asinh(this.f0), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).add(1.0)).sqrt()).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> atanh() {
        return this.compose(FastMath.atanh(this.f0), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.f0.multiply(this.f0)).negate()).add(1.0)).reciprocal());
    }

    @Override
    public FieldUnivariateDerivative1<T> toDegrees() {
        return new FieldUnivariateDerivative1<T>(FastMath.toDegrees(this.f0), FastMath.toDegrees(this.f1));
    }

    @Override
    public FieldUnivariateDerivative1<T> toRadians() {
        return new FieldUnivariateDerivative1<T>(FastMath.toRadians(this.f0), FastMath.toRadians(this.f1));
    }

    public T taylor(double delta) {
        return (T)((RealFieldElement)this.f0.add(this.f1.multiply(delta)));
    }

    public T taylor(T delta) {
        return (T)((RealFieldElement)this.f0.add(this.f1.multiply(delta)));
    }

    public FieldUnivariateDerivative1<T> linearCombination(T[] a, FieldUnivariateDerivative1<T>[] b) {
        Field field = b[0].f0.getField();
        int n = b.length;
        RealFieldElement[] b0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b1 = (RealFieldElement[])MathArrays.buildArray(field, n);
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].f0;
            b1[i] = b[i].f1;
        }
        return new FieldUnivariateDerivative1<RealFieldElement>(b[0].f0.linearCombination(a, (RealFieldElement[])b0), b[0].f0.linearCombination(a, (RealFieldElement[])b1));
    }

    public FieldUnivariateDerivative1<T> linearCombination(FieldUnivariateDerivative1<T>[] a, FieldUnivariateDerivative1<T>[] b) {
        Field field = a[0].f0.getField();
        int n = a.length;
        RealFieldElement[] a0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] a1 = (RealFieldElement[])MathArrays.buildArray(field, 2 * n);
        RealFieldElement[] b1 = (RealFieldElement[])MathArrays.buildArray(field, 2 * n);
        for (int i = 0; i < n; ++i) {
            FieldUnivariateDerivative1<T> ai = a[i];
            FieldUnivariateDerivative1<T> bi = b[i];
            a0[i] = ai.f0;
            b0[i] = bi.f0;
            a1[2 * i] = ai.f0;
            a1[2 * i + 1] = ai.f1;
            b1[2 * i] = bi.f1;
            b1[2 * i + 1] = bi.f0;
        }
        return new FieldUnivariateDerivative1<RealFieldElement>(a[0].f0.linearCombination((RealFieldElement[])a0, (RealFieldElement[])b0), a[0].f0.linearCombination((RealFieldElement[])a1, (RealFieldElement[])b1));
    }

    public FieldUnivariateDerivative1<T> linearCombination(double[] a, FieldUnivariateDerivative1<T>[] b) {
        Field field = b[0].f0.getField();
        int n = b.length;
        RealFieldElement[] b0 = (RealFieldElement[])MathArrays.buildArray(field, n);
        RealFieldElement[] b1 = (RealFieldElement[])MathArrays.buildArray(field, n);
        for (int i = 0; i < n; ++i) {
            b0[i] = b[i].f0;
            b1[i] = b[i].f1;
        }
        return new FieldUnivariateDerivative1<RealFieldElement>(b[0].f0.linearCombination(a, (T[])b0), b[0].f0.linearCombination(a, (T[])b1));
    }

    @Override
    public FieldUnivariateDerivative1<T> linearCombination(FieldUnivariateDerivative1<T> a1, FieldUnivariateDerivative1<T> b1, FieldUnivariateDerivative1<T> a2, FieldUnivariateDerivative1<T> b2) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)a1.f0.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0), (RealFieldElement)a1.f0.linearCombination(a1.f0, b1.f1, a1.f1, b1.f0, a2.f0, b2.f1, a2.f1, b2.f0));
    }

    @Override
    public FieldUnivariateDerivative1<T> linearCombination(double a1, FieldUnivariateDerivative1<T> b1, double a2, FieldUnivariateDerivative1<T> b2) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)b1.f0.linearCombination(a1, b1.f0, a2, b2.f0), (RealFieldElement)b1.f0.linearCombination(a1, b1.f1, a2, b2.f1));
    }

    @Override
    public FieldUnivariateDerivative1<T> linearCombination(FieldUnivariateDerivative1<T> a1, FieldUnivariateDerivative1<T> b1, FieldUnivariateDerivative1<T> a2, FieldUnivariateDerivative1<T> b2, FieldUnivariateDerivative1<T> a3, FieldUnivariateDerivative1<T> b3) {
        Field field = a1.f0.getField();
        RealFieldElement[] a = (RealFieldElement[])MathArrays.buildArray(field, 6);
        RealFieldElement[] b = (RealFieldElement[])MathArrays.buildArray(field, 6);
        a[0] = a1.f0;
        a[1] = a1.f1;
        a[2] = a2.f0;
        a[3] = a2.f1;
        a[4] = a3.f0;
        a[5] = a3.f1;
        b[0] = b1.f1;
        b[1] = b1.f0;
        b[2] = b2.f1;
        b[3] = b2.f0;
        b[4] = b3.f1;
        b[5] = b3.f0;
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)a1.f0.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0, a3.f0, b3.f0), a1.f0.linearCombination((RealFieldElement[])a, (RealFieldElement[])b));
    }

    @Override
    public FieldUnivariateDerivative1<T> linearCombination(T a1, FieldUnivariateDerivative1<T> b1, T a2, FieldUnivariateDerivative1<T> b2, T a3, FieldUnivariateDerivative1<T> b3) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)b1.f0.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0), (RealFieldElement)b1.f0.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1));
    }

    @Override
    public FieldUnivariateDerivative1<T> linearCombination(double a1, FieldUnivariateDerivative1<T> b1, double a2, FieldUnivariateDerivative1<T> b2, double a3, FieldUnivariateDerivative1<T> b3) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)b1.f0.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0), (RealFieldElement)b1.f0.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1));
    }

    @Override
    public FieldUnivariateDerivative1<T> linearCombination(FieldUnivariateDerivative1<T> a1, FieldUnivariateDerivative1<T> b1, FieldUnivariateDerivative1<T> a2, FieldUnivariateDerivative1<T> b2, FieldUnivariateDerivative1<T> a3, FieldUnivariateDerivative1<T> b3, FieldUnivariateDerivative1<T> a4, FieldUnivariateDerivative1<T> b4) {
        Field field = a1.f0.getField();
        RealFieldElement[] a = (RealFieldElement[])MathArrays.buildArray(field, 8);
        RealFieldElement[] b = (RealFieldElement[])MathArrays.buildArray(field, 8);
        a[0] = a1.f0;
        a[1] = a1.f1;
        a[2] = a2.f0;
        a[3] = a2.f1;
        a[4] = a3.f0;
        a[5] = a3.f1;
        a[6] = a4.f0;
        a[7] = a4.f1;
        b[0] = b1.f1;
        b[1] = b1.f0;
        b[2] = b2.f1;
        b[3] = b2.f0;
        b[4] = b3.f1;
        b[5] = b3.f0;
        b[6] = b4.f1;
        b[7] = b4.f0;
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)a1.f0.linearCombination(a1.f0, b1.f0, a2.f0, b2.f0, a3.f0, b3.f0, a4.f0, b4.f0), a1.f0.linearCombination((RealFieldElement[])a, (RealFieldElement[])b));
    }

    @Override
    public FieldUnivariateDerivative1<T> linearCombination(double a1, FieldUnivariateDerivative1<T> b1, double a2, FieldUnivariateDerivative1<T> b2, double a3, FieldUnivariateDerivative1<T> b3, double a4, FieldUnivariateDerivative1<T> b4) {
        return new FieldUnivariateDerivative1<RealFieldElement>((RealFieldElement)b1.f0.linearCombination(a1, b1.f0, a2, b2.f0, a3, b3.f0, a4, b4.f0), (RealFieldElement)b1.f0.linearCombination(a1, b1.f1, a2, b2.f1, a3, b3.f1, a4, b4.f1));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FieldUnivariateDerivative1) {
            FieldUnivariateDerivative1 rhs = (FieldUnivariateDerivative1)other;
            return this.f0.equals(rhs.f0) && this.f1.equals(rhs.f1);
        }
        return false;
    }

    public int hashCode() {
        return 453 - 19 * this.f0.hashCode() + 37 * this.f1.hashCode();
    }
}

