/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBody;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.AEMAttitudeType;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class OrekitAttitudeEphemerisFile
implements AttitudeEphemerisFile {
    private final Map<String, OrekitSatelliteAttitudeEphemeris> satellites = new ConcurrentHashMap<String, OrekitSatelliteAttitudeEphemeris>();

    public Map<String, OrekitSatelliteAttitudeEphemeris> getSatellites() {
        return Collections.unmodifiableMap(this.satellites);
    }

    public OrekitSatelliteAttitudeEphemeris addSatellite(String id) {
        OrekitSatelliteAttitudeEphemeris newSat = new OrekitSatelliteAttitudeEphemeris(id);
        this.satellites.put(id, newSat);
        return newSat;
    }

    public static class OrekitAttitudeEphemerisSegment
    implements AttitudeEphemerisFile.AttitudeEphemerisSegment {
        private List<TimeStampedAngularCoordinates> attitudeDataLines;
        private final String frameCenterString;
        private String refFrameAString;
        private String refFrameBString;
        private String attitudeDir;
        private String attitudeType;
        private boolean isFirst;
        private RotationOrder rotationOrder;
        private final String timeScaleString;
        private final TimeScale timeScale;
        private String interpolationMethod;
        private int interpolationSamples;
        private AngularDerivativesFilter angularDerivativesFilter;
        private Frame referenceFrame;

        public OrekitAttitudeEphemerisSegment(List<TimeStampedAngularCoordinates> attitudeDataLines, String frameCenterString, String refFrameAString, String refFrameBString, String attitudeDir, String attitudeType, boolean isFirst, RotationOrder rotationOrder, TimeScale timeScale, String interpolationMethod, int interpolationSamples, Frame referenceFrame) {
            this.attitudeDataLines = attitudeDataLines;
            this.frameCenterString = frameCenterString;
            this.refFrameAString = refFrameAString;
            this.refFrameBString = refFrameBString;
            this.attitudeDir = attitudeDir;
            this.attitudeType = attitudeType;
            this.isFirst = isFirst;
            this.rotationOrder = rotationOrder;
            this.timeScaleString = timeScale.getName();
            this.timeScale = timeScale;
            this.interpolationMethod = interpolationMethod;
            this.interpolationSamples = interpolationSamples;
            this.referenceFrame = referenceFrame;
            this.angularDerivativesFilter = AEMAttitudeType.getAttitudeType(attitudeType).getAngularDerivativesFilter();
        }

        public List<TimeStampedAngularCoordinates> getAngularCoordinates() {
            return Collections.unmodifiableList(this.attitudeDataLines);
        }

        @Override
        public String getFrameCenterString() {
            return this.frameCenterString;
        }

        @Override
        public String getRefFrameAString() {
            return this.refFrameAString;
        }

        @Override
        public String getRefFrameBString() {
            return this.refFrameBString;
        }

        @Override
        public Frame getReferenceFrame() {
            return this.referenceFrame;
        }

        @Override
        public String getAttitudeDirection() {
            return this.attitudeDir;
        }

        @Override
        public String getAttitudeType() {
            return this.attitudeType;
        }

        @Override
        public boolean isFirst() {
            return this.isFirst;
        }

        @Override
        public RotationOrder getRotationOrder() {
            return this.rotationOrder;
        }

        @Override
        public String getTimeScaleString() {
            return this.timeScaleString;
        }

        @Override
        public TimeScale getTimeScale() {
            return this.timeScale;
        }

        @Override
        public AbsoluteDate getStart() {
            return this.attitudeDataLines.get(0).getDate();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.attitudeDataLines.get(this.attitudeDataLines.size() - 1).getDate();
        }

        @Override
        public String getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        public int getInterpolationSamples() {
            return this.interpolationSamples;
        }

        @Override
        public AngularDerivativesFilter getAvailableDerivatives() {
            return this.angularDerivativesFilter;
        }
    }

    public static class OrekitSatelliteAttitudeEphemeris
    implements AttitudeEphemerisFile.SatelliteAttitudeEphemeris {
        public static final String DEFAULT_INTERPOLATION_METHOD = "LINEAR";
        public static final int DEFAULT_INTERPOLATION_SIZE = 2;
        public static final String DEFAULT_ATTITUDE_TYPE = "QUATERNION";
        public static final boolean DEFAULT_IS_FIRST = false;
        public static final RotationOrder DEFAULT_ROTATION_ORDER = RotationOrder.ZYX;
        public static final String DEFAULT_REF_FRAME_A = "EME2000";
        public static final String DEFAULT_REF_FRAME_B = "SC_BODY_1";
        public static final String DEFAULT_ATTITUDE_DIR = "A2B";
        private final String id;
        private AbsoluteDate startDate;
        private AbsoluteDate stopDate;
        private final List<OrekitAttitudeEphemerisSegment> segments;

        public OrekitSatelliteAttitudeEphemeris(String id) {
            this.id = id;
            this.segments = new ArrayList<OrekitAttitudeEphemerisSegment>();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public List<? extends AttitudeEphemerisFile.AttitudeEphemerisSegment> getSegments() {
            return Collections.unmodifiableList(this.segments);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.startDate;
        }

        @Override
        public AbsoluteDate getStop() {
            return this.stopDate;
        }

        @DefaultDataContext
        public OrekitAttitudeEphemerisSegment addNewSegment(List<SpacecraftState> states) {
            return this.addNewSegment(states, DEFAULT_INTERPOLATION_METHOD, 2);
        }

        @DefaultDataContext
        public OrekitAttitudeEphemerisSegment addNewSegment(List<SpacecraftState> states, String interpolationMethod, int interpolationSamples) {
            return this.addNewSegment(states, interpolationMethod, interpolationSamples, DEFAULT_ATTITUDE_TYPE, false, DEFAULT_ROTATION_ORDER);
        }

        @DefaultDataContext
        public OrekitAttitudeEphemerisSegment addNewSegment(List<SpacecraftState> states, String interpolationMethod, int interpolationSamples, String attitudeType, boolean isFirst, RotationOrder rotationOrder) {
            return this.addNewSegment(states, interpolationMethod, interpolationSamples, attitudeType, isFirst, rotationOrder, DEFAULT_REF_FRAME_A, DEFAULT_REF_FRAME_B, DEFAULT_ATTITUDE_DIR);
        }

        @DefaultDataContext
        public OrekitAttitudeEphemerisSegment addNewSegment(List<SpacecraftState> states, String interpolationMethod, int interpolationSamples, String attitudeType, boolean isFirst, RotationOrder rotationOrder, String refFrameA, String refFrameB, String attitudeDir) {
            return this.addNewSegment(states, interpolationMethod, interpolationSamples, attitudeType, isFirst, rotationOrder, refFrameA, refFrameB, attitudeDir, DataContext.getDefault().getCelestialBodies().getEarth());
        }

        @DefaultDataContext
        public OrekitAttitudeEphemerisSegment addNewSegment(List<SpacecraftState> states, String interpolationMethod, int interpolationSamples, String attitudeType, boolean isFirst, RotationOrder rotationOrder, String refFrameA, String refFrameB, String attitudeDir, CelestialBody body) {
            return this.addNewSegment(states, interpolationMethod, interpolationSamples, attitudeType, isFirst, rotationOrder, refFrameA, refFrameB, attitudeDir, body, DataContext.getDefault().getTimeScales().getUTC());
        }

        public OrekitAttitudeEphemerisSegment addNewSegment(List<SpacecraftState> states, String interpolationMethod, int interpolationSamples, String attitudeType, boolean isFirst, RotationOrder rotationOrder, String refFrameA, String refFrameB, String attitudeDir, CelestialBody body, TimeScale timeScale) {
            int minimumSampleSize = 2;
            if (states == null || states.size() == 0) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "states");
            }
            if (interpolationSamples < 2) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA_FOR_INTERPOLATION, interpolationSamples);
            }
            AbsoluteDate start = states.get(0).getDate();
            AbsoluteDate stop = states.get(states.size() - 1).getDate();
            if (this.startDate == null || start.compareTo(this.startDate) < 0) {
                this.startDate = start;
            }
            if (this.stopDate == null || stop.compareTo(this.stopDate) > 0) {
                this.stopDate = stop;
            }
            ArrayList<TimeStampedAngularCoordinates> attitudeDataLines = new ArrayList<TimeStampedAngularCoordinates>();
            for (SpacecraftState state : states) {
                attitudeDataLines.add(state.getAttitude().getOrientation());
            }
            OrekitAttitudeEphemerisSegment newSeg = new OrekitAttitudeEphemerisSegment(attitudeDataLines, body.getName(), refFrameA, refFrameB, attitudeDir, attitudeType, isFirst, rotationOrder, timeScale, interpolationMethod, interpolationSamples, states.get(0).getFrame());
            this.segments.add(newSeg);
            return newSeg;
        }
    }
}

