/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.attitudes.AggregateBoundedAttitudeProvider;
import org.orekit.attitudes.BoundedAttitudeProvider;
import org.orekit.files.general.EphemerisSegmentAttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public interface AttitudeEphemerisFile {
    public Map<String, ? extends SatelliteAttitudeEphemeris> getSatellites();

    public static interface AttitudeEphemerisSegment {
        public List<? extends TimeStampedAngularCoordinates> getAngularCoordinates();

        public String getFrameCenterString();

        public String getRefFrameAString();

        public String getRefFrameBString();

        public Frame getReferenceFrame();

        public String getAttitudeDirection();

        public String getAttitudeType();

        public boolean isFirst();

        public RotationOrder getRotationOrder();

        public String getTimeScaleString();

        public TimeScale getTimeScale();

        public AbsoluteDate getStart();

        public AbsoluteDate getStop();

        public String getInterpolationMethod();

        public int getInterpolationSamples();

        public AngularDerivativesFilter getAvailableDerivatives();

        default public BoundedAttitudeProvider getAttitudeProvider() {
            return new EphemerisSegmentAttitudeProvider(this);
        }
    }

    public static interface SatelliteAttitudeEphemeris {
        public String getId();

        public List<? extends AttitudeEphemerisSegment> getSegments();

        public AbsoluteDate getStart();

        public AbsoluteDate getStop();

        default public BoundedAttitudeProvider getAttitudeProvider() {
            ArrayList<BoundedAttitudeProvider> providers = new ArrayList<BoundedAttitudeProvider>();
            for (AttitudeEphemerisSegment attitudeEphemerisSegment : this.getSegments()) {
                providers.add(attitudeEphemerisSegment.getAttitudeProvider());
            }
            return new AggregateBoundedAttitudeProvider(providers);
        }
    }
}

