/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ODMFile;
import org.orekit.files.ccsds.ODMMetaData;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;

public abstract class OGMFile
extends ODMFile {
    private AbsoluteDate epoch;
    private double a;
    private double e;
    private double i;
    private double raan;
    private double pa;
    private double anomaly;
    private PositionAngle anomalyType;
    private double mass = Double.NaN;
    private double solarRadArea;
    private double solarRadCoeff;
    private double dragArea;
    private double dragCoeff;
    private LOFType covRefLofType;
    private Frame covRefFrame;
    private RealMatrix covarianceMatrix;
    private Map<String, String> userDefinedParameters = new HashMap<String, String>();
    private boolean hasKeplerianElements;
    private List<String> epochComment = Collections.emptyList();
    private List<String> keplerianElementsComment = Collections.emptyList();
    private List<String> spacecraftComment = Collections.emptyList();
    private List<String> covarianceComment = Collections.emptyList();

    OGMFile() {
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    void setEpoch(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    public double getA() {
        return this.a;
    }

    void setA(double a) {
        this.a = a;
    }

    public double getE() {
        return this.e;
    }

    void setE(double e) {
        this.e = e;
    }

    public double getI() {
        return this.i;
    }

    void setI(double i) {
        this.i = i;
    }

    public double getRaan() {
        return this.raan;
    }

    void setRaan(double raan) {
        this.raan = raan;
    }

    public double getPa() {
        return this.pa;
    }

    void setPa(double pa) {
        this.pa = pa;
    }

    public double getAnomaly() {
        return this.anomaly;
    }

    void setAnomaly(double anomaly) {
        this.anomaly = anomaly;
    }

    public PositionAngle getAnomalyType() {
        return this.anomalyType;
    }

    void setAnomalyType(String anomalyType) {
        this.anomalyType = PositionAngle.valueOf(anomalyType);
    }

    public double getMass() {
        if (Double.isNaN(this.mass)) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_SPACECRAFT_MASS, new Object[0]);
        }
        return this.mass;
    }

    void setMass(double mass) {
        this.mass = mass;
    }

    public double getSolarRadArea() {
        return this.solarRadArea;
    }

    void setSolarRadArea(double solarRadArea) {
        this.solarRadArea = solarRadArea;
    }

    public double getSolarRadCoeff() {
        return this.solarRadCoeff;
    }

    void setSolarRadCoeff(double solarRadCoeff) {
        this.solarRadCoeff = solarRadCoeff;
    }

    public double getDragArea() {
        return this.dragArea;
    }

    void setDragArea(double dragArea) {
        this.dragArea = dragArea;
    }

    public double getDragCoeff() {
        return this.dragCoeff;
    }

    void setDragCoeff(double dragCoeff) {
        this.dragCoeff = dragCoeff;
    }

    public LOFType getCovRefLofType() {
        return this.covRefLofType;
    }

    void setCovRefLofType(LOFType covRefLofType) {
        this.covRefLofType = covRefLofType;
        this.covRefFrame = null;
    }

    public Frame getCovRefFrame() {
        return this.covRefFrame;
    }

    void setCovRefFrame(Frame covRefFrame) {
        this.covRefLofType = null;
        this.covRefFrame = covRefFrame;
    }

    public RealMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    void setCovarianceMatrixEntry(int j, int k, double entry) {
        this.covarianceMatrix.setEntry(j, k, entry);
        this.covarianceMatrix.setEntry(k, j, entry);
    }

    public Map<String, String> getUserDefinedParameters() {
        return this.userDefinedParameters;
    }

    void setUserDefinedParameters(String keyword, String value) {
        this.userDefinedParameters.put(keyword, value);
    }

    public boolean hasKeplerianElements() {
        return this.hasKeplerianElements;
    }

    void setHasKeplerianElements(boolean hasKeplerianElements) {
        this.hasKeplerianElements = hasKeplerianElements;
    }

    public boolean hasCovarianceMatrix() {
        return this.covarianceMatrix != null;
    }

    void createCovarianceMatrix() {
        this.covarianceMatrix = MatrixUtils.createRealMatrix((int)6, (int)6);
    }

    public List<String> getEpochComment() {
        return Collections.unmodifiableList(this.epochComment);
    }

    void setEpochComment(List<String> comment) {
        this.epochComment = new ArrayList<String>(comment);
    }

    public List<String> getKeplerianElementsComment() {
        return Collections.unmodifiableList(this.keplerianElementsComment);
    }

    void setKeplerianElementsComment(List<String> comment) {
        this.keplerianElementsComment = new ArrayList<String>(comment);
    }

    public List<String> getSpacecraftComment() {
        return Collections.unmodifiableList(this.spacecraftComment);
    }

    void setSpacecraftComment(List<String> comment) {
        this.spacecraftComment = new ArrayList<String>(comment);
    }

    public List<String> getCovarianceComment() {
        return Collections.unmodifiableList(this.covarianceComment);
    }

    void setCovarianceComment(List<String> comment) {
        this.covarianceComment = new ArrayList<String>(comment);
    }

    public abstract ODMMetaData getMetaData();
}

