/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.ArrayFieldVector;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.util.MathArrays;

public class FieldLUDecomposition<T extends FieldElement<T>> {
    private final Field<T> field;
    private T[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private FieldMatrix<T> cachedL;
    private FieldMatrix<T> cachedU;
    private FieldMatrix<T> cachedP;

    public FieldLUDecomposition(FieldMatrix<T> matrix) {
        if (!matrix.isSquare()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getColumnDimension();
        this.field = matrix.getField();
        this.lu = matrix.getData();
        this.pivot = new int[m];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        for (int row = 0; row < m; ++row) {
            this.pivot[row] = row;
        }
        this.even = true;
        this.singular = false;
        for (int col = 0; col < m; ++col) {
            FieldElement<T> sum = (FieldElement)this.field.getZero();
            for (int row = 0; row < col; ++row) {
                T[] luRow = this.lu[row];
                sum = luRow[col];
                for (int i = 0; i < row; ++i) {
                    sum = (FieldElement)sum.subtract(luRow[i].multiply(this.lu[i][col]));
                }
                luRow[col] = sum;
            }
            int nonZero = col;
            for (int row = col; row < m; ++row) {
                T[] luRow = this.lu[row];
                sum = luRow[col];
                for (int i = 0; i < col; ++i) {
                    sum = (FieldElement)sum.subtract(luRow[i].multiply(this.lu[i][col]));
                }
                luRow[col] = sum;
                if (!this.lu[nonZero][col].isZero()) continue;
                ++nonZero;
            }
            if (nonZero >= m) {
                this.singular = true;
                return;
            }
            if (nonZero != col) {
                FieldElement tmp = (FieldElement)this.field.getZero();
                for (int i = 0; i < m; ++i) {
                    tmp = this.lu[nonZero][i];
                    this.lu[nonZero][i] = this.lu[col][i];
                    this.lu[col][i] = tmp;
                }
                int temp = this.pivot[nonZero];
                this.pivot[nonZero] = this.pivot[col];
                this.pivot[col] = temp;
                this.even = !this.even;
            }
            T luDiag = this.lu[col][col];
            for (int row = col + 1; row < m; ++row) {
                T[] luRow = this.lu[row];
                luRow[col] = (FieldElement)luRow[col].divide(luDiag);
            }
        }
    }

    public FieldMatrix<T> getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedL = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                T[] luI = this.lu[i];
                for (int j = 0; j < i; ++j) {
                    this.cachedL.setEntry(i, j, luI[j]);
                }
                this.cachedL.setEntry(i, i, (FieldElement)this.field.getOne());
            }
        }
        return this.cachedL;
    }

    public FieldMatrix<T> getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedU = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                T[] luI = this.lu[i];
                for (int j = i; j < m; ++j) {
                    this.cachedU.setEntry(i, j, luI[j]);
                }
            }
        }
        return this.cachedU;
    }

    public FieldMatrix<T> getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedP = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                this.cachedP.setEntry(i, this.pivot[i], (FieldElement)this.field.getOne());
            }
        }
        return this.cachedP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public T getDeterminant() {
        if (this.singular) {
            return (T)((FieldElement)this.field.getZero());
        }
        int m = this.pivot.length;
        FieldElement determinant = this.even ? (FieldElement)this.field.getOne() : (FieldElement)((FieldElement)this.field.getZero()).subtract(this.field.getOne());
        for (int i = 0; i < m; ++i) {
            determinant = (FieldElement)determinant.multiply(this.lu[i][i]);
        }
        return (T)determinant;
    }

    public FieldDecompositionSolver<T> getSolver() {
        return new Solver();
    }

    private class Solver
    implements FieldDecompositionSolver<T> {
        private Solver() {
        }

        @Override
        public boolean isNonSingular() {
            return !FieldLUDecomposition.this.singular;
        }

        @Override
        public FieldVector<T> solve(FieldVector<T> b) {
            int i;
            FieldElement bpCol;
            int col;
            if (b instanceof ArrayFieldVector) {
                return this.solve((ArrayFieldVector)b);
            }
            int m = FieldLUDecomposition.this.pivot.length;
            if (b.getDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getDimension(), m);
            }
            if (FieldLUDecomposition.this.singular) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
            }
            FieldElement[] bp = (FieldElement[])MathArrays.buildArray(FieldLUDecomposition.this.field, m);
            for (int row = 0; row < m; ++row) {
                bp[row] = b.getEntry(FieldLUDecomposition.this.pivot[row]);
            }
            for (col = 0; col < m; ++col) {
                bpCol = bp[col];
                for (i = col + 1; i < m; ++i) {
                    bp[i] = bp[i].subtract(bpCol.multiply(FieldLUDecomposition.this.lu[i][col]));
                }
            }
            for (col = m - 1; col >= 0; --col) {
                bp[col] = bp[col].divide(FieldLUDecomposition.this.lu[col][col]);
                bpCol = bp[col];
                for (i = 0; i < col; ++i) {
                    bp[i] = bp[i].subtract(bpCol.multiply(FieldLUDecomposition.this.lu[i][col]));
                }
            }
            return new ArrayFieldVector(FieldLUDecomposition.this.field, bp, false);
        }

        @Override
        public ArrayFieldVector<T> solve(ArrayFieldVector<T> b) {
            int i;
            FieldElement bpCol;
            int col;
            int m = FieldLUDecomposition.this.pivot.length;
            int length = b.getDimension();
            if (length != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, length, m);
            }
            if (FieldLUDecomposition.this.singular) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
            }
            FieldElement[] bp = (FieldElement[])MathArrays.buildArray(FieldLUDecomposition.this.field, m);
            for (int row = 0; row < m; ++row) {
                bp[row] = b.getEntry(FieldLUDecomposition.this.pivot[row]);
            }
            for (col = 0; col < m; ++col) {
                bpCol = bp[col];
                for (i = col + 1; i < m; ++i) {
                    bp[i] = bp[i].subtract(bpCol.multiply(FieldLUDecomposition.this.lu[i][col]));
                }
            }
            for (col = m - 1; col >= 0; --col) {
                bp[col] = bp[col].divide(FieldLUDecomposition.this.lu[col][col]);
                bpCol = bp[col];
                for (i = 0; i < col; ++i) {
                    bp[i] = bp[i].subtract(bpCol.multiply(FieldLUDecomposition.this.lu[i][col]));
                }
            }
            return new ArrayFieldVector(bp, false);
        }

        @Override
        public FieldMatrix<T> solve(FieldMatrix<T> b) {
            FieldElement[] bpCol;
            int col;
            int m = FieldLUDecomposition.this.pivot.length;
            if (b.getRowDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getRowDimension(), m);
            }
            if (FieldLUDecomposition.this.singular) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
            }
            int nColB = b.getColumnDimension();
            FieldElement[][] bp = (FieldElement[][])MathArrays.buildArray(FieldLUDecomposition.this.field, m, nColB);
            for (int row = 0; row < m; ++row) {
                FieldElement[] bpRow = bp[row];
                int pRow = FieldLUDecomposition.this.pivot[row];
                for (int col2 = 0; col2 < nColB; ++col2) {
                    bpRow[col2] = b.getEntry(pRow, col2);
                }
            }
            for (col = 0; col < m; ++col) {
                bpCol = bp[col];
                for (int i = col + 1; i < m; ++i) {
                    FieldElement[] bpI = bp[i];
                    FieldElement luICol = FieldLUDecomposition.this.lu[i][col];
                    for (int j = 0; j < nColB; ++j) {
                        bpI[j] = bpI[j].subtract(bpCol[j].multiply(luICol));
                    }
                }
            }
            for (col = m - 1; col >= 0; --col) {
                bpCol = bp[col];
                FieldElement luDiag = FieldLUDecomposition.this.lu[col][col];
                for (int j = 0; j < nColB; ++j) {
                    bpCol[j] = bpCol[j].divide(luDiag);
                }
                for (int i = 0; i < col; ++i) {
                    FieldElement[] bpI = bp[i];
                    FieldElement luICol = FieldLUDecomposition.this.lu[i][col];
                    for (int j = 0; j < nColB; ++j) {
                        bpI[j] = bpI[j].subtract(bpCol[j].multiply(luICol));
                    }
                }
            }
            return new Array2DRowFieldMatrix(FieldLUDecomposition.this.field, bp, false);
        }

        @Override
        public FieldMatrix<T> getInverse() {
            int m = FieldLUDecomposition.this.pivot.length;
            FieldElement one = (FieldElement)FieldLUDecomposition.this.field.getOne();
            Array2DRowFieldMatrix<FieldElement> identity = new Array2DRowFieldMatrix<FieldElement>(FieldLUDecomposition.this.field, m, m);
            for (int i = 0; i < m; ++i) {
                identity.setEntry(i, i, one);
            }
            return this.solve(identity);
        }
    }
}

