/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.exception;

import java.text.MessageFormat;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.LocalizedException;

public class MathRuntimeException
extends RuntimeException
implements LocalizedException {
    private static final long serialVersionUID = 20160217L;
    private static final String REPORT_URL = "https://github.com/Hipparchus-Math/hipparchus/issues";
    private final Localizable specifier;
    private final Object[] parts;

    public MathRuntimeException(Localizable specifier, Object ... parts) {
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    public MathRuntimeException(Throwable cause, Localizable specifier, Object ... parts) {
        super(cause);
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    public static MathRuntimeException createInternalError() {
        return new MathRuntimeException(LocalizedCoreFormats.INTERNAL_ERROR, REPORT_URL);
    }

    public static MathRuntimeException createInternalError(Throwable cause) {
        return new MathRuntimeException(cause, LocalizedCoreFormats.INTERNAL_ERROR, REPORT_URL);
    }

    @Override
    public String getMessage(Locale locale) {
        return this.buildMessage(locale);
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    @Override
    public Localizable getSpecifier() {
        return this.specifier;
    }

    @Override
    public Object[] getParts() {
        return (Object[])this.parts.clone();
    }

    private String buildMessage(Locale locale) {
        if (this.specifier == null) {
            return "";
        }
        try {
            return new MessageFormat(this.specifier.getLocalizedString(locale), locale).format(this.parts);
        }
        catch (Exception e) {
            this.addSuppressed(e);
            return this.specifier.getSourceString();
        }
    }
}

