/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.models.earth.GeoMagneticField;
import org.orekit.models.earth.GeoMagneticFieldFactory;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.UTCScale;

public class MagneticFieldDetector
extends AbstractDetector<MagneticFieldDetector> {
    private final double limit;
    private final boolean seaLevel;
    private GeoMagneticField field;
    private double currentYear;
    private final GeoMagneticFieldFactory.FieldModel type;
    private final OneAxisEllipsoid body;
    private final DataContext dataContext;

    @DefaultDataContext
    public MagneticFieldDetector(double limit, GeoMagneticFieldFactory.FieldModel type, OneAxisEllipsoid body) throws OrekitIllegalArgumentException {
        this(600.0, 1.0E-6, limit, type, body, false);
    }

    @DefaultDataContext
    public MagneticFieldDetector(double limit, GeoMagneticFieldFactory.FieldModel type, OneAxisEllipsoid body, boolean seaLevel) throws OrekitIllegalArgumentException {
        this(600.0, 1.0E-6, limit, type, body, seaLevel);
    }

    @DefaultDataContext
    public MagneticFieldDetector(double maxCheck, double threshold, double limit, GeoMagneticFieldFactory.FieldModel type, OneAxisEllipsoid body, boolean seaLevel) throws OrekitIllegalArgumentException {
        this(maxCheck, threshold, limit, type, body, seaLevel, DataContext.getDefault());
    }

    public MagneticFieldDetector(double maxCheck, double threshold, double limit, GeoMagneticFieldFactory.FieldModel type, OneAxisEllipsoid body, boolean seaLevel, DataContext dataContext) throws OrekitIllegalArgumentException {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), limit, type, body, seaLevel, dataContext);
    }

    private MagneticFieldDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super MagneticFieldDetector> handler, double limit, GeoMagneticFieldFactory.FieldModel type, OneAxisEllipsoid body, boolean seaLevel, DataContext dataContext) throws OrekitIllegalArgumentException {
        super(maxCheck, threshold, maxIter, handler);
        this.limit = limit;
        this.type = type;
        this.body = body;
        this.seaLevel = seaLevel;
        this.dataContext = dataContext;
    }

    @Override
    protected MagneticFieldDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super MagneticFieldDetector> newHandler) {
        return new MagneticFieldDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.limit, this.type, this.body, this.seaLevel, this.dataContext);
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        super.init(s0, t);
        UTCScale utc = this.dataContext.getTimeScales().getUTC();
        this.currentYear = s0.getDate().getComponents(utc).getDate().getYear();
        this.field = this.dataContext.getGeoMagneticFields().getField(this.type, this.currentYear);
    }

    @Override
    public double g(SpacecraftState s) {
        UTCScale utc = this.dataContext.getTimeScales().getUTC();
        if ((double)s.getDate().getComponents(utc).getDate().getYear() != this.currentYear) {
            this.currentYear = s.getDate().getComponents(utc).getDate().getYear();
            this.field = this.dataContext.getGeoMagneticFields().getField(this.type, this.currentYear);
        }
        GeodeticPoint geoPoint = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        double altitude = this.seaLevel ? 0.0 : geoPoint.getAltitude();
        double value = this.field.calculateField(geoPoint.getLatitude(), geoPoint.getLongitude(), altitude).getTotalIntensity();
        return value - this.limit;
    }
}

