/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.complex.Quaternion;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ADMParser;
import org.orekit.files.ccsds.APMFile;
import org.orekit.files.ccsds.KeyValue;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class APMParser
extends ADMParser {
    @DefaultDataContext
    public APMParser() {
        this(DataContext.getDefault());
    }

    public APMParser(DataContext dataContext) {
        this(AbsoluteDate.FUTURE_INFINITY, Double.NaN, null, true, 0, 0, "", dataContext);
    }

    private APMParser(AbsoluteDate missionReferenceDate, double mu, IERSConventions conventions, boolean simpleEOP, int launchYear, int launchNumber, String launchPiece, DataContext dataContext) {
        super(missionReferenceDate, mu, conventions, simpleEOP, launchYear, launchNumber, launchPiece, dataContext);
    }

    @Override
    public APMParser withMissionReferenceDate(AbsoluteDate newMissionReferenceDate) {
        return new APMParser(newMissionReferenceDate, this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public APMParser withMu(double newMu) {
        return new APMParser(this.getMissionReferenceDate(), newMu, this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public APMParser withConventions(IERSConventions newConventions) {
        return new APMParser(this.getMissionReferenceDate(), this.getMu(), newConventions, this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public APMParser withSimpleEOP(boolean newSimpleEOP) {
        return new APMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), newSimpleEOP, this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), this.getDataContext());
    }

    @Override
    public APMParser withInternationalDesignator(int newLaunchYear, int newLaunchNumber, String newLaunchPiece) {
        return new APMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), newLaunchYear, newLaunchNumber, newLaunchPiece, this.getDataContext());
    }

    @Override
    public APMParser withDataContext(DataContext dataContext) {
        return new APMParser(this.getMissionReferenceDate(), this.getMu(), this.getConventions(), this.isSimpleEOP(), this.getLaunchYear(), this.getLaunchNumber(), this.getLaunchPiece(), dataContext);
    }

    @Override
    public APMFile parse(String fileName) {
        return (APMFile)super.parse(fileName);
    }

    @Override
    public APMFile parse(InputStream stream) {
        return (APMFile)super.parse(stream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public APMFile parse(InputStream stream, String fileName) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            ParseInfo pi = new ParseInfo();
            pi.fileName = fileName;
            APMFile file = pi.file;
            pi.file.setMissionReferenceDate(this.getMissionReferenceDate());
            pi.file.setMu(this.getMu());
            pi.file.setConventions(this.getConventions());
            pi.file.setDataContext(this.getDataContext());
            pi.file.getMetaData().setLaunchYear(this.getLaunchYear());
            pi.file.getMetaData().setLaunchNumber(this.getLaunchNumber());
            pi.file.getMetaData().setLaunchPiece(this.getLaunchPiece());
            String line = reader.readLine();
            while (line != null) {
                ++pi.lineNumber;
                if (line.trim().length() != 0) {
                    pi.keyValue = new KeyValue(line, pi.lineNumber, pi.fileName);
                    if (pi.keyValue.getKeyword() == null) {
                        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                    }
                    switch (pi.keyValue.getKeyword()) {
                        case CCSDS_APM_VERS: {
                            file.setFormatVersion(pi.keyValue.getDoubleValue());
                            break;
                        }
                        case Q_FRAME_A: {
                            file.setQuaternionFrameAString(pi.keyValue.getValue());
                            break;
                        }
                        case Q_FRAME_B: {
                            file.setQuaternionFrameBString(pi.keyValue.getValue());
                            break;
                        }
                        case Q_DIR: {
                            file.setAttitudeQuaternionDirection(pi.keyValue.getValue());
                            break;
                        }
                        case QC: {
                            pi.q0 = pi.keyValue.getDoubleValue();
                            break;
                        }
                        case Q1: {
                            pi.q1 = pi.keyValue.getDoubleValue();
                            break;
                        }
                        case Q2: {
                            pi.q2 = pi.keyValue.getDoubleValue();
                            break;
                        }
                        case Q3: {
                            pi.q3 = pi.keyValue.getDoubleValue();
                            break;
                        }
                        case MAN_EPOCH_START: {
                            if (pi.maneuver != null) {
                                file.addManeuver(pi.maneuver);
                            }
                            pi.maneuver = new APMFile.APMManeuver();
                            pi.maneuver.setEpochStart(this.parseDate(pi.keyValue.getValue(), file.getMetaData().getTimeSystem()));
                            if (pi.commentTmp.isEmpty()) break;
                            pi.maneuver.setComment(pi.commentTmp);
                            pi.commentTmp.clear();
                            break;
                        }
                        case MAN_DURATION: {
                            pi.maneuver.setDuration(pi.keyValue.getDoubleValue());
                            break;
                        }
                        case MAN_REF_FRAME: {
                            pi.maneuver.setRefFrameString(pi.keyValue.getValue());
                            break;
                        }
                        case MAN_TOR_1: {
                            pi.maneuver.setTorque(new Vector3D(pi.keyValue.getDoubleValue(), pi.maneuver.getTorque().getY(), pi.maneuver.getTorque().getZ()));
                            break;
                        }
                        case MAN_TOR_2: {
                            pi.maneuver.setTorque(new Vector3D(pi.maneuver.getTorque().getX(), pi.keyValue.getDoubleValue(), pi.maneuver.getTorque().getZ()));
                            break;
                        }
                        case MAN_TOR_3: {
                            pi.maneuver.setTorque(new Vector3D(pi.maneuver.getTorque().getX(), pi.maneuver.getTorque().getY(), pi.keyValue.getDoubleValue()));
                            break;
                        }
                        default: {
                            boolean parsed = false;
                            parsed = parsed || this.parseComment(pi.keyValue, pi.commentTmp);
                            parsed = parsed || this.parseHeaderEntry(pi.keyValue, file, pi.commentTmp);
                            parsed = parsed || this.parseMetaDataEntry(pi.keyValue, file.getMetaData(), pi.commentTmp);
                            boolean bl = parsed = parsed || this.parseGeneralStateDataEntry(pi.keyValue, file, pi.commentTmp);
                            if (parsed) break;
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, pi.lineNumber, pi.fileName, line);
                        }
                    }
                }
                line = reader.readLine();
            }
            file.setQuaternion(new Quaternion(pi.q0, pi.q1, pi.q2, pi.q3));
            if (pi.maneuver != null) {
                file.addManeuver(pi.maneuver);
            }
            APMFile aPMFile = file;
            return aPMFile;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    private static class ParseInfo {
        private APMFile file = new APMFile();
        private String fileName;
        private int lineNumber = 0;
        private KeyValue keyValue;
        private List<String> commentTmp = new ArrayList<String>();
        private double q0;
        private double q1;
        private double q2;
        private double q3;
        private APMFile.APMManeuver maneuver = null;

        protected ParseInfo() {
        }
    }
}

