/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.intersection;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.rugged.api.AlgorithmId;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.intersection.IntersectionAlgorithm;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.NormalizedGeodeticPoint;

public class IgnoreDEMAlgorithm
implements IntersectionAlgorithm {
    private final AlgorithmId algorithmId = AlgorithmId.IGNORE_DEM_USE_ELLIPSOID;

    @Override
    public NormalizedGeodeticPoint intersection(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los) {
        DumpManager.dumpAlgorithm(this.algorithmId);
        return ellipsoid.pointOnGround(position, los, 0.0);
    }

    @Override
    public NormalizedGeodeticPoint refineIntersection(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los, NormalizedGeodeticPoint closeGuess) {
        DumpManager.dumpAlgorithm(this.algorithmId);
        return this.intersection(ellipsoid, position, los);
    }

    @Override
    public double getElevation(double latitude, double longitude) {
        DumpManager.dumpAlgorithm(this.algorithmId);
        return 0.0;
    }

    @Override
    public AlgorithmId getAlgorithmId() {
        return this.algorithmId;
    }
}

