/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.solvers;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AbstractUnivariateSolver;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

public class BracketingNthOrderBrentSolver
extends AbstractUnivariateSolver
implements BracketedUnivariateSolver<UnivariateFunction> {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private static final int DEFAULT_MAXIMAL_ORDER = 5;
    private static final int MAXIMAL_AGING = 2;
    private static final double REDUCTION_FACTOR = 0.0625;
    private final int maximalOrder;
    private AllowedSolution allowed;

    public BracketingNthOrderBrentSolver() {
        this(1.0E-6, 5);
    }

    public BracketingNthOrderBrentSolver(double absoluteAccuracy, int maximalOrder) throws MathIllegalArgumentException {
        super(absoluteAccuracy);
        if (maximalOrder < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, maximalOrder, 2);
        }
        this.maximalOrder = maximalOrder;
        this.allowed = AllowedSolution.ANY_SIDE;
    }

    public BracketingNthOrderBrentSolver(double relativeAccuracy, double absoluteAccuracy, int maximalOrder) throws MathIllegalArgumentException {
        super(relativeAccuracy, absoluteAccuracy);
        if (maximalOrder < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, maximalOrder, 2);
        }
        this.maximalOrder = maximalOrder;
        this.allowed = AllowedSolution.ANY_SIDE;
    }

    public BracketingNthOrderBrentSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy, int maximalOrder) throws MathIllegalArgumentException {
        super(relativeAccuracy, absoluteAccuracy, functionValueAccuracy);
        if (maximalOrder < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, maximalOrder, 2);
        }
        this.maximalOrder = maximalOrder;
        this.allowed = AllowedSolution.ANY_SIDE;
    }

    public int getMaximalOrder() {
        return this.maximalOrder;
    }

    @Override
    protected double doSolve() {
        return this.doSolveInterval().getSide(this.allowed);
    }

    protected BracketedUnivariateSolver.Interval doSolveInterval() {
        int signChangeIndex;
        int nbPoints;
        double[] x = new double[this.maximalOrder + 1];
        double[] y = new double[this.maximalOrder + 1];
        x[0] = this.getMin();
        x[1] = this.getStartValue();
        x[2] = this.getMax();
        this.verifyInterval(x[0], x[2]);
        if (x[1] < x[0] || x[2] < x[1]) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.START_POINT_NOT_IN_INTERVAL, x[1], x[0], x[2]);
        }
        y[1] = this.computeObjectiveValue(x[1]);
        if (y[1] == 0.0) {
            return new BracketedUnivariateSolver.Interval(x[1], y[1], x[1], y[1]);
        }
        y[0] = this.computeObjectiveValue(x[0]);
        if (y[0] == 0.0) {
            return new BracketedUnivariateSolver.Interval(x[0], y[0], x[0], y[0]);
        }
        if (y[0] * y[1] < 0.0) {
            nbPoints = 2;
            signChangeIndex = 1;
        } else {
            y[2] = this.computeObjectiveValue(x[2]);
            if (y[2] == 0.0) {
                return new BracketedUnivariateSolver.Interval(x[2], y[2], x[2], y[2]);
            }
            if (y[1] * y[2] < 0.0) {
                nbPoints = 3;
                signChangeIndex = 2;
            } else {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_BRACKETING_INTERVAL, x[0], x[2], y[0], y[2]);
            }
        }
        double[] tmpX = new double[x.length];
        double xA = x[signChangeIndex - 1];
        double yA = y[signChangeIndex - 1];
        double absYA = FastMath.abs(yA);
        int agingA = 0;
        double xB = x[signChangeIndex];
        double yB = y[signChangeIndex];
        double absYB = FastMath.abs(yB);
        int agingB = 0;
        double xTol;
        while (!(xB - xA <= (xTol = this.getAbsoluteAccuracy() + this.getRelativeAccuracy() * FastMath.max(FastMath.abs(xA), FastMath.abs(xB))) || FastMath.max(absYA, absYB) < this.getFunctionValueAccuracy() || Precision.equals(xA, xB, 1))) {
            double nextY;
            double nextX;
            double targetY;
            double weightA;
            if (agingA >= 2) {
                int p = agingA - 2;
                weightA = (1 << p) - 1;
                double weightB = p + 1;
                targetY = (weightA * yA - weightB * 0.0625 * yB) / (weightA + weightB);
            } else if (agingB >= 2) {
                int p = agingB - 2;
                weightA = p + 1;
                double weightB = (1 << p) - 1;
                targetY = (weightB * yB - weightA * 0.0625 * yA) / (weightA + weightB);
            } else {
                targetY = 0.0;
            }
            int start = 0;
            int end = nbPoints;
            do {
                System.arraycopy(x, start, tmpX, start, end - start);
                nextX = this.guessX(targetY, tmpX, y, start, end);
                if (nextX > xA && nextX < xB) continue;
                if (signChangeIndex - start >= end - signChangeIndex) {
                    ++start;
                } else {
                    --end;
                }
                nextX = Double.NaN;
            } while (Double.isNaN(nextX) && end - start > 1);
            if (Double.isNaN(nextX)) {
                nextX = xA + 0.5 * (xB - xA);
                start = signChangeIndex - 1;
                end = signChangeIndex;
            }
            if ((nextY = this.computeObjectiveValue(nextX)) == 0.0) {
                return new BracketedUnivariateSolver.Interval(nextX, nextY, nextX, nextY);
            }
            if (nbPoints > 2 && end - start != nbPoints) {
                nbPoints = end - start;
                System.arraycopy(x, start, x, 0, nbPoints);
                System.arraycopy(y, start, y, 0, nbPoints);
                signChangeIndex -= start;
            } else if (nbPoints == x.length) {
                --nbPoints;
                if (signChangeIndex >= (x.length + 1) / 2) {
                    System.arraycopy(x, 1, x, 0, nbPoints);
                    System.arraycopy(y, 1, y, 0, nbPoints);
                    --signChangeIndex;
                }
            }
            System.arraycopy(x, signChangeIndex, x, signChangeIndex + 1, nbPoints - signChangeIndex);
            x[signChangeIndex] = nextX;
            System.arraycopy(y, signChangeIndex, y, signChangeIndex + 1, nbPoints - signChangeIndex);
            y[signChangeIndex] = nextY;
            ++nbPoints;
            if (nextY * yA <= 0.0) {
                xB = nextX;
                yB = nextY;
                absYB = FastMath.abs(yB);
                ++agingA;
                agingB = 0;
                continue;
            }
            xA = nextX;
            yA = nextY;
            absYA = FastMath.abs(yA);
            agingA = 0;
            ++agingB;
            ++signChangeIndex;
        }
        return new BracketedUnivariateSolver.Interval(xA, yA, xB, yB);
    }

    private double guessX(double targetY, double[] x, double[] y, int start, int end) {
        int j;
        for (int i = start; i < end - 1; ++i) {
            int delta = i + 1 - start;
            for (j = end - 1; j > i; --j) {
                x[j] = (x[j] - x[j - 1]) / (y[j] - y[j - delta]);
            }
        }
        double x0 = 0.0;
        for (j = end - 1; j >= start; --j) {
            x0 = x[j] + x0 * (targetY - y[j]);
        }
        return x0;
    }

    @Override
    public double solve(int maxEval, UnivariateFunction f, double min, double max, AllowedSolution allowedSolution) throws MathIllegalArgumentException, MathIllegalStateException {
        this.allowed = allowedSolution;
        return super.solve(maxEval, f, min, max);
    }

    @Override
    public double solve(int maxEval, UnivariateFunction f, double min, double max, double startValue, AllowedSolution allowedSolution) throws MathIllegalArgumentException, MathIllegalStateException {
        this.allowed = allowedSolution;
        return super.solve(maxEval, f, min, max, startValue);
    }

    @Override
    public BracketedUnivariateSolver.Interval solveInterval(int maxEval, UnivariateFunction f, double min, double max, double startValue) throws MathIllegalArgumentException, MathIllegalStateException {
        this.setup(maxEval, f, min, max, startValue);
        this.allowed = null;
        return this.doSolveInterval();
    }
}

