/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.migration.ode;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.migration.ode.MainStateJacobianProvider;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.NamedParameterJacobianProvider;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.ParameterConfiguration;
import org.hipparchus.ode.ParametersController;
import org.hipparchus.ode.SecondaryODE;

@Deprecated
public class JacobianMatrices {
    private ExpandableODE efode = null;
    private int index = -1;
    private MainStateJacobianProvider jode;
    private ParametersController parametersController;
    private int stateDim;
    private MutableParameterConfiguration[] selectedParameters;
    private List<NamedParameterJacobianProvider> jacobianProviders;
    private int paramDim;
    private boolean dirtyParameter;
    private double[] matricesData;

    public JacobianMatrices(OrdinaryDifferentialEquation fode, double[] hY, String ... parameters) throws MathIllegalArgumentException {
        this(new MainStateJacobianWrapper(fode, hY), parameters);
    }

    public JacobianMatrices(MainStateJacobianProvider jode, String ... parameters) {
        int i;
        this.jode = jode;
        this.parametersController = null;
        this.stateDim = jode.getDimension();
        if (parameters == null) {
            this.selectedParameters = null;
            this.paramDim = 0;
        } else {
            this.selectedParameters = new MutableParameterConfiguration[parameters.length];
            for (i = 0; i < parameters.length; ++i) {
                this.selectedParameters[i] = new MutableParameterConfiguration(parameters[i], Double.NaN);
            }
            this.paramDim = parameters.length;
        }
        this.dirtyParameter = false;
        this.jacobianProviders = new ArrayList<NamedParameterJacobianProvider>();
        this.matricesData = new double[(this.stateDim + this.paramDim) * this.stateDim];
        for (i = 0; i < this.stateDim; ++i) {
            this.matricesData[i * (this.stateDim + 1)] = 1.0;
        }
    }

    public void registerVariationalEquations(ExpandableODE expandable) throws MathIllegalArgumentException, MismatchedEquations {
        MainStateJacobianProvider ode;
        MainStateJacobianProvider mainStateJacobianProvider = ode = this.jode instanceof MainStateJacobianWrapper ? ((MainStateJacobianWrapper)this.jode).ode : this.jode;
        if (expandable.getPrimary() != ode) {
            throw new MismatchedEquations();
        }
        this.efode = expandable;
        this.index = this.efode.addSecondaryEquations((SecondaryODE)new JacobiansSecondaryODE());
    }

    public ODEState setUpInitialState(ODEState initialState) {
        double[][] secondary = new double[this.efode.getMapper().getNumberOfEquations() - 1][];
        for (int i = 0; i < initialState.getNumberOfSecondaryStates(); ++i) {
            if (i + 1 == this.index) continue;
            secondary[i] = initialState.getSecondaryState(i + 1);
        }
        secondary[this.index - 1] = this.matricesData;
        return new ODEState(initialState.getTime(), initialState.getPrimaryState(), (double[][])secondary);
    }

    public void addParameterJacobianProvider(NamedParameterJacobianProvider provider) {
        this.jacobianProviders.add(provider);
    }

    @Deprecated
    public void setParameterizedODE(ParametersController pc) {
        this.setParametersController(pc);
    }

    public void setParametersController(ParametersController parametersController) {
        this.parametersController = parametersController;
        this.dirtyParameter = true;
    }

    public void setParameterStep(String parameter, double hP) throws MathIllegalArgumentException {
        for (MutableParameterConfiguration param : this.selectedParameters) {
            if (!parameter.equals(param.getParameterName())) continue;
            param.setHP(hP);
            this.dirtyParameter = true;
            return;
        }
        throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.UNKNOWN_PARAMETER, new Object[]{parameter});
    }

    public void setInitialMainStateJacobian(double[][] dYdY0) throws MathIllegalArgumentException {
        this.checkDimension(this.stateDim, dYdY0);
        this.checkDimension(this.stateDim, dYdY0[0]);
        int i = 0;
        for (double[] row : dYdY0) {
            System.arraycopy(row, 0, this.matricesData, i, this.stateDim);
            i += this.stateDim;
        }
    }

    public void setInitialParameterJacobian(String pName, double[] dYdP) throws MathIllegalArgumentException {
        this.checkDimension(this.stateDim, dYdP);
        int i = this.stateDim * this.stateDim;
        for (MutableParameterConfiguration param : this.selectedParameters) {
            if (pName.equals(param.getParameterName())) {
                System.arraycopy(dYdP, 0, this.matricesData, i, this.stateDim);
                return;
            }
            i += this.stateDim;
        }
        throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.UNKNOWN_PARAMETER, new Object[]{pName});
    }

    public double[][] extractMainSetJacobian(ODEState state) {
        double[] p = state.getSecondaryState(this.index);
        double[][] dYdY0 = new double[this.stateDim][this.stateDim];
        int j = 0;
        for (int i = 0; i < this.stateDim; ++i) {
            System.arraycopy(p, j, dYdY0[i], 0, this.stateDim);
            j += this.stateDim;
        }
        return dYdY0;
    }

    public double[] extractParameterJacobian(ODEState state, String pName) {
        double[] p = state.getSecondaryState(this.index);
        double[] dYdP = new double[this.stateDim];
        int i = this.stateDim * this.stateDim;
        for (MutableParameterConfiguration param : this.selectedParameters) {
            if (param.getParameterName().equals(pName)) {
                System.arraycopy(p, i, dYdP, 0, this.stateDim);
                break;
            }
            i += this.stateDim;
        }
        return dYdP;
    }

    private void checkDimension(int expected, Object array) throws MathIllegalArgumentException {
        int arrayDimension;
        int n = arrayDimension = array == null ? 0 : Array.getLength(array);
        if (arrayDimension != expected) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{arrayDimension, expected});
        }
    }

    private static class MutableParameterConfiguration {
        private String parameterName;
        private double hP;

        MutableParameterConfiguration(String parameterName, double hP) {
            this.parameterName = parameterName;
            this.hP = hP;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public double getHP() {
            return this.hP;
        }

        public void setHP(double hParam) {
            this.hP = hParam;
        }
    }

    public static class MismatchedEquations
    extends MathIllegalArgumentException {
        private static final long serialVersionUID = 20120902L;

        public MismatchedEquations() {
            super((Localizable)LocalizedODEFormats.UNMATCHED_ODE_IN_EXPANDED_SET, new Object[0]);
        }
    }

    private static class MainStateJacobianWrapper
    implements MainStateJacobianProvider {
        private final OrdinaryDifferentialEquation ode;
        private final double[] hY;

        MainStateJacobianWrapper(OrdinaryDifferentialEquation ode, double[] hY) throws MathIllegalArgumentException {
            this.ode = ode;
            this.hY = (double[])hY.clone();
            if (hY.length != ode.getDimension()) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{ode.getDimension(), hY.length});
            }
        }

        public int getDimension() {
            return this.ode.getDimension();
        }

        public double[] computeDerivatives(double t, double[] y) throws MathIllegalArgumentException, MathIllegalStateException {
            return this.ode.computeDerivatives(t, y);
        }

        @Override
        public double[][] computeMainStateJacobian(double t, double[] y, double[] yDot) throws MathIllegalArgumentException, MathIllegalStateException {
            int n = this.ode.getDimension();
            double[][] dFdY = new double[n][n];
            for (int j = 0; j < n; ++j) {
                double savedYj = y[j];
                int n2 = j;
                y[n2] = y[n2] + this.hY[j];
                double[] tmpDot = this.ode.computeDerivatives(t, y);
                for (int i = 0; i < n; ++i) {
                    dFdY[i][j] = (tmpDot[i] - yDot[i]) / this.hY[j];
                }
                y[j] = savedYj;
            }
            return dFdY;
        }
    }

    private class JacobiansSecondaryODE
    implements SecondaryODE {
        private JacobiansSecondaryODE() {
        }

        public int getDimension() {
            return JacobianMatrices.this.stateDim * (JacobianMatrices.this.stateDim + JacobianMatrices.this.paramDim);
        }

        public double[] computeDerivatives(double t, double[] y, double[] yDot, double[] z) throws MathIllegalArgumentException, MathIllegalStateException {
            try {
                Constructor configCtr = ParameterConfiguration.class.getDeclaredConstructor(String.class, Double.TYPE);
                configCtr.setAccessible(true);
                Constructor<?> providerCtr = Class.forName("org.hipparchus.ode.ParameterJacobianWrapper").getDeclaredConstructor(OrdinaryDifferentialEquation.class, double[].class, ParametersController.class, ParameterConfiguration[].class);
                providerCtr.setAccessible(true);
                if (JacobianMatrices.this.dirtyParameter && JacobianMatrices.this.paramDim != 0) {
                    ParameterConfiguration[] immutable = new ParameterConfiguration[JacobianMatrices.this.selectedParameters.length];
                    for (int i = 0; i < JacobianMatrices.this.selectedParameters.length; ++i) {
                        immutable[i] = (ParameterConfiguration)configCtr.newInstance(JacobianMatrices.this.selectedParameters[i].getParameterName(), JacobianMatrices.this.selectedParameters[i].getHP());
                    }
                    JacobianMatrices.this.jacobianProviders.add(providerCtr.newInstance(JacobianMatrices.this.jode, new double[JacobianMatrices.this.jode.getDimension()], JacobianMatrices.this.parametersController, immutable));
                    JacobianMatrices.this.dirtyParameter = false;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new MathIllegalStateException((Throwable)e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, new Object[]{e.getLocalizedMessage()});
            }
            double[][] dFdY = JacobianMatrices.this.jode.computeMainStateJacobian(t, y, yDot);
            double[] zDot = new double[z.length];
            for (int i = 0; i < JacobianMatrices.this.stateDim; ++i) {
                double[] dFdYi = dFdY[i];
                for (int j = 0; j < JacobianMatrices.this.stateDim; ++j) {
                    int startIndex;
                    double s = 0.0;
                    int zIndex = startIndex = j;
                    for (int l = 0; l < JacobianMatrices.this.stateDim; ++l) {
                        s += dFdYi[l] * z[zIndex];
                        zIndex += JacobianMatrices.this.stateDim;
                    }
                    zDot[startIndex + i * ((JacobianMatrices)JacobianMatrices.this).stateDim] = s;
                }
            }
            if (JacobianMatrices.this.paramDim != 0) {
                int startIndex = JacobianMatrices.this.stateDim * JacobianMatrices.this.stateDim;
                for (MutableParameterConfiguration param : JacobianMatrices.this.selectedParameters) {
                    boolean found = false;
                    for (int k = 0; !found && k < JacobianMatrices.this.jacobianProviders.size(); ++k) {
                        NamedParameterJacobianProvider provider = (NamedParameterJacobianProvider)JacobianMatrices.this.jacobianProviders.get(k);
                        if (!provider.isSupported(param.getParameterName())) continue;
                        double[] dFdP = provider.computeParameterJacobian(t, y, yDot, param.getParameterName());
                        for (int i = 0; i < JacobianMatrices.this.stateDim; ++i) {
                            double[] dFdYi = dFdY[i];
                            int zIndex = startIndex;
                            double s = dFdP[i];
                            for (int l = 0; l < JacobianMatrices.this.stateDim; ++l) {
                                s += dFdYi[l] * z[zIndex];
                                ++zIndex;
                            }
                            zDot[startIndex + i] = s;
                        }
                        found = true;
                    }
                    if (!found) {
                        Arrays.fill(zDot, startIndex, startIndex + JacobianMatrices.this.stateDim, 0.0);
                    }
                    startIndex += JacobianMatrices.this.stateDim;
                }
            }
            return zDot;
        }
    }
}

