/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment.measurements;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.rugged.adjustment.measurements.SensorMapping;
import org.orekit.rugged.linesensor.SensorPixel;

public class SensorToGroundMapping {
    private static final String RUGGED = "Rugged";
    private final String sensorName;
    private final SensorMapping<GeodeticPoint> groundMapping;

    public SensorToGroundMapping(String sensorName) {
        this(RUGGED, sensorName);
    }

    public SensorToGroundMapping(String ruggedName, String sensorName) {
        this.sensorName = sensorName;
        this.groundMapping = new SensorMapping(sensorName, ruggedName);
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public String getRuggedName() {
        return this.groundMapping.getRuggedName();
    }

    public void addMapping(SensorPixel pixel, GeodeticPoint groundPoint) {
        this.groundMapping.addMapping(pixel, groundPoint);
    }

    public Set<Map.Entry<SensorPixel, GeodeticPoint>> getMapping() {
        return Collections.unmodifiableSet(this.groundMapping.getMapping());
    }
}

